/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFileGistImpl<Data>
implements VirtualFileGist<Data> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.gist.VirtualFileGist");
    private static final int ourInternalVersion = 2;
    @NotNull
    private final String myId;
    private final int myVersion;
    @NotNull
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    @NotNull
    private final DataExternalizer<Data> myExternalizer;
    private static final Map<Pair<String, Integer>, FileAttribute> ourAttributes = FactoryMap.create(key -> new FileAttribute((String)key.first, ((Integer)key.second).intValue(), false));

    VirtualFileGistImpl(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (id == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(1);
        }
        if (calcData == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(2);
        }
        this.myId = id;
        this.myVersion = version;
        this.myExternalizer = externalizer;
        this.myCalculator = calcData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Data getFileData(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (!(file2 instanceof VirtualFileWithId)) {
            return (Data)this.myCalculator.calcData(project, file2);
        }
        int stamp = PersistentFS.getInstance().getModificationCount(file2) + ((GistManagerImpl)GistManager.getInstance()).getReindexCount();
        try (DataInputStream stream = this.getFileAttribute(project).readAttribute(file2);){
            if (stream != null && DataInputOutputUtil.readINT((DataInput)stream) == stamp) {
                Object object = stream.readBoolean() ? this.myExternalizer.read((DataInput)stream) : null;
                return (Data)object;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        Object result2 = this.myCalculator.calcData(project, file2);
        this.cacheResult(stamp, result2, project, file2);
        return (Data)result2;
    }

    private void cacheResult(int modCount, @Nullable Data result2, Project project, VirtualFile file2) {
        try (DataOutputStream out = this.getFileAttribute(project).writeAttribute(file2);){
            DataInputOutputUtil.writeINT((DataOutput)out, (int)modCount);
            out.writeBoolean(result2 != null);
            if (result2 != null) {
                this.myExternalizer.save((DataOutput)out, result2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAttribute getFileAttribute(@Nullable Project project) {
        Map<Pair<String, Integer>, FileAttribute> map2 = ourAttributes;
        synchronized (map2) {
            return ourAttributes.get(Pair.create((Object)(this.myId + (project == null ? "###noProject###" : project.getLocationHash())), (Object)(this.myVersion + 2)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calcData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/gist/VirtualFileGistImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

