/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedFilesListener
implements BulkFileListener,
VirtualFileListener {
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    @Nullable
    private final String myConfigPath = IndexedFilesListener.calcConfigPath(PathManager.getConfigPath());
    @Nullable
    private final String myLogPath = IndexedFilesListener.calcConfigPath(PathManager.getLogPath());

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(0);
        }
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(1);
        }
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(2);
        }
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(3);
        }
        this.invalidateIndicesRecursively(event.getFile(), false);
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(4);
        }
        this.invalidateIndicesRecursively(event.getFile(), true);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(5);
        }
        this.buildIndicesForFileRecursively(event.getFile(), true);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        String propertyName;
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(6);
        }
        if ((propertyName = event.getPropertyName()).equals("name")) {
            this.invalidateIndicesRecursively(event.getFile(), false);
        } else if (propertyName.equals("encoding")) {
            this.invalidateIndicesRecursively(event.getFile(), true);
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        String propertyName;
        if (event == null) {
            IndexedFilesListener.$$$reportNull$$$0(7);
        }
        if ((propertyName = event.getPropertyName()).equals("name")) {
            this.buildIndicesForFileRecursively(event.getFile(), false);
        } else if (propertyName.equals("encoding")) {
            this.buildIndicesForFileRecursively(event.getFile(), true);
        }
    }

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(8);
        }
        if (file2.isDirectory()) {
            ContentIterator iterator = fileOrDir -> {
                this.buildIndicesForFile(fileOrDir, contentChange);
                return true;
            };
            this.iterateIndexableFiles(file2, iterator);
        } else {
            this.buildIndicesForFile(file2, contentChange);
        }
    }

    protected boolean invalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(9);
        }
        if (this.isUnderConfigOrSystem(file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            this.doInvalidateIndicesForFile(file2, contentChange);
            if (!FileBasedIndexImpl.isMock(file2) && !this.myManagingFS.wereChildrenAccessed(file2)) {
                return false;
            }
        } else {
            this.doInvalidateIndicesForFile(file2, contentChange);
        }
        return true;
    }

    protected abstract void iterateIndexableFiles(@NotNull VirtualFile var1, @NotNull ContentIterator var2);

    protected abstract void buildIndicesForFile(@NotNull VirtualFile var1, boolean var2);

    protected abstract void doInvalidateIndicesForFile(@NotNull VirtualFile var1, boolean var2);

    protected void invalidateIndicesRecursively(@NotNull VirtualFile file2, final boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(10);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, contentChange);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/indexing/IndexedFilesListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(11);
        }
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(12);
        }
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    @Nullable
    private static String calcConfigPath(@NotNull String path) {
        if (path == null) {
            IndexedFilesListener.$$$reportNull$$$0(13);
        }
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            FileBasedIndexImpl.LOG.info((Throwable)e);
            return null;
        }
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(14);
        }
        String filePath = file2.getPath();
        return this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath) || this.myLogPath != null && FileUtil.startsWith((String)filePath, (String)this.myLogPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/IndexedFilesListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCopied";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeContentsChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildIndicesForFileRecursively";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateIndicesForFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateIndicesRecursively";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "calcConfigPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderConfigOrSystem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

