/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.HtmlTableBuilder;
import com.intellij.vcs.log.ui.frame.ReferencesPanel;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPanel
extends JBPanel {
    public static final int BOTTOM_BORDER = 2;
    private static final int REFERENCES_BORDER = 12;
    private static final int TOP_BORDER = 4;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final ReferencesPanel myBranchesPanel;
    @NotNull
    private final ReferencesPanel myTagsPanel;
    @NotNull
    private final DataPanel myDataPanel;
    @NotNull
    private final BranchesPanel myContainingBranchesPanel;
    @NotNull
    private final RootPanel myRootPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @Nullable
    private VcsFullCommitDetails myCommit;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager) {
        if (logData == null) {
            CommitPanel.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            CommitPanel.$$$reportNull$$$0(1);
        }
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.setOpaque(false);
        this.myRootPanel = new RootPanel();
        this.myBranchesPanel = new ReferencesPanel();
        this.myBranchesPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        this.myTagsPanel = new ReferencesPanel();
        this.myTagsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        this.myDataPanel = new DataPanel(this.myLogData.getProject());
        this.myContainingBranchesPanel = new BranchesPanel();
        this.add(this.myRootPanel);
        this.add(this.myDataPanel);
        this.add(this.myBranchesPanel);
        this.add(this.myTagsPanel);
        this.add(this.myContainingBranchesPanel);
        this.setBorder((Border)CommitPanel.getDetailsBorder());
    }

    public void setCommit(@NotNull VcsFullCommitDetails commitData) {
        if (commitData == null) {
            CommitPanel.$$$reportNull$$$0(2);
        }
        if (!Comparing.equal((Object)this.myCommit, (Object)commitData)) {
            if (commitData instanceof LoadingDetails) {
                this.myDataPanel.setData(null);
                this.myRootPanel.setRoot("", null);
            } else {
                this.myDataPanel.setData(commitData);
                VirtualFile root = commitData.getRoot();
                if (this.myColorManager.isMultipleRoots()) {
                    this.myRootPanel.setRoot(root.getName(), (Color)VcsLogGraphTable.getRootBackgroundColor(root, this.myColorManager));
                } else {
                    this.myRootPanel.setRoot("", null);
                }
            }
            this.myCommit = commitData;
        }
        List<String> branches = null;
        if (!(commitData instanceof LoadingDetails)) {
            branches = this.myLogData.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), (Hash)commitData.getId());
        }
        this.myContainingBranchesPanel.setBranches(branches);
        this.myDataPanel.update();
        this.myContainingBranchesPanel.update();
        this.revalidate();
    }

    public void setRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            CommitPanel.$$$reportNull$$$0(3);
        }
        List<VcsRef> references = this.sortRefs(refs);
        this.myBranchesPanel.setReferences(references.stream().filter(ref -> ref.getType().isBranch()).collect(Collectors.toList()));
        this.myTagsPanel.setReferences(references.stream().filter(ref -> !ref.getType().isBranch()).collect(Collectors.toList()));
    }

    public void update() {
        this.myDataPanel.update();
        this.myRootPanel.update();
        this.myBranchesPanel.update();
        this.myTagsPanel.update();
        this.myContainingBranchesPanel.update();
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            this.myContainingBranchesPanel.setBranches(this.myLogData.getContainingBranchesGetter().getContainingBranchesFromCache(this.myCommit.getRoot(), (Hash)this.myCommit.getId()));
        } else {
            this.myContainingBranchesPanel.setBranches(null);
        }
        this.myContainingBranchesPanel.update();
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Collection<VcsRef> refs) {
        VcsRef ref;
        if (refs == null) {
            CommitPanel.$$$reportNull$$$0(4);
        }
        if ((ref = (VcsRef)ContainerUtil.getFirstItem(refs)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                CommitPanel.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List list3 = ContainerUtil.sorted(refs, (Comparator)this.myLogData.getLogProvider(ref.getRoot()).getReferenceManager().getLabelsOrderComparator());
        if (list3 == null) {
            CommitPanel.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @NotNull
    public static JBEmptyBorder getDetailsBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        if (jBEmptyBorder == null) {
            CommitPanel.$$$reportNull$$$0(7);
        }
        return jBEmptyBorder;
    }

    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public boolean isExpanded() {
        return this.myContainingBranchesPanel.isExpanded();
    }

    @NotNull
    public static Color getCommitDetailsBackground() {
        Color color = UIUtil.getTableBackground();
        if (color == null) {
            CommitPanel.$$$reportNull$$$0(8);
        }
        return color;
    }

    @NotNull
    public static String formatDateTime(long time) {
        String string = " on " + DateFormatUtil.formatDate((long)time) + " at " + DateFormatUtil.formatTime((long)time);
        if (string == null) {
            CommitPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitData";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sortRefs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailsBorder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitDetailsBackground";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCommit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRefs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortRefs";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootPanel
    extends JPanel {
        private static final int RIGHT_BORDER = Math.max(UIUtil.getScrollBarWidth(), JBUI.scale((int)14));
        @NotNull
        private final RectanglePainter myLabelPainter;
        @NotNull
        private String myText = "";
        @NotNull
        private Color myColor = CommitPanel.getCommitDetailsBackground();

        RootPanel() {
            this.myLabelPainter = new RectanglePainter(true){

                @Override
                protected Font getLabelFont() {
                    return RootPanel.getLabelFont();
                }
            };
            this.setOpaque(false);
        }

        @NotNull
        private static Font getLabelFont() {
            Font font = VcsHistoryUtil.getCommitDetailsFont();
            Font font2 = font.deriveFont((float)font.getSize() - 2.0f);
            if (font2 == null) {
                RootPanel.$$$reportNull$$$0(0);
            }
            return font2;
        }

        public void setRoot(@NotNull String text, @Nullable Color color) {
            if (text == null) {
                RootPanel.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myColor = text.isEmpty() || color == null ? CommitPanel.getCommitDetailsBackground() : color;
        }

        public void update() {
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.myText.isEmpty()) {
                Dimension painterSize = this.myLabelPainter.calculateSize(this.myText, this.getFontMetrics(RootPanel.getLabelFont()));
                JBScrollPane scrollPane = (JBScrollPane)UIUtil.getParentOfType(JBScrollPane.class, (Component)this);
                int width = scrollPane == null ? this.getWidth() : scrollPane.getViewport().getViewRect().x + scrollPane.getWidth();
                this.myLabelPainter.paint((Graphics2D)g, this.myText, width - painterSize.width - RIGHT_BORDER, 0, this.myColor);
            }
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myText.isEmpty()) {
                return new JBDimension(0, 4);
            }
            Dimension size = this.myLabelPainter.calculateSize(this.myText, this.getFontMetrics(RootPanel.getLabelFont()));
            return new Dimension(size.width + JBUI.scale((int)RIGHT_BORDER), size.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPanel$RootPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabelFont";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPanel$RootPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setRoot";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BranchesPanel
    extends HtmlPanel {
        private static final int PER_ROW = 2;
        private static final String LINK_HREF = "show-hide-branches";
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded = false;

        BranchesPanel() {
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)12, (int)4, (int)2, (int)0));
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && LINK_HREF.equals(e.getDescription())) {
                this.myExpanded = !this.myExpanded;
                this.update();
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches == null ? null : branches;
            this.myExpanded = false;
        }

        void update() {
            this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.getBranchesText() + "</body></html>");
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getBranchesText() {
            if (this.myBranches == null) {
                if ("<i>In branches: loading...</i>" == null) {
                    BranchesPanel.$$$reportNull$$$0(0);
                }
                return "<i>In branches: loading...</i>";
            }
            if (this.myBranches.isEmpty()) {
                if ("<i>Not in any branch</i>" == null) {
                    BranchesPanel.$$$reportNull$$$0(1);
                }
                return "<i>Not in any branch</i>";
            }
            if (this.myExpanded) {
                int rowCount = (int)Math.ceil((double)this.myBranches.size() / 2.0);
                int[] means = new int[1];
                int[] max = new int[1];
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < 1; ++j) {
                        int index = rowCount * j + i;
                        if (index >= this.myBranches.size()) continue;
                        int n = j;
                        means[n] = means[n] + this.myBranches.get(index).length();
                        max[j] = Math.max(this.myBranches.get(index).length(), max[j]);
                    }
                }
                int j = 0;
                while (j < 1) {
                    int n = j++;
                    means[n] = means[n] / rowCount;
                }
                HtmlTableBuilder builder = new HtmlTableBuilder();
                for (int i = 0; i < rowCount; ++i) {
                    builder.startRow();
                    for (int j2 = 0; j2 < 2; ++j2) {
                        int index = rowCount * j2 + i;
                        if (index >= this.myBranches.size()) {
                            builder.append("");
                            continue;
                        }
                        String branch = this.myBranches.get(index);
                        if (index != this.myBranches.size() - 1) {
                            int space = 0;
                            if (j2 < 1 && branch.length() == max[j2]) {
                                space = Math.max(means[j2] + 20 - max[j2], 5);
                            }
                            builder.append(branch + StringUtil.repeat((String)"&nbsp;", (int)space), "left");
                            continue;
                        }
                        builder.append(branch, "left");
                    }
                    builder.endRow();
                }
                String string = "<i>In " + this.myBranches.size() + " branches:</i> <a href=\"" + LINK_HREF + "\"><i>(click to hide)</i></a><br>" + builder.build();
                if (string == null) {
                    BranchesPanel.$$$reportNull$$$0(2);
                }
                return string;
            }
            int totalMax = 0;
            int charCount = 0;
            for (String b : this.myBranches) {
                ++totalMax;
                if ((charCount += b.length()) < 50) continue;
                break;
            }
            String branchText = this.myBranches.size() <= totalMax ? StringUtil.join(this.myBranches, (String)", ") : StringUtil.join((Collection)ContainerUtil.getFirstItems(this.myBranches, (int)totalMax), (String)", ") + "\u2026 <a href=\"" + LINK_HREF + "\"><i>(click to show all)</i></a>";
            String string = "<i>In " + this.myBranches.size() + StringUtil.pluralize((String)" branch", (int)this.myBranches.size()) + ":</i> " + branchText;
            if (string == null) {
                BranchesPanel.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$BranchesPanel", "getBranchesText"));
        }
    }

    private static class DataPanel
    extends HtmlPanel {
        @NotNull
        private final Project myProject;
        @Nullable
        private String myMainText;

        DataPanel(@NotNull Project project) {
            if (project == null) {
                DataPanel.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)2, (int)0));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.myMainText = null;
            } else {
                String hash = ((Hash)commit.getId()).toShortString();
                String hashAndAuthor = DataPanel.getHtmlWithFonts(hash + " " + DataPanel.getAuthorText(commit, hash.length() + 1));
                String messageText = this.getMessageText(commit);
                this.myMainText = messageText + "<br/><br/>" + hashAndAuthor;
            }
        }

        private void customizeLinksStyle() {
            Document document = this.getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                String linkColor = "#" + ColorUtil.toHex((Color)UI.getColor((String)"link.foreground"));
                styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
            }
        }

        @NotNull
        private static String getHtmlWithFonts(@NotNull String input) {
            if (input == null) {
                DataPanel.$$$reportNull$$$0(1);
            }
            String string = DataPanel.getHtmlWithFonts(input, VcsHistoryUtil.getCommitDetailsFont().getStyle());
            if (string == null) {
                DataPanel.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private static String getHtmlWithFonts(@NotNull String input, int style) {
            if (input == null) {
                DataPanel.$$$reportNull$$$0(3);
            }
            String string = FontUtil.getHtmlWithFonts(input, style, VcsHistoryUtil.getCommitDetailsFont());
            if (string == null) {
                DataPanel.$$$reportNull$$$0(4);
            }
            return string;
        }

        void update() {
            if (this.myMainText == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.myMainText + "</body></html>");
            }
            this.customizeLinksStyle();
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getMessageText(@NotNull VcsFullCommitDetails commit) {
            String fullMessage;
            int separator;
            if (commit == null) {
                DataPanel.$$$reportNull$$$0(5);
            }
            String subject = (separator = (fullMessage = commit.getFullMessage()).indexOf("\n\n")) > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            String string = "<b>" + DataPanel.getHtmlWithFonts(DataPanel.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject)), 1) + "</b>" + DataPanel.getHtmlWithFonts(DataPanel.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description)));
            if (string == null) {
                DataPanel.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private static String escapeMultipleSpaces(@NotNull String text) {
            if (text == null) {
                DataPanel.$$$reportNull$$$0(7);
            }
            StringBuilder result2 = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == ' ') {
                    if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                        result2.append(' ');
                        continue;
                    }
                    result2.append("&nbsp;");
                    continue;
                }
                result2.append(text.charAt(i));
            }
            String string = result2.toString();
            if (string == null) {
                DataPanel.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        private static String getAuthorText(@NotNull VcsFullCommitDetails commit, int offset) {
            if (commit == null) {
                DataPanel.$$$reportNull$$$0(9);
            }
            long authorTime = commit.getAuthorTime();
            long commitTime = commit.getCommitTime();
            String authorText = DataPanel.getAuthorName(commit.getAuthor()) + CommitPanel.formatDateTime(authorTime);
            if (!VcsUserUtil.isSamePerson(commit.getAuthor(), commit.getCommitter())) {
                String commitTimeText = authorTime != commitTime ? CommitPanel.formatDateTime(commitTime) : "";
                authorText = authorText + DataPanel.getCommitterText(commit.getCommitter(), commitTimeText, offset);
            } else if (authorTime != commitTime) {
                authorText = authorText + DataPanel.getCommitterText(null, CommitPanel.formatDateTime(commitTime), offset);
            }
            String string = authorText;
            if (string == null) {
                DataPanel.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        private static String getCommitterText(@Nullable VcsUser committer, @NotNull String commitTimeText, int offset) {
            if (commitTimeText == null) {
                DataPanel.$$$reportNull$$$0(11);
            }
            String alignment = "<br/>" + StringUtil.repeat((String)"&nbsp;", (int)offset);
            String gray = ColorUtil.toHex((Color)JBColor.GRAY);
            String graySpan = "<span style='color:#" + gray + "'>";
            String text = alignment + graySpan + "committed";
            if (committer != null) {
                text = text + " by " + VcsUserUtil.getShortPresentation(committer);
                if (!committer.getEmail().isEmpty()) {
                    text = text + "</span>" + DataPanel.getEmailText(committer) + graySpan;
                }
            }
            String string = text = text + commitTimeText + "</span>";
            if (string == null) {
                DataPanel.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        private static String getAuthorName(@NotNull VcsUser user) {
            if (user == null) {
                DataPanel.$$$reportNull$$$0(13);
            }
            String username = VcsUserUtil.getShortPresentation(user);
            String string = user.getEmail().isEmpty() ? username : username + DataPanel.getEmailText(user);
            if (string == null) {
                DataPanel.$$$reportNull$$$0(14);
            }
            return string;
        }

        @NotNull
        private static String getEmailText(@NotNull VcsUser user) {
            if (user == null) {
                DataPanel.$$$reportNull$$$0(15);
            }
            String string = " <a href='mailto:" + user.getEmail() + "'>&lt;" + user.getEmail() + "&gt;</a>";
            if (string == null) {
                DataPanel.$$$reportNull$$$0(16);
            }
            return string;
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commit";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitTimeText";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHtmlWithFonts";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageText";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeMultipleSpaces";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorText";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitterText";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorName";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmailText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getHtmlWithFonts";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessageText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeMultipleSpaces";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getAuthorText";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommitterText";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getAuthorName";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmailText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

