/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class ToggleBreadcrumbsAction
extends ToggleAction
implements DumbAware {
    private static final Key<Boolean> FORCED_BREADCRUMBS = new Key("FORCED_BREADCRUMBS");

    ToggleBreadcrumbsAction() {
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleBreadcrumbsAction.$$$reportNull$$$0(0);
        }
        super.update(event);
        event.getPresentation().setEnabledAndVisible(this.isEnabled(ToggleBreadcrumbsAction.findEditor(event)));
    }

    boolean isEnabled(Editor editor) {
        FileViewProvider provider = BreadcrumbsXmlWrapper.findViewProvider(editor);
        return provider == null || null != BreadcrumbsXmlWrapper.findInfoProvider(false, provider);
    }

    public boolean isSelected(AnActionEvent event) {
        return this.isSelected(ToggleBreadcrumbsAction.findEditor(event));
    }

    boolean isSelected(Editor editor) {
        Boolean selected;
        if (editor != null && (selected = ToggleBreadcrumbsAction.getForcedShown(editor)) != null) {
            return selected;
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        boolean selected2 = settings.isBreadcrumbsShown();
        if (!selected2) {
            return false;
        }
        String languageID = ToggleBreadcrumbsAction.findLanguageID(editor);
        return languageID == null || settings.isBreadcrumbsShownFor(languageID);
    }

    public void setSelected(AnActionEvent event, boolean selected) {
        if (this.setSelected(selected, ToggleBreadcrumbsAction.findEditor(event))) {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    boolean setSelected(Boolean selected, Editor editor) {
        if (editor == null) {
            return false;
        }
        Boolean old = ToggleBreadcrumbsAction.getForcedShown(editor);
        editor.putUserData(FORCED_BREADCRUMBS, (Object)selected);
        return !Objects.equals(old, selected);
    }

    static Boolean getForcedShown(@NotNull Editor editor) {
        if (editor == null) {
            ToggleBreadcrumbsAction.$$$reportNull$$$0(1);
        }
        return (Boolean)editor.getUserData(FORCED_BREADCRUMBS);
    }

    static Editor findEditor(AnActionEvent event) {
        return event == null ? null : (Editor)event.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
    }

    static String findLanguageID(Editor editor) {
        FileViewProvider provider = BreadcrumbsXmlWrapper.findViewProvider(editor);
        return provider == null ? null : provider.getBaseLanguage().getID();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/ToggleBreadcrumbsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getForcedShown";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ShowHide
    extends ToggleBreadcrumbsAction {
        ShowHide() {
        }

        @Override
        boolean isEnabled(Editor editor) {
            return editor != null && super.isEnabled(editor);
        }
    }
}

