/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout.config;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.buildout.config.BuildoutCfgElementTypes;
import com.jetbrains.python.buildout.config.BuildoutCfgTokenTypes;
import org.jetbrains.annotations.NotNull;

public class BuildoutCfgParser
implements PsiParser,
BuildoutCfgElementTypes,
BuildoutCfgTokenTypes {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        Parsing parsing = new Parsing(builder);
        while (!builder.eof()) {
            if (parsing.parseSection()) continue;
            parsing.skipLine();
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            BuildoutCfgParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/BuildoutCfgParser", "parse"));
    }

    private class Parsing {
        private final PsiBuilder myBuilder;

        public Parsing(PsiBuilder builder) {
            this.myBuilder = builder;
        }

        public boolean parseSection() {
            PsiBuilder.Marker section = this.mark();
            boolean res = true;
            PsiBuilder.Marker sectionHeader = this.mark();
            if (this.parseSectionHeader()) {
                sectionHeader.done((IElementType)BuildoutCfgElementTypes.SECTION_HEADER);
            } else {
                this.error("Section name expected.");
                sectionHeader.drop();
                res = false;
            }
            while (this.is(BuildoutCfgTokenTypes.KEY_CHARACTERS)) {
                res = true;
                this.parseOption();
            }
            section.done((IElementType)BuildoutCfgElementTypes.SECTION);
            if (this.is(BuildoutCfgTokenTypes.VALUE_CHARACTERS)) {
                this.advance();
                this.error("Key expected.");
            }
            while (this.is(BuildoutCfgTokenTypes.VALUE_CHARACTERS)) {
                this.skipLine();
            }
            return res;
        }

        private void parseOption() {
            PsiBuilder.Marker option = this.myBuilder.mark();
            if (this.is(BuildoutCfgTokenTypes.KEY_CHARACTERS)) {
                this.doneAdvance(this.mark(), BuildoutCfgElementTypes.KEY);
            }
            if (this.is(BuildoutCfgTokenTypes.KEY_VALUE_SEPARATOR)) {
                this.advance();
            } else {
                this.error(": or = expected.");
            }
            PsiBuilder.Marker value = this.mark();
            while (this.is(BuildoutCfgTokenTypes.VALUE_CHARACTERS)) {
                this.doneAdvance(this.mark(), BuildoutCfgElementTypes.VALUE_LINE);
            }
            value.done((IElementType)BuildoutCfgElementTypes.VALUE);
            option.done((IElementType)BuildoutCfgElementTypes.OPTION);
        }

        private boolean parseSectionHeader() {
            if (this.is(BuildoutCfgTokenTypes.LBRACKET)) {
                this.advance();
                PsiBuilder.Marker sectionName = this.mark();
                boolean flag = false;
                while (this.is(BuildoutCfgTokenTypes.SECTION_NAME)) {
                    this.advance();
                    flag = true;
                }
                if (!flag) {
                    sectionName.drop();
                    return false;
                }
                sectionName.done((IElementType)BuildoutCfgTokenTypes.SECTION_NAME);
                if (this.is(BuildoutCfgTokenTypes.RBRACKET)) {
                    this.advance();
                } else {
                    this.error("] expected.");
                    this.skipLine();
                }
                return true;
            }
            return false;
        }

        private boolean is(IElementType type) {
            return this.myBuilder.getTokenType() == type;
        }

        private void error(String message) {
            this.myBuilder.error(message);
        }

        private PsiBuilder.Marker mark() {
            return this.myBuilder.mark();
        }

        public void doneAdvance(PsiBuilder.Marker marker, IElementType element) {
            this.myBuilder.advanceLexer();
            marker.done(element);
        }

        public void advance() {
            this.myBuilder.advanceLexer();
        }

        private void skipLine() {
            while (!(this.is(null) || this.is(BuildoutCfgTokenTypes.LBRACKET) || this.is(BuildoutCfgTokenTypes.KEY_CHARACTERS))) {
                this.myBuilder.advanceLexer();
            }
        }
    }
}

