/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.override;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import javax.swing.JTree;

public class PyMethodMember
extends PsiElementMemberChooserObject
implements ClassMember {
    private final String myFullName;

    private static String buildNameFor(PyElement element) {
        if (element instanceof PyFunction) {
            TypeEvalContext context = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile());
            List parameters = ((PyFunction)element).getParameters(context);
            StringBuilder result2 = new StringBuilder();
            result2.append(element.getName()).append('(');
            StringUtil.join((Iterable)parameters, parameter -> parameter.getPresentableText(true, context), (String)", ", (StringBuilder)result2);
            result2.append(')');
            return result2.toString();
        }
        PyClass cls = PyUtil.as(element, PyClass.class);
        if (cls != null && "types.InstanceType".equals(cls.getQualifiedName())) {
            return "<old-style class>";
        }
        return element.getName();
    }

    public PyMethodMember(PyElement element) {
        super((PsiElement)element, PyMethodMember.trimUnderscores(PyMethodMember.buildNameFor(element)), element.getIcon(0));
        this.myFullName = PyMethodMember.buildNameFor(element);
    }

    public static String trimUnderscores(String s) {
        return StringUtil.trimStart((String)StringUtil.trimStart((String)s, (String)"_"), (String)"_");
    }

    public MemberChooserObject getParentNodeDelegate() {
        PyElement element = (PyElement)this.getPsiElement();
        PyClass parent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        assert (parent != null);
        return new PyMethodMember(parent);
    }

    public void renderTreeNode(SimpleColoredComponent component, JTree tree) {
        component.append(this.myFullName, this.getTextAttributes(tree));
        component.setIcon(this.getPsiElement().getIcon(0));
    }
}

