/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.override;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.override.PyMethodMember;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOverrideImplementUtil {
    @Nullable
    public static PyClass getContextClass(@NotNull Editor editor, @NotNull PsiFile file2) {
        PyClass pyClass;
        PsiElement lastChild;
        int offset;
        PsiElement element;
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(1);
        }
        if ((element = file2.findElementAt(offset = editor.getCaretModel().getOffset())) == null && (lastChild = file2.getLastChild()) != null && offset >= lastChild.getTextRange().getStartOffset() && offset <= lastChild.getTextRange().getEndOffset()) {
            element = lastChild;
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false)) == null && element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof PyClass) {
            return (PyClass)element.getPrevSibling();
        }
        return pyClass;
    }

    public static void chooseAndOverrideMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(3);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyPsiUtils.assertValid((PsiElement)cls);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, cls, PyOverrideImplementUtil.getAllSuperMethods(cls, context), false);
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(7);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(9);
        }
        PyOverrideImplementUtil.chooseAndImplementMethods(project, editor, cls, PyOverrideImplementUtil.getAllSuperAbstractMethods(cls, context));
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull Collection<PyFunction> methods) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(11);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(12);
        }
        if (methods == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(13);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyPsiUtils.assertValid((PsiElement)cls);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, cls, methods, true);
    }

    private static void chooseAndOverrideOrImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull Collection<PyFunction> methods, boolean implement) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(15);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(16);
        }
        if (methods == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(17);
        }
        ArrayList<PyMethodMember> elements = new ArrayList<PyMethodMember>();
        for (PyFunction method : methods) {
            String name = method.getName();
            if (name == null || PyUtil.isClassPrivateName(name) || cls.findMethodByName(name, false, null) != null) continue;
            PyMethodMember member = new PyMethodMember(method);
            elements.add(member);
        }
        if (elements.isEmpty()) {
            return;
        }
        MemberChooser<PyMethodMember> chooser = new MemberChooser<PyMethodMember>(elements.toArray(new PyMethodMember[elements.size()]), false, true, project){

            @Override
            protected SpeedSearchComparator getSpeedSearchComparator() {
                return new SpeedSearchComparator(false){

                    @Override
                    @Nullable
                    public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text) {
                        if (pattern == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (text == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return super.matchingFragments(PyMethodMember.trimUnderscores(pattern), text);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "pattern";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil$1$1";
                        objectArray[2] = "matchingFragments";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
        chooser.setTitle(implement ? "Select Methods to Implement" : "Select Methods to Override");
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return;
        }
        PyOverrideImplementUtil.overrideMethods(editor, cls, chooser.getSelectedElements(), implement);
    }

    public static void overrideMethods(final Editor editor, final PyClass pyClass, final List<PyMethodMember> membersToOverride, final boolean implement) {
        if (membersToOverride == null) {
            return;
        }
        new WriteCommandAction(pyClass.getProject(), new PsiFile[]{pyClass.getContainingFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                PyOverrideImplementUtil.write(pyClass, membersToOverride, editor, implement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil$2", "run"));
            }
        }.execute();
    }

    private static void write(@NotNull PyClass pyClass, @NotNull List<PyMethodMember> newMembers, @NotNull Editor editor, boolean implement) {
        if (pyClass == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(18);
        }
        if (newMembers == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(20);
        }
        PyStatementList statementList = pyClass.getStatementList();
        int offset = editor.getCaretModel().getOffset();
        PyStatement anchor = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (statement.getTextRange().getStartOffset() >= offset && (!(statement instanceof PyExpressionStatement) || !(((PyExpressionStatement)statement).getExpression() instanceof PyStringLiteralExpression))) continue;
            anchor = statement;
        }
        PyFunction element = null;
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)statementList);
        for (PyMethodMember newMember : Lists.reverse(newMembers)) {
            PyFunction baseFunction = (PyFunction)newMember.getPsiElement();
            PyFunctionBuilder builder = PyOverrideImplementUtil.buildOverriddenFunction(pyClass, baseFunction, implement);
            PyFunction function = builder.addFunctionAfter((PsiElement)statementList, (PsiElement)anchor, languageLevel);
            element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function);
        }
        PyPsiUtils.removeRedundantPass(statementList);
        if (element != null) {
            PyStatementList targetStatementList = element.getStatementList();
            int start = targetStatementList.getTextRange().getStartOffset();
            editor.getCaretModel().moveToOffset(start);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(start, element.getTextRange().getEndOffset());
        }
    }

    private static PyFunctionBuilder buildOverriddenFunction(PyClass pyClass, PyFunction baseFunction, boolean implement) {
        boolean overridingNew = "__new__".equals(baseFunction.getName());
        assert (baseFunction.getName() != null);
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(baseFunction.getName(), baseFunction);
        PyDecoratorList decorators = baseFunction.getDecoratorList();
        boolean baseMethodIsStatic = false;
        if (decorators != null) {
            if (decorators.findDecorator("classmethod") != null) {
                pyFunctionBuilder.decorate("classmethod");
            } else if (decorators.findDecorator("staticmethod") != null) {
                baseMethodIsStatic = true;
                pyFunctionBuilder.decorate("staticmethod");
            } else if (decorators.findDecorator("property") != null || decorators.findDecorator("abstractproperty") != null) {
                pyFunctionBuilder.decorate("property");
            }
        }
        LanguageLevel level = LanguageLevel.forElement((PsiElement)pyClass);
        PyAnnotation anno = baseFunction.getAnnotation();
        if (anno != null && level.isAtLeast(LanguageLevel.PYTHON30)) {
            pyFunctionBuilder.annotation(anno.getText());
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(baseFunction.getProject(), baseFunction.getContainingFile());
        List baseParams = baseFunction.getParameters(context);
        for (PyCallableParameter parameter : baseParams) {
            PyParameter psi = parameter.getParameter();
            PyNamedParameter namedParameter = PyUtil.as(psi, PyNamedParameter.class);
            if (namedParameter != null) {
                PyExpression defaultValue;
                StringBuilder parameterBuilder = new StringBuilder();
                if (namedParameter.isPositionalContainer()) {
                    parameterBuilder.append("*");
                } else if (namedParameter.isKeywordContainer()) {
                    parameterBuilder.append("**");
                }
                parameterBuilder.append(namedParameter.getName());
                PyAnnotation annotation = namedParameter.getAnnotation();
                if (annotation != null && level.isAtLeast(LanguageLevel.PYTHON30)) {
                    parameterBuilder.append(annotation.getText());
                }
                if ((defaultValue = namedParameter.getDefaultValue()) != null) {
                    parameterBuilder.append("=");
                    parameterBuilder.append(defaultValue.getText());
                }
                pyFunctionBuilder.parameter(parameterBuilder.toString());
                continue;
            }
            if (psi == null) continue;
            pyFunctionBuilder.parameter(psi.getText());
        }
        PyClass baseClass = baseFunction.getContainingClass();
        assert (baseClass != null);
        StringBuilder statementBody = new StringBuilder();
        boolean hadStar = false;
        ArrayList<String> parameters = new ArrayList<String>();
        for (PyCallableParameter parameter : baseParams) {
            PyParameter psi = parameter.getParameter();
            PyNamedParameter namedParameter = PyUtil.as(psi, PyNamedParameter.class);
            if (namedParameter != null) {
                String repr = namedParameter.getRepr(false);
                parameters.add(hadStar && !namedParameter.isKeywordContainer() ? namedParameter.getName() + "=" + repr : repr);
                if (!namedParameter.isPositionalContainer()) continue;
                hadStar = true;
                continue;
            }
            if (psi instanceof PySingleStarParameter) {
                hadStar = true;
                continue;
            }
            if (psi == null) continue;
            parameters.add(psi.getText());
        }
        if ("types.InstanceType".equals(baseClass.getQualifiedName()) || baseFunction.onlyRaisesNotImplementedError() || implement) {
            statementBody.append("pass");
        } else {
            if (!"__init__".equals(baseFunction.getName()) && context.getReturnType(baseFunction) != PyNoneType.INSTANCE || overridingNew) {
                statementBody.append("return ");
            }
            if (baseClass.isNewStyleClass(context)) {
                statementBody.append("super");
                statementBody.append("(");
                LanguageLevel langLevel = ((PyFile)pyClass.getContainingFile()).getLanguageLevel();
                if (langLevel.isPython2()) {
                    String baseFirstName = !baseParams.isEmpty() ? ((PyCallableParameter)baseParams.get(0)).getName() : null;
                    String firstName = baseFirstName != null ? baseFirstName : "self";
                    PsiElement outerClass = PsiTreeUtil.getParentOfType((PsiElement)pyClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    String className = pyClass.getName();
                    ArrayList nameResult = Lists.newArrayList((Object[])new String[]{className});
                    while (outerClass != null) {
                        nameResult.add(0, ((PyClass)outerClass).getName());
                        outerClass = PsiTreeUtil.getParentOfType((PsiElement)outerClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    }
                    StringUtil.join((Collection)nameResult, (String)".", (StringBuilder)statementBody);
                    statementBody.append(", ").append(firstName);
                }
                statementBody.append(").").append(baseFunction.getName()).append("(");
                if (parameters.size() > 0 && !baseMethodIsStatic && !overridingNew) {
                    parameters.remove(0);
                }
            } else {
                statementBody.append(PyOverrideImplementUtil.getReferenceText(pyClass, baseClass)).append(".").append(baseFunction.getName()).append("(");
            }
            StringUtil.join(parameters, (String)", ", (StringBuilder)statementBody);
            statementBody.append(")");
        }
        pyFunctionBuilder.statement(statementBody.toString());
        return pyFunctionBuilder;
    }

    private static String getReferenceText(PyClass fromClass, PyClass toClass) {
        PyExpression[] superClassExpressions;
        for (PyExpression expression : superClassExpressions = fromClass.getSuperClassExpressions()) {
            PsiElement target2;
            if (!(expression instanceof PyReferenceExpression) || (target2 = ((PyReferenceExpression)expression).getReference().resolve()) != toClass) continue;
            return expression.getText();
        }
        return toClass.getName();
    }

    @NotNull
    public static List<PyFunction> getAllSuperAbstractMethods(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(22);
        }
        List list2 = ContainerUtil.filter(PyOverrideImplementUtil.getAllSuperMethods(cls, context), method -> {
            if (cls == null) {
                PyOverrideImplementUtil.$$$reportNull$$$0(30);
            }
            if (context == null) {
                PyOverrideImplementUtil.$$$reportNull$$$0(31);
            }
            return PyOverrideImplementUtil.isAbstractMethodForClass(method, cls, context);
        });
        if (list2 == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private static boolean isAbstractMethodForClass(@NotNull PyFunction method, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        String methodName;
        if (method == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(24);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(26);
        }
        if ((methodName = method.getName()) == null || cls.findMethodByName(methodName, false, context) != null || cls.findClassAttribute(methodName, false, context) != null) {
            return false;
        }
        PyClass methodClass = method.getContainingClass();
        if (methodClass != null) {
            for (PyClass ancestor : cls.getAncestorClasses(context)) {
                if (ancestor.equals(methodClass)) break;
                if (ancestor.findClassAttribute(methodName, false, context) == null) continue;
                return false;
            }
        }
        return method.onlyRaisesNotImplementedError() || PyKnownDecoratorUtil.hasAbstractDecorator(method, context);
    }

    @NotNull
    public static List<PyFunction> getAllSuperMethods(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(28);
        }
        LinkedHashMap functions = Maps.newLinkedHashMap();
        for (PyClassLikeType type : pyClass.getAncestorTypes(context)) {
            if (type == null) continue;
            for (PyFunction function : PyTypeUtil.getMembersOfType(type, PyFunction.class, false, context)) {
                String name = function.getName();
                if (name == null || functions.containsKey(name)) continue;
                functions.put(name, function);
            }
        }
        ArrayList arrayList = Lists.newArrayList(functions.values());
        if (arrayList == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: 
            case 9: 
            case 22: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperAbstractMethods";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideMethods";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndImplementMethods";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideOrImplementMethods";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperAbstractMethods";
                break;
            }
            case 23: 
            case 29: {
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractMethodForClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperMethods";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllSuperAbstractMethods$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

