/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.NullableConsumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.AddVEnvOptionsDialog;
import com.jetbrains.python.configuration.EditSdkDialog;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonPathDialog;
import com.jetbrains.python.configuration.PythonPathEditor;
import com.jetbrains.python.configuration.VirtualEnvProjectFilter;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.configuration.PythonSdkDetailsDialog");
    private JPanel myMainPanel;
    private JList<Object> mySdkList;
    private boolean mySdkListChanged = false;
    private final PyConfigurableInterpreterList myInterpreterList;
    private final ProjectSdksModel myProjectSdksModel;
    private Map<Sdk, SdkModificator> myModificators = FactoryMap.create(sdk -> sdk.getSdkModificator());
    private Set<SdkModificator> myModifiedModificators = new HashSet<SdkModificator>();
    private final Project myProject;
    private boolean myShowOtherProjectVirtualenvs = true;
    private final Module myModule;
    private Runnable mySdkSettingsWereModified;
    private NullableConsumer<Sdk> myShowMoreCallback;
    private SdkModel.Listener myListener;

    public PythonSdkDetailsDialog(Project project, NullableConsumer<Sdk> showMoreCallback, Runnable sdkSettingsWereModified) {
        super(project, true);
        this.myModule = null;
        this.mySdkSettingsWereModified = sdkSettingsWereModified;
        this.setTitle(PyBundle.message("sdk.details.dialog.title", new Object[0]));
        this.myShowMoreCallback = showMoreCallback;
        this.myProject = project;
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.init();
        this.updateOkButton();
    }

    protected void dispose() {
        this.myProjectSdksModel.removeListener(this.myListener);
        super.dispose();
    }

    public PythonSdkDetailsDialog(Module module2, NullableConsumer<Sdk> showMoreCallback, Runnable sdkSettingsWereModified) {
        super(module2.getProject());
        this.myModule = module2;
        this.mySdkSettingsWereModified = sdkSettingsWereModified;
        this.setTitle(PyBundle.message("sdk.details.dialog.title", new Object[0]));
        this.myShowMoreCallback = showMoreCallback;
        this.myProject = module2.getProject();
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.init();
        this.updateOkButton();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.mySdkList = new JBList();
        this.mySdkList.setCellRenderer((ListCellRenderer<Object>)((Object)new PySdkListCellRenderer(this.myModificators)));
        this.mySdkList.setSelectionMode(0);
        new ListSpeedSearch<Object>(this.mySdkList);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.mySdkList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.addSdk(button);
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.editSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.removeSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).addExtraAction((AnActionButton)new ToggleVirtualEnvFilterButton()).addExtraAction((AnActionButton)new ShowPathButton());
        decorator.setPreferredSize(new Dimension(600, 500));
        this.myMainPanel = decorator.createPanel();
        this.refreshSdkList();
        this.addListeners();
        return this.myMainPanel;
    }

    private void addListeners() {
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
            }

            public void beforeSdkRemove(Sdk sdk) {
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                PythonSdkDetailsDialog.this.refreshSdkList();
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
            }
        };
        this.myProjectSdksModel.addListener(this.myListener);
        this.mySdkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySdkList;
    }

    public boolean isModified() {
        Sdk projectSdk = this.getSdk();
        if (projectSdk != null) {
            projectSdk = this.myProjectSdksModel.findSdk(projectSdk.getName());
        }
        return this.getSelectedSdk() != projectSdk || this.mySdkListChanged || this.myProjectSdksModel.isModified() || !this.myModifiedModificators.isEmpty();
    }

    protected void updateOkButton() {
        super.setOKActionEnabled(this.isModified());
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    public void apply() {
        if (!this.myModifiedModificators.isEmpty()) {
            this.mySdkSettingsWereModified.run();
        }
        for (SdkModificator modificator : this.myModifiedModificators) {
            if (!modificator.isWritable()) continue;
            modificator.commitChanges();
        }
        this.myModificators.clear();
        this.myModifiedModificators.clear();
        this.mySdkListChanged = false;
        Sdk sdk = this.getSelectedSdk();
        this.myShowMoreCallback.consume((Object)sdk);
        if (sdk != null) {
            PyPackageManagers.getInstance().clearCache(sdk);
        }
        Disposer.dispose((Disposable)this.getDisposable());
    }

    @Nullable
    public Sdk getSelectedSdk() {
        return (Sdk)this.mySdkList.getSelectedValue();
    }

    private void refreshSdkList() {
        List<Sdk> pythonSdks = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk projectSdk = this.getSdk();
        if (!this.myShowOtherProjectVirtualenvs) {
            VirtualEnvProjectFilter.removeNotMatching(this.myProject, pythonSdks);
        }
        this.mySdkList.setModel((ListModel<Object>)new CollectionListModel(pythonSdks));
        this.mySdkListChanged = false;
        if (projectSdk != null) {
            projectSdk = this.myProjectSdksModel.findSdk(projectSdk.getName());
            this.mySdkList.clearSelection();
            this.mySdkList.setSelectedValue(projectSdk, true);
            this.mySdkList.updateUI();
        }
    }

    @Nullable
    private Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    private void addSdk(AnActionButton button) {
        PythonSdkDetailsStep.show(this.myProject, this.myProjectSdksModel.getSdks(), null, this.myMainPanel, button.getPreferredPopupPoint().getScreenPoint(), null, (NullableConsumer<Sdk>)((NullableConsumer)sdk -> this.addCreatedSdk((Sdk)sdk, true)));
    }

    private void addCreatedSdk(@Nullable Sdk sdk, boolean newVirtualEnv) {
        if (sdk != null) {
            Sdk oldSdk;
            boolean isVirtualEnv = PythonSdkType.isVirtualEnv(sdk);
            if (isVirtualEnv && !newVirtualEnv) {
                AddVEnvOptionsDialog dialog2 = new AddVEnvOptionsDialog(this.myMainPanel);
                dialog2.show();
                if (dialog2.getExitCode() != 0) {
                    return;
                }
                SdkModificator modificator = this.myModificators.get(sdk);
                this.setSdkAssociated(modificator, !dialog2.makeAvailableToAll());
                this.myModifiedModificators.add(modificator);
            }
            if ((oldSdk = this.myProjectSdksModel.findSdk(sdk)) == null) {
                this.myProjectSdksModel.addSdk(sdk);
            }
            this.refreshSdkList();
            this.mySdkList.setSelectedValue(this.myProjectSdksModel.findSdk(sdk.getName()), true);
            this.mySdkListChanged = true;
        }
    }

    private void editSdk() {
        Sdk currentSdk = this.getSelectedSdk();
        if (currentSdk != null) {
            if (currentSdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData) {
                this.editRemoteSdk(currentSdk);
            } else {
                this.editSdk(currentSdk);
            }
        }
    }

    private void editRemoteSdk(Sdk currentSdk) {
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            SdkModificator modificator = this.myModificators.get(currentSdk);
            HashSet existingSdks = Sets.newHashSet((Object[])this.myProjectSdksModel.getSdks());
            existingSdks.remove(currentSdk);
            if (remoteInterpreterManager.editSdk(this.myProject, modificator, existingSdks)) {
                this.myModifiedModificators.add(modificator);
            }
        }
    }

    private void editSdk(Sdk currentSdk) {
        SdkModificator modificator = this.myModificators.get(currentSdk);
        EditSdkDialog dialog2 = new EditSdkDialog(this.myProject, modificator, (NullableFunction<String, String>)((NullableFunction)s -> {
            if (this.isDuplicateSdkName((String)s, currentSdk)) {
                return PyBundle.message("sdk.details.dialog.error.duplicate.name", new Object[0]);
            }
            return null;
        }));
        if (dialog2.showAndGet()) {
            boolean pathChanged;
            this.mySdkList.repaint();
            boolean bl = pathChanged = !Comparing.equal((String)currentSdk.getHomePath(), (String)dialog2.getHomePath());
            if (!modificator.getName().equals(dialog2.getName()) || pathChanged || dialog2.isAssociateChanged()) {
                this.myModifiedModificators.add(modificator);
                modificator.setName(dialog2.getName());
                modificator.setHomePath(dialog2.getHomePath());
                if (dialog2.isAssociateChanged()) {
                    this.setSdkAssociated(modificator, dialog2.associateWithProject());
                }
                if (pathChanged) {
                    this.reloadSdk(currentSdk);
                }
            }
        }
    }

    private void setSdkAssociated(SdkModificator modificator, boolean isAssociated) {
        PythonSdkAdditionalData additionalData = (PythonSdkAdditionalData)modificator.getSdkAdditionalData();
        if (additionalData == null) {
            additionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(modificator.getHomePath()));
            modificator.setSdkAdditionalData((SdkAdditionalData)additionalData);
        }
        if (isAssociated && this.myProject != null) {
            additionalData.associateWithProject(this.myProject);
        } else {
            additionalData.setAssociatedProjectPath(null);
        }
    }

    private boolean isDuplicateSdkName(String s, Sdk sdk) {
        for (Sdk existingSdk : this.myProjectSdksModel.getSdks()) {
            String existingName;
            if (existingSdk == sdk || !(existingName = this.myModificators.containsKey(existingSdk) ? this.myModificators.get(existingSdk).getName() : existingSdk.getName()).equals(s)) continue;
            return true;
        }
        return false;
    }

    private void removeSdk() {
        Sdk currentSdk = this.getSelectedSdk();
        if (currentSdk != null) {
            Sdk sdk = this.myProjectSdksModel.findSdk(currentSdk);
            SdkConfigurationUtil.removeSdk(sdk);
            this.myProjectSdksModel.removeSdk(sdk);
            this.myProjectSdksModel.removeSdk(currentSdk);
            if (this.myModificators.containsKey(currentSdk)) {
                SdkModificator modificator = this.myModificators.get(currentSdk);
                this.myModifiedModificators.remove(modificator);
                this.myModificators.remove(currentSdk);
            }
            this.refreshSdkList();
            this.mySdkListChanged = true;
            if (this.mySdkList.getSelectedIndex() < 0) {
                this.mySdkList.setSelectedIndex(0);
            }
        }
    }

    private void reloadSdk() {
        Sdk currentSdk = this.getSelectedSdk();
        if (currentSdk != null) {
            this.myModifiedModificators.add(this.myModificators.get(currentSdk));
            this.reloadSdk(currentSdk);
        }
    }

    private void reloadSdk(@NotNull Sdk currentSdk) {
        if (currentSdk == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(0);
        }
        if (PythonSdkUpdater.update(currentSdk, this.myModificators.get(currentSdk), this.myProject, null)) {
            this.myModifiedModificators.remove(this.myModificators.get(currentSdk));
            this.myModificators.put(currentSdk, currentSdk.getSdkModificator());
        }
    }

    private PythonPathEditor createPathEditor(Sdk sdk) {
        if (PySdkUtil.isRemote(sdk)) {
            return new PyRemotePathEditor(sdk);
        }
        return new PythonPathEditor("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor()){

            @Override
            protected void onReloadButtonClicked() {
                PythonSdkDetailsDialog.this.reloadSdk();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSdk", "com/jetbrains/python/configuration/PythonSdkDetailsDialog", "reloadSdk"));
    }

    private class PyRemotePathEditor
    extends PythonPathEditor {
        private final PyRemoteSdkAdditionalDataBase myRemoteSdkData;
        private final Sdk mySdk;
        private List<PathMappingSettings.PathMapping> myNewMappings;

        public PyRemotePathEditor(Sdk sdk) {
            super("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor());
            this.myNewMappings = Lists.newArrayList();
            this.mySdk = sdk;
            this.myRemoteSdkData = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
        }

        @Override
        protected void onReloadButtonClicked() {
            PythonSdkDetailsDialog.this.reloadSdk();
        }

        @Override
        protected String getPresentablePath(VirtualFile value) {
            String path = value.getPath();
            return this.myRemoteSdkData.getPathMappings().convertToRemote(path);
        }

        @Override
        protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
            toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Object[] added = PyRemotePathEditor.this.doAddItems();
                    if (added.length > 0) {
                        PyRemotePathEditor.this.setModified(true);
                    }
                    PyRemotePathEditor.this.requestDefaultFocus();
                    PyRemotePathEditor.this.setSelectedRoots(added);
                }
            });
            super.addToolbarButtons(toolbarDecorator);
        }

        protected VirtualFile[] doAddItems() {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myPanel));
            try {
                String[] files = PythonRemoteInterpreterManager.getInstance().chooseRemoteFiles(project, (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData(), false);
                String sourcesLocalPath = PySdkUtil.getRemoteSourcesLocalPath(this.mySdk.getHomePath());
                VirtualFile[] vFiles = new VirtualFile[files.length];
                int i = 0;
                for (String file2 : files) {
                    String localRoot = PyRemoteSourceItem.localPathForRemoteRoot(sourcesLocalPath, file2);
                    this.myNewMappings.add(new PathMappingSettings.PathMapping(localRoot, file2));
                    this.myRemoteSdkData.getPathMappings().addMappingCheckUnique(localRoot, file2);
                    if (!new File(localRoot).exists()) {
                        new File(localRoot).mkdirs();
                    }
                    vFiles[i++] = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(localRoot));
                }
                vFiles = this.adjustAddedFileSet(this.myPanel, vFiles);
                ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(vFiles.length);
                for (VirtualFile vFile : vFiles) {
                    if (!this.addElement(vFile)) continue;
                    added.add(vFile);
                }
                return VfsUtilCore.toVirtualFileArray(added);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return VirtualFile.EMPTY_ARRAY;
            }
        }

        @Override
        public void apply(SdkModificator sdkModificator) {
            if (sdkModificator.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
                for (PathMappingSettings.PathMapping mapping : this.myNewMappings) {
                    ((PyRemoteSdkAdditionalDataBase)sdkModificator.getSdkAdditionalData()).getPathMappings().addMappingCheckUnique(mapping.getLocalRoot(), mapping.getRemoteRoot());
                }
            }
            super.apply(sdkModificator);
        }
    }

    private class ShowPathButton
    extends AnActionButton
    implements DumbAware {
        public ShowPathButton() {
            super(PyBundle.message("sdk.details.dialog.show.interpreter.paths", new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isEnabled() {
            return PythonSdkDetailsDialog.this.getSelectedSdk() != null;
        }

        public void actionPerformed(AnActionEvent e) {
            Sdk sdk = PythonSdkDetailsDialog.this.getSelectedSdk();
            PythonPathEditor pathEditor = PythonSdkDetailsDialog.this.createPathEditor(sdk);
            SdkModificator sdkModificator = (SdkModificator)PythonSdkDetailsDialog.this.myModificators.get(sdk);
            PythonPathDialog dialog2 = new PythonPathDialog(PythonSdkDetailsDialog.this.myProject, pathEditor);
            pathEditor.reset((SdkModificator)(sdk != null ? sdkModificator : null));
            if (dialog2.showAndGet() && pathEditor.isModified()) {
                pathEditor.apply(sdkModificator);
                PythonSdkDetailsDialog.this.myModifiedModificators.add(sdkModificator);
            }
            PythonSdkDetailsDialog.this.updateOkButton();
        }
    }

    private class ToggleVirtualEnvFilterButton
    extends ToggleActionButton
    implements DumbAware {
        public ToggleVirtualEnvFilterButton() {
            super(PyBundle.message("sdk.details.dialog.show.all.virtual.envs", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return PythonSdkDetailsDialog.this.myShowOtherProjectVirtualenvs;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            PythonSdkDetailsDialog.this.myShowOtherProjectVirtualenvs = state2;
            PythonSdkDetailsDialog.this.refreshSdkList();
            PythonSdkDetailsDialog.this.updateOkButton();
        }
    }
}

