/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.ide.DataManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/console/PyConsoleEnterHandler;", "", "()V", "checkComplete", "", "el", "Lcom/intellij/psi/PsiElement;", "executeEnterHandler", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "findFirstNoneSpaceElement", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "getLineAtOffset", "", "doc", "Lcom/intellij/openapi/editor/Document;", "handleEnterPressed", "isCompleteDocString", "str", "isElementInsideDocString", "atElement", "caretOffset", "isMultilineString", "python-community"})
public final class PyConsoleEnterHandler {
    /*
     * Unable to fully structure code
     */
    public final boolean handleEnterPressed(@NotNull EditorEx editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        v0 = editor.getProject();
        if (v0 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        project = v0;
        lineCount = editor.getDocument().getLineCount();
        if (lineCount > 0) {
            editor.getSelectionModel().removeSelection();
            caretPosition = editor.getCaretModel().getLogicalPosition();
            if (caretPosition.line != lineCount - 1) {
                v1 = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"project");
                this.executeEnterHandler(v1, editor);
                return false;
            }
        } else {
            return true;
        }
        lineEndOffset = editor.getDocument().getLineEndOffset(caretPosition.line);
        editor.getCaretModel().moveToOffset(lineEndOffset);
        psiMgr = PsiDocumentManager.getInstance((Project)project);
        psiMgr.commitDocument((Document)editor.getDocument());
        caretOffset = editor.getExpectedCaretOffset();
        v2 = psiMgr.getPsiFile((Document)editor.getDocument());
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"psiMgr.getPsiFile(editor.document)!!");
        atElement = this.findFirstNoneSpaceElement(v2, caretOffset);
        if (atElement == null) {
            v3 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"project");
            this.executeEnterHandler(v3, editor);
            return false;
        }
        v4 = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"editor.document");
        v5 = var9_8 = (firstLine = this.getLineAtOffset(v4, DocumentUtil.getFirstNonSpaceCharOffset(editor.getDocument(), 0)));
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (!StringsKt.startsWith$default((String)StringsKt.trim((CharSequence)v5).toString(), (String)"%%", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v6 = var9_8 = firstLine;
        if (v6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (!StringsKt.endsWith$default((String)StringsKt.trimEnd((CharSequence)v6).toString(), (String)"?", (boolean)false, (int)2, null)) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = false;
        }
        isCellMagic = v7;
        v8 = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"editor.document");
        v9 = var11_10 = (prevLine = this.getLineAtOffset(v8, caretOffset));
        if (v9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        isLineContinuation = StringsKt.endsWith$default((CharSequence)StringsKt.trim((CharSequence)v9).toString(), (char)'\\', (boolean)false, (int)2, null);
        insideDocString = this.isElementInsideDocString(atElement, caretOffset);
        isMultiLineCommand = PsiTreeUtil.getParentOfType((PsiElement)atElement, PyStatementListContainer.class) != null || isCellMagic != false;
        isAtTheEndOfCommand = editor.getDocument().getLineNumber(caretOffset) == editor.getDocument().getLineCount() - 1;
        hasCompleteStatement = insideDocString == false && isLineContinuation == false && this.checkComplete(atElement) != false;
        v10 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"project");
        this.executeEnterHandler(v10, editor);
        return isAtTheEndOfCommand != false && hasCompleteStatement != false && (isMultiLineCommand != false && StringsKt.isBlank((CharSequence)prevLine) != false || isMultiLineCommand == false);
    }

    private final void executeEnterHandler(Project project, EditorEx editor) {
        EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
        new WriteCommandAction(enterHandler, editor, project, project, new PsiFile[0]){
            final /* synthetic */ EditorActionHandler $enterHandler;
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ Project $project;

            protected void run(@NotNull Result result2) throws Throwable {
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                this.$enterHandler.execute((Editor)this.$editor, null, DataManager.getInstance().getDataContext((Component)this.$editor.getComponent()));
            }
            {
                this.$enterHandler = $captured_local_variable$0;
                this.$editor = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isElementInsideDocString(PsiElement atElement, int caretOffset) {
        if (!(atElement.getContext() instanceof PyStringLiteralExpression)) return false;
        if (!PyTokenTypes.TRIPLE_NODES.contains(atElement.getNode().getElementType())) {
            if (atElement.getNode().getElementType() != PyTokenTypes.DOCSTRING) return false;
        }
        String string = atElement.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"atElement.text");
        if (!this.isMultilineString(string)) return false;
        if (atElement.getTextRange().getEndOffset() > caretOffset) return true;
        String string2 = atElement.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"atElement.text");
        if (this.isCompleteDocString(string2)) return false;
        return true;
    }

    private final boolean checkComplete(PsiElement el) {
        PyStatementListContainer compoundStatement = (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)el, PyStatementListContainer.class);
        if (compoundStatement != null && !(compoundStatement instanceof PyTryPart)) {
            return ((Object[])compoundStatement.getStatementList().getStatements()).length != 0;
        }
        PsiElement topLevel = PyPsiUtils.getParentRightBefore(el, (PsiElement)el.getContainingFile());
        return topLevel != null && !PsiTreeUtil.hasErrorElements((PsiElement)topLevel);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findFirstNoneSpaceElement(PsiFile psiFile, int offset) {
        int n = offset;
        boolean bl = false;
        if (n >= 0) {
            while (true) {
                void i;
                PsiElement el;
                if ((el = psiFile.findElementAt((int)i)) != null && !(el instanceof PsiWhiteSpace)) {
                    return el;
                }
                if (i == false) break;
                --i;
            }
        }
        return null;
    }

    private final String getLineAtOffset(Document doc, int offset) {
        int line = doc.getLineNumber(offset);
        int start = doc.getLineStartOffset(line);
        int end = doc.getLineEndOffset(line);
        String string = doc.getText(new TextRange(start, end));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"doc.getText(TextRange(start, end))");
        return string;
    }

    private final boolean isMultilineString(String str) {
        String string = str;
        int n = PyStringLiteralExpressionImpl.getPrefixLength(str);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String text = string3;
        return StringsKt.startsWith$default((String)text, (String)"\"\"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"'''", (boolean)false, (int)2, null);
    }

    private final boolean isCompleteDocString(String str) {
        String string;
        int prefixLen = PyStringLiteralExpressionImpl.getPrefixLength(str);
        String string2 = string = str;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(prefixLen);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String text = string3;
        String[] stringArray = new String[]{"\"\"\"", "'''"};
        for (int i = 0; i < stringArray.length; ++i) {
            String token = stringArray[i];
            if (text.length() < 2 * token.length() || !StringsKt.startsWith$default((String)text, (String)token, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)text, (String)token, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }
}

