/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.settings;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.TableModelEditor;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.debugger.settings.PySteppingFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerSteppingConfigurableUi
implements ConfigurableUi<PyDebuggerSettings> {
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{new EnabledColumn(), new FilterColumn()};
    private JPanel myPanel;
    private JPanel mySteppingPanel;
    private JBCheckBox myLibrariesFilterCheckBox;
    private JBCheckBox myStepFilterEnabledCheckBox;
    private TableModelEditor<PySteppingFilter> myPySteppingFilterEditor;

    public PyDebuggerSteppingConfigurableUi() {
        this.$$$setupUI$$$();
        this.myStepFilterEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent e) {
                PyDebuggerSteppingConfigurableUi.this.myPySteppingFilterEditor.enabled(PyDebuggerSteppingConfigurableUi.this.myStepFilterEnabledCheckBox.isSelected());
            }
        });
    }

    private void createUIComponents() {
        DialogEditor itemEditor = new DialogEditor();
        this.myPySteppingFilterEditor = new TableModelEditor<PySteppingFilter>(COLUMNS, itemEditor, "No script filters configured");
        this.mySteppingPanel = new JPanel(new BorderLayout());
        this.mySteppingPanel.add(this.myPySteppingFilterEditor.createComponent());
    }

    public void reset(@NotNull PyDebuggerSettings settings) {
        if (settings == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(0);
        }
        this.myLibrariesFilterCheckBox.setSelected(settings.isLibrariesFilterEnabled());
        this.myStepFilterEnabledCheckBox.setSelected(settings.isSteppingFiltersEnabled());
        this.myPySteppingFilterEditor.reset(settings.getSteppingFilters());
        this.myPySteppingFilterEditor.enabled(this.myStepFilterEnabledCheckBox.isSelected());
    }

    public boolean isModified(@NotNull PyDebuggerSettings settings) {
        if (settings == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(1);
        }
        return this.myLibrariesFilterCheckBox.isSelected() != settings.isLibrariesFilterEnabled() || this.myStepFilterEnabledCheckBox.isSelected() != settings.isSteppingFiltersEnabled() || this.myPySteppingFilterEditor.isModified();
    }

    public void apply(@NotNull PyDebuggerSettings settings) throws ConfigurationException {
        if (settings == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(2);
        }
        settings.setLibrariesFilterEnabled(this.myLibrariesFilterCheckBox.isSelected());
        settings.setSteppingFiltersEnabled(this.myStepFilterEnabledCheckBox.isSelected());
        if (this.myPySteppingFilterEditor.isModified()) {
            settings.setSteppingFilters(this.myPySteppingFilterEditor.apply());
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PyDebuggerSteppingConfigurableUi.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myStepFilterEnabledCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setHorizontalAlignment(2);
        jBCheckBox2.setText("Do not step into scripts:");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = this.mySteppingPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myLibrariesFilterCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHorizontalAlignment(2);
        jBCheckBox.setText("Do not step into library scripts");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class DialogEditor
    implements TableModelEditor.DialogItemEditor<PySteppingFilter> {
        private DialogEditor() {
        }

        @Override
        public PySteppingFilter clone(@NotNull PySteppingFilter item, boolean forInPlaceEditing) {
            if (item == null) {
                DialogEditor.$$$reportNull$$$0(0);
            }
            return new PySteppingFilter(item.isEnabled(), item.getFilter());
        }

        @Override
        @NotNull
        public Class<PySteppingFilter> getItemClass() {
            if (PySteppingFilter.class == null) {
                DialogEditor.$$$reportNull$$$0(1);
            }
            return PySteppingFilter.class;
        }

        @Override
        public void edit(@NotNull PySteppingFilter item, @NotNull Function<PySteppingFilter, PySteppingFilter> mutator, boolean isAdd) {
            String pattern;
            if (item == null) {
                DialogEditor.$$$reportNull$$$0(2);
            }
            if (mutator == null) {
                DialogEditor.$$$reportNull$$$0(3);
            }
            if ((pattern = Messages.showInputDialog((Component)PyDebuggerSteppingConfigurableUi.this.myPanel, (String)"Specify glob pattern ('*', '?' and '[seq]' allowed, semicolon ';' as name separator):", (String)"Stepping Filter", null, (String)item.getFilter(), (InputValidator)new NonEmptyInputValidator())) != null) {
                ((PySteppingFilter)mutator.fun((Object)item)).setFilter(pattern);
                PyDebuggerSteppingConfigurableUi.this.myPySteppingFilterEditor.getModel().fireTableDataChanged();
            }
        }

        @Override
        public void applyEdited(@NotNull PySteppingFilter oldItem, @NotNull PySteppingFilter newItem) {
            if (oldItem == null) {
                DialogEditor.$$$reportNull$$$0(4);
            }
            if (newItem == null) {
                DialogEditor.$$$reportNull$$$0(5);
            }
            oldItem.setFilter(newItem.getFilter());
        }

        @Override
        public boolean isUseDialogToAdd() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi$DialogEditor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldItem";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/settings/PyDebuggerSteppingConfigurableUi$DialogEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItemClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "clone";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "edit";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyEdited";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilterColumn
    extends TableModelEditor.EditableColumnInfo<PySteppingFilter, String> {
        private FilterColumn() {
        }

        @Nullable
        public String valueOf(PySteppingFilter filter2) {
            return filter2.getFilter();
        }

        public Class<?> getColumnClass() {
            return String.class;
        }

        public void setValue(PySteppingFilter filter2, String value) {
            filter2.setFilter(value);
        }
    }

    private static class EnabledColumn
    extends TableModelEditor.EditableColumnInfo<PySteppingFilter, Boolean> {
        private EnabledColumn() {
        }

        @Nullable
        public Boolean valueOf(PySteppingFilter filter2) {
            return filter2.isEnabled();
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public void setValue(PySteppingFilter filter2, Boolean value) {
            filter2.setEnabled(value);
        }
    }
}

