/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveDictKeyQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDictDuplicateKeysInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.duplicate.keys", new Object[0]);
        if (string == null) {
            PyDictDuplicateKeysInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyDictDuplicateKeysInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyDictDuplicateKeysInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyDictDuplicateKeysInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression node) {
            PyKeyValueExpression[] elements = node.getElements();
            if (elements.length != 0) {
                HashMap map2 = new HashMap();
                for (PyKeyValueExpression exp : elements) {
                    PyExpression key = exp.getKey();
                    if (!(key instanceof PyNumericLiteralExpression) && !(key instanceof PyStringLiteralExpression) && !(key instanceof PyReferenceExpression)) continue;
                    if (map2.keySet().contains(key.getText())) {
                        this.registerProblem((PsiElement)key, "Dictionary contains duplicate keys " + key.getText(), new PyRemoveDictKeyQuickFix());
                        this.registerProblem((PsiElement)map2.get(key.getText()), "Dictionary contains duplicate keys " + key.getText(), new PyRemoveDictKeyQuickFix());
                    }
                    map2.put(key.getText(), key);
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            if (Visitor.isDict(node)) {
                PyExpression[] arguments;
                HashMap map2 = new HashMap();
                PyArgumentList pyArgumentList = node.getArgumentList();
                if (pyArgumentList == null) {
                    return;
                }
                for (PyExpression argument : arguments = pyArgumentList.getArguments()) {
                    if (argument instanceof PyParenthesizedExpression) {
                        argument = ((PyParenthesizedExpression)argument).getContainedExpression();
                    }
                    if (argument instanceof PySequenceExpression) {
                        for (PyExpression el : ((PySequenceExpression)argument).getElements()) {
                            PsiElement key = Visitor.getKey(el);
                            this.checkKey((Map<String, PsiElement>)map2, key);
                        }
                        continue;
                    }
                    PsiElement key = Visitor.getKey(argument);
                    this.checkKey((Map<String, PsiElement>)map2, key);
                }
            }
        }

        private void checkKey(Map<String, PsiElement> map2, PsiElement node) {
            if (node == null) {
                return;
            }
            String key = node.getText();
            if (node instanceof PyStringLiteralExpression) {
                key = ((PyStringLiteralExpression)node).getStringValue();
            }
            if (map2.keySet().contains(key)) {
                this.registerProblem(node, "Dictionary contains duplicate keys " + key);
                this.registerProblem(map2.get(key), "Dictionary contains duplicate keys " + key);
            }
            map2.put(key, node);
        }

        @Nullable
        private static PsiElement getKey(PyElement argument) {
            ASTNode keyWord;
            PyExpression expr;
            if (argument instanceof PyParenthesizedExpression && (expr = ((PyParenthesizedExpression)argument).getContainedExpression()) instanceof PyTupleExpression) {
                return ((PyTupleExpression)expr).getElements()[0];
            }
            if (argument instanceof PyKeywordArgument && (keyWord = ((PyKeywordArgument)argument).getKeywordNode()) != null) {
                return keyWord.getPsi();
            }
            return null;
        }

        private static boolean isDict(PyCallExpression expression) {
            PyExpression callee = expression.getCallee();
            if (callee == null) {
                return false;
            }
            String name = callee.getText();
            return "dict".equals(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection$Visitor", "<init>"));
        }
    }
}

