/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarterManagerUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemotePackageManagerImpl
extends PyPackageManagerImpl {
    private static final Logger LOG = Logger.getInstance(PyRemotePackageManagerImpl.class);

    PyRemotePackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(0);
        }
        super(sdk);
    }

    @Override
    @Nullable
    protected String getHelperPath(String helper) throws ExecutionException {
        Sdk sdk = this.getSdk();
        SdkAdditionalData sdkData = sdk.getSdkAdditionalData();
        if (sdkData instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)sdkData;
            try {
                String helpersPath;
                if (CaseCollector.useRemoteCredentials(remoteSdkData)) {
                    RemoteSdkCredentials remoteSdkCredentials = remoteSdkData.getRemoteSdkCredentials(false);
                    helpersPath = remoteSdkCredentials.getHelpersPath();
                } else {
                    helpersPath = remoteSdkData.getHelpersPath();
                }
                if (!StringUtil.isEmpty((String)helpersPath)) {
                    return new RemoteFile(helpersPath, helper).getPath();
                }
                return null;
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                throw this.analyzeException(e, helper, Collections.emptyList());
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        Sdk sdk;
        String homePath;
        if (helperPath == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(1);
        }
        if (args == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(2);
        }
        if ((homePath = (sdk = this.getSdk()).getHomePath()) == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + sdk.getName());
        }
        SdkAdditionalData sdkData = sdk.getSdkAdditionalData();
        if (sdkData instanceof PyRemoteSdkAdditionalDataBase) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (CaseCollector.useRemoteCredentials((PyRemoteSdkAdditionalDataBase)sdkData)) {
                RemoteSdkCredentials remoteSdkCredentials;
                try {
                    remoteSdkCredentials = ((RemoteSdkAdditionalData)sdkData).getRemoteSdkCredentials(false);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                    remoteSdkCredentials = null;
                }
                catch (ExecutionException e) {
                    throw this.analyzeException(e, helperPath, args);
                }
                if (manager != null && remoteSdkCredentials != null) {
                    if (askForSudo) {
                        askForSudo = !manager.ensureCanWrite(remoteSdkCredentials, remoteSdkCredentials.getInterpreterPath());
                    }
                } else {
                    throw new PyExecutionException("Remote interpreter can't be executed. Please enable the Remote Hosts Access plugin.", helperPath, args);
                }
            }
            if (manager != null) {
                ProcessOutput processOutput;
                ArrayList<String> cmdline = new ArrayList<String>();
                cmdline.add(homePath);
                cmdline.add(RemoteFile.detectSystemByPath(homePath).createRemoteFile(helperPath).getPath());
                cmdline.addAll(Collections2.transform(args, input -> PyRemotePackageManagerImpl.quoteIfNeeded(input)));
                do {
                    PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData = (PyRemoteSdkAdditionalDataBase)sdkData;
                    PyRemotePathMapper pathMapper = manager.setupMappings(null, remoteSdkAdditionalData, null);
                    try {
                        processOutput = PyRemoteProcessStarterManagerUtil.getManager(remoteSdkAdditionalData).executeRemoteProcess(null, ArrayUtil.toStringArray(cmdline), workingDir, manager, remoteSdkAdditionalData, pathMapper, askForSudo, Sets.newHashSet((Object[])new String[]{helperPath}));
                    }
                    catch (InterruptedException e) {
                        throw new ExecutionException((Throwable)e);
                    }
                } while (askForSudo && processOutput.getStderr().contains("sudo: 3 incorrect password attempts"));
                ProcessOutput processOutput2 = processOutput;
                if (processOutput2 == null) {
                    PyRemotePackageManagerImpl.$$$reportNull$$$0(3);
                }
                return processOutput2;
            }
            throw new PyExecutionException("Remote interpreter can't be executed. Please enable the Remote Hosts Access plugin.", helperPath, args);
        }
        throw new PyExecutionException("Invalid remote SDK", helperPath, args);
    }

    private ExecutionException analyzeException(ExecutionException exception, String command, List<String> args) {
        Throwable cause = exception.getCause();
        if (cause instanceof VagrantNotStartedException) {
            return new PyExecutionException("Vagrant instance is down", command, args, "", "", 0, (List<? extends PyExecutionFix>)ImmutableList.of((Object)new LaunchVagrantFix(((VagrantNotStartedException)cause).getVagrantFolder(), ((VagrantNotStartedException)cause).getMachineName())));
        }
        return exception;
    }

    @Override
    protected void subscribeToLocalChanges() {
    }

    @Override
    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(4);
        }
        super.installManagement(name);
    }

    private static String quoteIfNeeded(String arg) {
        return arg.replace("<", "\\<").replace(">", "\\>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyRemotePackageManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyRemotePackageManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LaunchVagrantFix
    implements PyExecutionFix {
        @NotNull
        private final String myVagrantFolder;
        @Nullable
        private final String myMachineName;

        public LaunchVagrantFix(@Nullable String vagrantFolder, String machineName) {
            if (vagrantFolder == null) {
                LaunchVagrantFix.$$$reportNull$$$0(0);
            }
            this.myVagrantFolder = vagrantFolder;
            this.myMachineName = machineName;
        }

        @Override
        @NotNull
        public String getName() {
            if ("Launch Vagrant" == null) {
                LaunchVagrantFix.$$$reportNull$$$0(1);
            }
            return "Launch Vagrant";
        }

        @Override
        public void run(@NotNull Sdk sdk) {
            PythonRemoteInterpreterManager manager;
            if (sdk == null) {
                LaunchVagrantFix.$$$reportNull$$$0(2);
            }
            if ((manager = PythonRemoteInterpreterManager.getInstance()) != null) {
                try {
                    manager.runVagrant(this.myVagrantFolder, this.myMachineName);
                    PythonSdkType.getInstance().setupSdkPaths(sdk);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vagrantFolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

