/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.quickfix.CompatibilityPrintCallQuickFix;
import com.jetbrains.python.inspections.quickfix.ConvertDictCompQuickFix;
import com.jetbrains.python.inspections.quickfix.ConvertSetLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveUnderscoresInNumericLiteralsQuickFix;
import com.jetbrains.python.inspections.quickfix.RemovePrefixQuickFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingLQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBackquoteExpressionQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBuiltinsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceExceptPartQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceListComprehensionsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceNotEqOperatorQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceOctalNumericLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceRaiseStatementQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReprExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompatibilityVisitor
extends PyAnnotator {
    @NotNull
    private static final Map<LanguageLevel, Set<String>> AVAILABLE_PREFIXES = Maps.newHashMap();
    @NotNull
    private static final Set<String> DEFAULT_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB"});
    @NotNull
    protected static final String COMMON_MESSAGE = "Python version ";
    @NotNull
    protected List<LanguageLevel> myVersionsToProcess;

    public CompatibilityVisitor(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.$$$reportNull$$$0(0);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    @Override
    public void visitPyAnnotation(PyAnnotation node) {
        PsiElement parent = node.getParent();
        if (!(parent instanceof PyFunction) && !(parent instanceof PyNamedParameter)) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON36), " not support variable annotations", (PsiElement)node, null);
        }
    }

    @Override
    public void visitPyDictCompExpression(PyDictCompExpression node) {
        super.visitPyDictCompExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> !level.supportsSetLiterals(), " not support dictionary comprehensions", node, (LocalQuickFix)new ConvertDictCompQuickFix(), false);
    }

    @Override
    public void visitPySetLiteralExpression(PySetLiteralExpression node) {
        super.visitPySetLiteralExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> !level.supportsSetLiterals(), " not support set literal expressions", (PsiElement)node, (LocalQuickFix)new ConvertSetLiteralQuickFix(), false);
    }

    @Override
    public void visitPySetCompExpression(PySetCompExpression node) {
        super.visitPySetCompExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> !level.supportsSetLiterals(), " not support set comprehensions", node, null, false);
    }

    @Override
    public void visitPyExceptBlock(PyExceptPart node) {
        super.visitPyExceptBlock(node);
        PyExpression exceptClass = node.getExceptClass();
        if (exceptClass != null) {
            PsiElement element = exceptClass.getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (element != null && "as".equals(element.getText())) {
                this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON26), "Python versions < 2.6 do not support this syntax.", node);
            }
            if (element != null && ",".equals(element.getText())) {
                this.registerForAllMatchingVersions(LanguageLevel::isPy3K, " not support this syntax.", node, (LocalQuickFix)new ReplaceExceptPartQuickFix());
            }
        }
    }

    @Override
    public void visitPyImportStatement(PyImportStatement node) {
        super.visitPyImportStatement(node);
        PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyIfStatement.class);
        if (ifParent != null) {
            return;
        }
        for (PyImportElement importElement : node.getImportElements()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            if (qName.matches(new String[]{"builtins"})) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2(), " not have module builtins", (PsiElement)node, (LocalQuickFix)new ReplaceBuiltinsQuickFix());
                continue;
            }
            if (!qName.matches(new String[]{"__builtin__"})) continue;
            this.registerForAllMatchingVersions(LanguageLevel::isPy3K, " not have module __builtin__", (PsiElement)node, (LocalQuickFix)new ReplaceBuiltinsQuickFix());
        }
    }

    @Override
    public void visitPyStarExpression(PyStarExpression node) {
        super.visitPyStarExpression(node);
        if (node.isAssignmentTarget()) {
            this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON30), "Python versions < 3.0 do not support starred expressions as assignment targets", (PsiElement)node);
        }
        if (node.isUnpacking()) {
            this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not support starred expressions in tuples, lists, and sets", (PsiElement)node);
        }
    }

    @Override
    public void visitPyDoubleStarExpression(PyDoubleStarExpression node) {
        super.visitPyDoubleStarExpression(node);
        this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not support starred expressions in dicts", (PsiElement)node);
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        super.visitPyBinaryExpression(node);
        if (node.isOperator("<>")) {
            this.registerForAllMatchingVersions(LanguageLevel::isPy3K, " not support <>, use != instead.", (PsiElement)node, (LocalQuickFix)new ReplaceNotEqOperatorQuickFix());
        } else if (node.isOperator("@")) {
            this.checkMatrixMultiplicationOperator(node.getPsiOperator());
        }
    }

    private void checkMatrixMultiplicationOperator(PsiElement node) {
        this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not support matrix multiplication operators", node);
    }

    @Override
    public void visitPyNumericLiteralExpression(PyNumericLiteralExpression node) {
        super.visitPyNumericLiteralExpression(node);
        String text = node.getText();
        if (node.isIntegerLiteral()) {
            char secondChar;
            if (text.endsWith("l") || text.endsWith("L")) {
                this.registerForAllMatchingVersions(LanguageLevel::isPy3K, " not support a trailing 'l' or 'L'.", (PsiElement)node, (LocalQuickFix)new RemoveTrailingLQuickFix());
            }
            if (text.length() > 1 && text.charAt(0) == '0' && (secondChar = Character.toLowerCase(text.charAt(1))) != 'o' && secondChar != 'b' && secondChar != 'x' && text.chars().anyMatch(c -> c != 48)) {
                this.registerForAllMatchingVersions(LanguageLevel::isPy3K, " not support this syntax. It requires '0o' prefix for octal literals", (PsiElement)node, (LocalQuickFix)new ReplaceOctalNumericLiteralQuickFix());
            }
        }
        if (text.contains("_")) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON36), " not support underscores in numeric literals", (PsiElement)node, (LocalQuickFix)new PyRemoveUnderscoresInNumericLiteralsQuickFix());
        }
    }

    @Override
    public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
        super.visitPyStringLiteralExpression(node);
        for (ASTNode stringNode : node.getStringNodes()) {
            int prefixLength;
            String text = stringNode.getText();
            String prefix = text.substring(0, prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(text)).toUpperCase();
            if (prefix.isEmpty()) continue;
            TextRange range = TextRange.create((int)stringNode.getStartOffset(), (int)(stringNode.getStartOffset() + prefixLength));
            this.registerForAllMatchingVersions(level -> !AVAILABLE_PREFIXES.getOrDefault(level, DEFAULT_PREFIXES).contains(prefix), " not support a '" + prefix + "' prefix", node, range, new RemovePrefixQuickFix(prefix), true);
        }
    }

    @Override
    public void visitPyListCompExpression(PyListCompExpression node) {
        super.visitPyListCompExpression(node);
        List nodes = node.getForComponents().stream().map(PyComprehensionForComponent::getIteratedList).collect(Collectors.toList());
        this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.visitPyListCompExpression(node, level), " not support this syntax in list comprehensions.", nodes, (LocalQuickFix)new ReplaceListComprehensionsQuickFix());
    }

    @Override
    public void visitPyRaiseStatement(PyRaiseStatement node) {
        super.visitPyRaiseStatement(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.raiseHasNoArgsUnderFinally(node, level), " not support this syntax. Raise with no arguments can only be used in an except block", (PsiElement)node, null, false);
        this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.raiseHasMoreThenOneArg(node, level), " not support this syntax.", (PsiElement)node, (LocalQuickFix)new ReplaceRaiseStatementQuickFix());
        this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.raiseHasFromKeyword(node, level), " not support this syntax.", (PsiElement)node, (LocalQuickFix)new ReplaceRaiseStatementQuickFix());
    }

    @Override
    public void visitPyReprExpression(PyReprExpression node) {
        super.visitPyReprExpression(node);
        this.registerForAllMatchingVersions(LanguageLevel::isPy3K, " not support backquotes, use repr() instead", (PsiElement)node, (LocalQuickFix)new ReplaceBackquoteExpressionQuickFix());
    }

    @Override
    public void visitPyWithStatement(PyWithStatement node) {
        super.visitPyWithStatement(node);
        this.registerOnFirstMatchingVersion(LanguageLevel.PYTHON24::equals, "Python version 2.4 doesn't support this syntax.", node);
        PyWithItem[] items = node.getWithItems();
        if (items.length > 1) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> !level.supportsSetLiterals() && !level.equals((Object)LanguageLevel.PYTHON24), " not support multiple context managers", Arrays.asList(items).subList(1, items.length), null);
        }
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        super.visitPyForStatement(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyClass(PyClass node) {
        super.visitPyClass(node);
        PyArgumentList list2 = node.getSuperClassExpressionList();
        if (list2 != null && list2.getArguments().length == 0) {
            this.registerOnFirstMatchingVersion(LanguageLevel.PYTHON24::equals, "Python version 2.4 does not support this syntax.", (PsiElement)list2);
        }
    }

    @Override
    public void visitPyPrintStatement(PyPrintStatement node) {
        super.visitPyPrintStatement(node);
        PsiElement[] arguments = node.getChildren();
        Predicate<PsiElement> nonParenthesesPredicate = element -> !(element instanceof PyParenthesizedExpression) && !(element instanceof PyTupleExpression);
        if (arguments.length == 0 || Arrays.stream(arguments).anyMatch(nonParenthesesPredicate)) {
            this.registerOnFirstMatchingVersion(LanguageLevel::isPy3K, "Python version >= 3.0 do not support this syntax. The print statement has been replaced with a print() function", (PsiElement)node, new CompatibilityPrintCallQuickFix());
        }
    }

    @Override
    public void visitPyFromImportStatement(PyFromImportStatement node) {
        super.visitPyFromImportStatement(node);
        PyReferenceExpression importSource = node.getImportSource();
        if (importSource != null) {
            PsiElement prev = importSource.getPrevSibling();
            if (prev != null && prev.getNode().getElementType() == PyTokenTypes.DOT) {
                this.registerOnFirstMatchingVersion(LanguageLevel.PYTHON24::equals, "Python version 2.4 doesn't support this syntax.", (PsiElement)node);
            }
        } else {
            this.registerOnFirstMatchingVersion(LanguageLevel.PYTHON24::equals, "Python version 2.4 doesn't support this syntax.", (PsiElement)node);
        }
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        super.visitPyAssignmentStatement(node);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24)) {
            PyExpression assignedValue = node.getAssignedValue();
            Stack<PyExpression> st = new Stack<PyExpression>();
            if (assignedValue != null) {
                st.push(assignedValue);
            }
            while (!st.isEmpty()) {
                PsiElement el = (PsiElement)st.pop();
                if (el instanceof PyYieldExpression) {
                    this.registerProblem(node, "Python version 2.4 doesn't support this syntax. In Python <= 2.4, yield was a statement; it didn't return any value.");
                    continue;
                }
                for (PsiElement e : el.getChildren()) {
                    st.push((PyExpression)e);
                }
            }
        }
    }

    @Override
    public void visitPyConditionalExpression(PyConditionalExpression node) {
        super.visitPyConditionalExpression(node);
        this.registerOnFirstMatchingVersion(LanguageLevel.PYTHON24::equals, "Python version 2.4 doesn't support this syntax.", (PsiElement)node);
    }

    @Override
    public void visitPyTryExceptStatement(PyTryExceptStatement node) {
        super.visitPyTryExceptStatement(node);
        PyExceptPart[] excepts = node.getExceptParts();
        PyFinallyPart finallyPart = node.getFinallyPart();
        if (excepts.length != 0 && finallyPart != null) {
            this.registerOnFirstMatchingVersion(LanguageLevel.PYTHON24::equals, "Python version 2.4 doesn't support this syntax. You could use a finally block to ensure that code is always executed, or one or more except blocks to catch specific exceptions.", (PsiElement)node);
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        super.visitPyCallExpression(node);
        PsiElement firstChild = node.getFirstChild();
        if (firstChild != null && "super".equals(firstChild.getText()) && ArrayUtil.isEmpty((Object[])node.getArguments())) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2(), " not support this syntax. super() should have arguments in Python 2", (PsiElement)node, null);
        }
        this.highlightIncorrectArguments(node);
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        super.visitPyFunction(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyPrefixExpression(PyPrefixExpression node) {
        super.visitPyPrefixExpression(node);
        if (node.getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
            this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not support this syntax", (PsiElement)node);
        }
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        super.visitPyYieldExpression(node);
        Optional.ofNullable(ScopeUtil.getScopeOwner((PsiElement)node)).map(owner -> PyUtil.as(owner, PyFunction.class)).filter(function -> function.isAsync() && function.isAsyncAllowed()).ifPresent(function -> {
            if (!node.isDelegating() && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
                this.registerProblem((PsiElement)node, "Python version 3.5 does not support 'yield' inside async functions");
            }
        });
        if (!node.isDelegating()) {
            return;
        }
        this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON33), "Python versions < 3.3 do not support this syntax. Delegating to a subgenerator is available since Python 3.3; use explicit iteration over subgenerator instead.", (PsiElement)node);
    }

    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        PyFunction function;
        if (this.myVersionsToProcess.stream().anyMatch(level -> level.isOlderThan(LanguageLevel.PYTHON33)) && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class})) != null && node.getExpression() != null) {
            YieldVisitor visitor2 = new YieldVisitor();
            function.acceptChildren(visitor2);
            if (visitor2.haveYield()) {
                this.registerProblem((PsiElement)node, "Python versions < 3.3 do not allow 'return' with argument inside generator.");
            }
        }
    }

    @Override
    public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
        if (node.isEllipsis()) {
            PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PySubscriptionExpression.class);
            if (subscription != null && PsiTreeUtil.isAncestor((PsiElement)subscription.getIndexExpression(), (PsiElement)node, (boolean)false)) {
                return;
            }
            PySliceItem sliceItem = (PySliceItem)PsiTreeUtil.getParentOfType((PsiElement)node, PySliceItem.class);
            if (sliceItem != null) {
                return;
            }
            this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON30), "Python versions < 3.0 do not support '...' outside of sequence slicings.", (PsiElement)node);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
        IElementType operationType;
        super.visitPyAugAssignmentStatement(node);
        PsiElement operation = node.getOperation();
        if (operation != null && ((Object)((Object)PyTokenTypes.ATEQ)).equals(operationType = operation.getNode().getElementType())) {
            this.checkMatrixMultiplicationOperator(operation);
        }
    }

    private void checkAsyncKeyword(@NotNull PsiElement node) {
        ASTNode asyncNode;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(1);
        }
        if ((asyncNode = node.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)) != null) {
            this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not support this syntax", node, asyncNode.getTextRange(), null);
        }
    }

    protected abstract void registerProblem(@NotNull PsiElement var1, @NotNull TextRange var2, @NotNull String var3, @Nullable LocalQuickFix var4, boolean var5);

    protected void registerProblem(@NotNull PsiElement node, @NotNull String message, @Nullable LocalQuickFix localQuickFix) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(2);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(3);
        }
        this.registerProblem(node, node.getTextRange(), message, localQuickFix, true);
    }

    protected void registerProblem(@NotNull PsiElement node, @NotNull String message) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(4);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(5);
        }
        this.registerProblem(node, message, null);
    }

    protected void setVersionsToProcess(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.$$$reportNull$$$0(6);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull Iterable<Pair<? extends PsiElement, TextRange>> nodesWithRanges, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        List levels;
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(7);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(8);
        }
        if (nodesWithRanges == null) {
            CompatibilityVisitor.$$$reportNull$$$0(9);
        }
        if (!(levels = this.myVersionsToProcess.stream().filter(levelPredicate).map(LanguageLevel::toString).collect(Collectors.toList())).isEmpty()) {
            String result2 = COMMON_MESSAGE + StringUtil.join(levels, (String)", ") + (levels.size() == 1 ? " does" : " do") + suffix;
            for (Pair<? extends PsiElement, TextRange> nodeWithRange : nodesWithRanges) {
                this.registerProblem((PsiElement)nodeWithRange.first, (TextRange)nodeWithRange.second, result2, localQuickFix, asError);
            }
        }
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull Iterable<? extends PsiElement> nodes, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(10);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(11);
        }
        if (nodes == null) {
            CompatibilityVisitor.$$$reportNull$$$0(12);
        }
        List nodesWithRanges = ContainerUtil.map(nodes, node -> Pair.createNonNull((Object)node, (Object)node.getTextRange()));
        this.registerForAllMatchingVersions(levelPredicate, suffix, nodesWithRanges, localQuickFix, true);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node, @NotNull TextRange range, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(13);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(14);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(15);
        }
        if (range == null) {
            CompatibilityVisitor.$$$reportNull$$$0(16);
        }
        List<Pair.NonNull> nodesWithRanges = Collections.singletonList(Pair.createNonNull((Object)node, (Object)range));
        this.registerForAllMatchingVersions(levelPredicate, suffix, nodesWithRanges, localQuickFix, asError);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(18);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(19);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, node.getTextRange(), localQuickFix, asError);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(20);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(21);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(22);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, node.getTextRange(), localQuickFix, true);
    }

    protected void registerOnFirstMatchingVersion(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String message, @NotNull PsiElement node, @NotNull TextRange range, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(23);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(24);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(25);
        }
        if (range == null) {
            CompatibilityVisitor.$$$reportNull$$$0(26);
        }
        if (this.myVersionsToProcess.stream().anyMatch(levelPredicate)) {
            this.registerProblem(node, range, message, localQuickFix, true);
        }
    }

    protected void registerOnFirstMatchingVersion(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String message, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(27);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(28);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(29);
        }
        this.registerOnFirstMatchingVersion(levelPredicate, message, node, node.getTextRange(), localQuickFix);
    }

    protected void registerOnFirstMatchingVersion(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String message, @NotNull PsiElement node) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(30);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(31);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(32);
        }
        this.registerOnFirstMatchingVersion(levelPredicate, message, node, node.getTextRange(), null);
    }

    @Override
    public void visitPyNonlocalStatement(PyNonlocalStatement node) {
        this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON30), "nonlocal keyword available only since py3", (PsiElement)node);
    }

    private void highlightIncorrectArguments(@NotNull PyCallExpression callExpression) {
        if (callExpression == null) {
            CompatibilityVisitor.$$$reportNull$$$0(33);
        }
        HashSet<String> keywordArgumentNames = new HashSet<String>();
        boolean seenKeywordArgument = false;
        boolean seenKeywordContainer = false;
        boolean seenPositionalContainer = false;
        for (PyExpression argument : callExpression.getArguments()) {
            if (argument instanceof PyKeywordArgument) {
                String keyword = ((PyKeywordArgument)argument).getKeyword();
                if (keywordArgumentNames.contains(keyword)) {
                    this.registerProblem((PsiElement)argument, "Keyword argument repeated", new PyRemoveArgumentQuickFix());
                } else if (seenPositionalContainer) {
                    this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON26), "Python versions < 2.6 do not allow keyword arguments after *expression", (PsiElement)argument, new PyRemoveArgumentQuickFix());
                } else if (seenKeywordContainer) {
                    this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not allow keyword arguments after **expression", (PsiElement)argument, new PyRemoveArgumentQuickFix());
                }
                seenKeywordArgument = true;
                keywordArgumentNames.add(keyword);
                continue;
            }
            if (argument instanceof PyStarArgument) {
                PyStarArgument starArgument = (PyStarArgument)argument;
                if (starArgument.isKeyword()) {
                    if (seenKeywordContainer) {
                        this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not allow duplicate **expressions", (PsiElement)argument, new PyRemoveArgumentQuickFix());
                    }
                    seenKeywordContainer = true;
                    continue;
                }
                if (seenPositionalContainer) {
                    this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not allow duplicate *expressions", (PsiElement)argument, new PyRemoveArgumentQuickFix());
                }
                seenPositionalContainer = true;
                continue;
            }
            if (seenKeywordArgument) {
                this.registerProblem((PsiElement)argument, "Positional argument after keyword argument", new PyRemoveArgumentQuickFix());
                continue;
            }
            if (seenPositionalContainer) {
                this.registerOnFirstMatchingVersion(level -> level.isOlderThan(LanguageLevel.PYTHON35), "Python versions < 3.5 do not allow positional arguments after *expression", (PsiElement)argument, new PyRemoveArgumentQuickFix());
                continue;
            }
            if (!seenKeywordContainer) continue;
            this.registerProblem((PsiElement)argument, "Positional argument after **expression", new PyRemoveArgumentQuickFix());
        }
    }

    @Override
    public void visitPyComprehensionElement(PyComprehensionElement node) {
        super.visitPyComprehensionElement(node);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
            Arrays.stream(node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.ASYNC_KEYWORD}))).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(element -> this.registerProblem((PsiElement)element, "Python version 3.5 does not support 'async' inside comprehensions and generator expressions"));
            Stream resultPrefixExpressions = PsiTreeUtil.collectElementsOfType((PsiElement)node.getResultExpression(), (Class[])new Class[]{PyPrefixExpression.class}).stream();
            Stream ifComponentsPrefixExpressions = node.getIfComponents().stream().map(ifComponent -> PsiTreeUtil.collectElementsOfType((PsiElement)ifComponent.getTest(), (Class[])new Class[]{PyPrefixExpression.class})).flatMap(Collection::stream);
            Stream.concat(resultPrefixExpressions, ifComponentsPrefixExpressions).filter(expression -> expression.getOperator() == PyTokenTypes.AWAIT_KEYWORD && expression.getOperand() != null).map(expression -> expression.getNode().findChildByType((IElementType)PyTokenTypes.AWAIT_KEYWORD)).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(element -> this.registerProblem((PsiElement)element, "Python version 3.5 does not support 'await' inside comprehensions"));
        }
    }

    static {
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON24, Sets.newHashSet((Object[])new String[]{"R", "U", "UR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON25, Sets.newHashSet((Object[])new String[]{"R", "U", "UR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON26, Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON27, Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON30, Sets.newHashSet((Object[])new String[]{"R", "B"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON31, Sets.newHashSet((Object[])new String[]{"R", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON32, Sets.newHashSet((Object[])new String[]{"R", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON36, Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB", "F", "FR", "RF"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsToProcess";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 5: 
            case 24: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "levelPredicate";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesWithRanges";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAsyncKeyword";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setVersionsToProcess";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "registerForAllMatchingVersions";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOnFirstMatchingVersion";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightIncorrectArguments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class YieldVisitor
    extends PyElementVisitor {
        private boolean _haveYield = false;

        private YieldVisitor() {
        }

        public boolean haveYield() {
            return this._haveYield;
        }

        @Override
        public void visitPyYieldExpression(PyYieldExpression node) {
            this._haveYield = true;
        }

        @Override
        public void visitPyElement(PyElement node) {
            if (!this._haveYield) {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyFunction(PyFunction node) {
        }
    }
}

