/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUtil {
    public static final String DOT_GIT = ".git";
    public static final String COMMENT_CHAR = "\u0001";
    public static final String ORIGIN_HEAD = "origin/HEAD";
    public static final com.intellij.util.Function<GitRepository, VirtualFile> REPOSITORY_TO_ROOT = repository -> repository.getRoot();
    public static final String HEAD = "HEAD";
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    private static final String REPO_PATH_LINK_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    private static final String HEAD_FILE = "HEAD";

    private GitUtil() {
    }

    @Nullable
    public static File findGitDir(@NotNull File rootDir) {
        File dotGit;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(0);
        }
        if (!(dotGit = new File(rootDir, DOT_GIT)).exists()) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = new File(dotGit, "HEAD").exists();
            return headExists ? dotGit : null;
        }
        String content = DvcsUtil.tryLoadFileOrReturn((File)dotGit, null, (String)"UTF-8");
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        return GitUtil.findRealRepositoryDir(rootDir.getPath(), pathToDir);
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        VirtualFile dotGit;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(1);
        }
        if ((dotGit = rootDir.findChild(DOT_GIT)) == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = dotGit.findChild("HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        File file = GitUtil.findRealRepositoryDir(rootDir.getPath(), pathToDir);
        if (file == null) {
            return null;
        }
        return VcsUtil.getVirtualFileWithRefresh((File)file);
    }

    @Nullable
    private static File findRealRepositoryDir(@NotNull String rootPath, @NotNull String path) {
        File file;
        if (rootPath == null) {
            GitUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            GitUtil.$$$reportNull$$$0(3);
        }
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath, path}), (boolean)true);
            if (canonicalPath == null) {
                return null;
            }
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        return (file = new File(path)).isDirectory() ? file : null;
    }

    @NotNull
    private static String parsePathToRepository(@NotNull String content) {
        if (content == null) {
            GitUtil.$$$reportNull$$$0(4);
        }
        String string = (content = content.trim()).startsWith(REPO_PATH_LINK_PREFIX) ? content.substring(REPO_PATH_LINK_PREFIX.length()).trim() : content;
        if (string == null) {
            GitUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        if (dotGit == null) {
            GitUtil.$$$reportNull$$$0(6);
        }
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + dotGit, (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    public static String readFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            GitUtil.$$$reportNull$$$0(7);
        }
        int ATTEMPTS = 3;
        for (int attempt = 0; attempt < 3; ++attempt) {
            String string;
            block4: {
                try {
                    string = new String(file.contentsToByteArray());
                    if (string != null) break block4;
                }
                catch (IOException e) {
                    LOG.info(String.format("IOException while reading %s (attempt #%s)", file, attempt));
                    if (attempt < 2) continue;
                    throw e;
                }
                GitUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        throw new AssertionError((Object)("Shouldn't get here. Couldn't read " + file));
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Collection<VirtualFile> virtualFiles) throws VcsException {
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(9);
        }
        Map<VirtualFile, List<VirtualFile>> map = GitUtil.sortFilesByGitRoot(virtualFiles, false);
        if (map == null) {
            GitUtil.$$$reportNull$$$0(10);
        }
        return map;
    }

    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(Collection<VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<VirtualFile>> result2 = new HashMap<VirtualFile, List<VirtualFile>>();
        for (VirtualFile file : virtualFiles) {
            VirtualFile vcsRoot = GitUtil.gitRootOrNull(file.isDirectory() ? file.getParent() : file);
            if (vcsRoot == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + file.getPath() + " is not under Git");
            }
            ArrayList<VirtualFile> files = (ArrayList<VirtualFile>)result2.get(vcsRoot);
            if (files == null) {
                files = new ArrayList<VirtualFile>();
                result2.put(vcsRoot, files);
            }
            files.add(file);
        }
        return result2;
    }

    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(Collection<FilePath> files) throws VcsException {
        return GitUtil.sortFilePathsByGitRoot(files, false);
    }

    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Collection<FilePath> files, boolean ignoreNonGit) throws VcsException {
        if (files == null) {
            GitUtil.$$$reportNull$$$0(11);
        }
        HashMap<VirtualFile, List<FilePath>> rc = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath p : files) {
            VirtualFile root = GitUtil.getGitRootOrNull(p);
            if (root == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + p.getPath() + " is not under Git");
            }
            ArrayList<FilePath> l = (ArrayList<FilePath>)rc.get(root);
            if (l == null) {
                l = new ArrayList<FilePath>();
                rc.put(root, l);
            }
            l.add(p);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = rc;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    public static Date parseTimestamp(String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + handler + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    public static Set<VirtualFile> gitRootsForPaths(Collection<VirtualFile> roots) {
        HashSet<VirtualFile> rc = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            VirtualFile gitRoot = GitUtil.getGitRootOrNull(VcsUtil.getFilePath((VirtualFile)root));
            if (gitRoot == null) continue;
            rc.add(gitRoot);
        }
        return rc;
    }

    public static VirtualFile getGitRoot(@NotNull FilePath filePath) throws VcsException {
        VirtualFile root;
        if (filePath == null) {
            GitUtil.$$$reportNull$$$0(13);
        }
        if ((root = GitUtil.getGitRootOrNull(filePath)) != null) {
            return root;
        }
        throw new VcsException("The file " + filePath + " is not under git.");
    }

    @Deprecated
    @Nullable
    public static VirtualFile getGitRootOrNull(@NotNull FilePath filePath) {
        if (filePath == null) {
            GitUtil.$$$reportNull$$$0(14);
        }
        for (File root = filePath.getIOFile(); root != null; root = root.getParentFile()) {
            if (!GitUtil.isGitRoot(root)) continue;
            return LocalFileSystem.getInstance().findFileByIoFile(root);
        }
        return null;
    }

    public static boolean isGitRoot(@NotNull File folder) {
        if (folder == null) {
            GitUtil.$$$reportNull$$$0(15);
        }
        return GitUtil.findGitDir(folder) != null;
    }

    public static VirtualFile getGitRoot(@NotNull VirtualFile file) throws VcsException {
        VirtualFile root;
        if (file == null) {
            GitUtil.$$$reportNull$$$0(16);
        }
        if ((root = GitUtil.gitRootOrNull(file)) != null) {
            return root;
        }
        throw new VcsException("The file " + file.getPath() + " is not under git.");
    }

    @Nullable
    public static VirtualFile gitRootOrNull(VirtualFile file) {
        return GitUtil.getGitRootOrNull(VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) throws VcsException {
        VirtualFile[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (contentRoots == null || contentRoots.length == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.unconfigured.message"));
        }
        List sortedRoots = DvcsUtil.sortVirtualFilesByPresentation(GitUtil.gitRootsForPaths(Arrays.asList(contentRoots)));
        if (sortedRoots.size() == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.misconfigured"));
        }
        List list = sortedRoots;
        if (list == null) {
            GitUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static boolean isUnderGit(VirtualFile vFile) {
        return GitUtil.gitRootOrNull(vFile) != null;
    }

    public static String adjustAuthorName(String authorName, String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = authorName + ", via " + committerName;
        }
        return committerName;
    }

    public static boolean isUnderGit(FilePath path) {
        return GitUtil.getGitRootOrNull(path) != null;
    }

    public static Set<VirtualFile> gitRoots(Collection<FilePath> filePaths) {
        return filePaths.stream().map(GitUtil::getGitRootOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<GitSimpleHandler> parametersSpecifier, Consumer<GitCommittedChangeList> consumer, boolean skipDiffsForMerge) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = h.run();
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (sb.length() > 0) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is avaialble: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<GitSimpleHandler> parametersSpecifier) throws VcsException {
        ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, (Consumer<GitCommittedChangeList>)((Consumer)committedChangeList -> rc.add((GitCommittedChangeList)((Object)committedChangeList))), false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull String path) throws VcsException {
        if (path == null) {
            GitUtil.$$$reportNull$$$0(18);
        }
        String QUOTE = "\"";
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        int l = path.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new VcsException("Unterminated escape sequence in the path: " + path);
                }
                char e = path.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal((char)e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (VcsFileUtil.isOctal((char)path.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal((char)path.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path.charAt(j) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (VcsFileUtil.isOctal((char)path.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && VcsFileUtil.isOctal((char)path.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path.charAt(i) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(i + 1))) break;
                                ++i;
                            }
                            --i;
                            assert (n == b.length);
                            String encoding = GitConfigUtil.getFileNameEncoding();
                            try {
                                rc.append(new String(b, encoding));
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new IllegalStateException("The file name encoding is unsuported: " + encoding);
                            }
                        }
                        throw new VcsException("Unknown escape sequence '\\" + path.charAt(i) + "' in the path: " + path);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        String string = rc.toString();
        if (string == null) {
            GitUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        return !manager.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository, @NotNull String name) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            GitUtil.$$$reportNull$$$0(21);
        }
        return GitUtil.findRemoteByName(repository.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, @NotNull String name) {
        if (name == null) {
            GitUtil.$$$reportNull$$$0(22);
        }
        return (GitRemote)ContainerUtil.find(remotes, remote -> {
            if (name == null) {
                GitUtil.$$$reportNull$$$0(100);
            }
            return remote.getName().equals(name);
        });
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String nameAtRemote) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(23);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(24);
        }
        if (nameAtRemote == null) {
            GitUtil.$$$reportNull$$$0(25);
        }
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), remoteBranch -> {
            if (remote == null) {
                GitUtil.$$$reportNull$$$0(98);
            }
            if (nameAtRemote == null) {
                GitUtil.$$$reportNull$$$0(99);
            }
            return remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote));
        });
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(26);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(27);
        }
        if (branchName == null) {
            GitUtil.$$$reportNull$$$0(28);
        }
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
        if (gitRemoteBranch == null) {
            GitUtil.$$$reportNull$$$0(29);
        }
        return gitRemoteBranch;
    }

    @Nullable
    public static GitRemote findOrigin(Collection<GitRemote> remotes) {
        for (GitRemote remote : remotes) {
            if (!remote.getName().equals("origin")) continue;
            return remote;
        }
        return null;
    }

    @NotNull
    public static Collection<VirtualFile> getRootsFromRepositories(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(30);
        }
        List list = ContainerUtil.map(repositories, REPOSITORY_TO_ROOT);
        if (list == null) {
            GitUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<VirtualFile> roots) {
        if (repositoryManager == null) {
            GitUtil.$$$reportNull$$$0(32);
        }
        if (roots == null) {
            GitUtil.$$$reportNull$$$0(33);
        }
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile root : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(root);
            if (repo == null) {
                LOG.error("Repository not found for root " + root);
                continue;
            }
            repositories.add(repo);
        }
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository, @NotNull String beforeRef, @NotNull String afterRef) throws VcsException {
        String range;
        List<String> parameters;
        GitCommandResult result2;
        if (git == null) {
            GitUtil.$$$reportNull$$$0(35);
        }
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(36);
        }
        if (beforeRef == null) {
            GitUtil.$$$reportNull$$$0(37);
        }
        if (afterRef == null) {
            GitUtil.$$$reportNull$$$0(38);
        }
        if (!(result2 = git.diff(repository, parameters = Arrays.asList("--name-only", "--pretty=format:"), range = beforeRef + ".." + afterRef)).success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository.toLogString()));
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result2.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        HashSet<String> hashSet = remoteChanges;
        if (hashSet == null) {
            GitUtil.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(41);
        }
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        if (gitRepositoryManager == null) {
            GitUtil.$$$reportNull$$$0(42);
        }
        return gitRepositoryManager;
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepositoryManager manager;
        GitRepository repository;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(43);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(44);
        }
        if ((repository = (GitRepository)(manager = GitUtil.getRepositoryManager(project)).getRepositoryForRoot(root)) == null) {
            LOG.error("Repository is null for root " + root);
        }
        return repository;
    }

    @NotNull
    public static String getPrintableRemotes(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(45);
        }
        String string = StringUtil.join(remotes, remote -> remote.getName() + ": [" + StringUtil.join(remote.getUrls(), (String)", ") + "]", (String)"\n");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    public static void showSubmittedFiles(final Project project, final String revision, final VirtualFile file, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getGitRoot(file);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    if (changeList != null) {
                        UIUtil.invokeLaterIfNeeded(() -> 1.lambda$run$0(project, (CommittedChangeList)changeList, revision));
                    }
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationError(project, e, "git show"));
                }
            }

            private static /* synthetic */ void lambda$run$0(Project project2, CommittedChangeList changeList, String revision2) {
                AbstractVcsHelper.getInstance((Project)project2).showChangesListBrowser(changeList, GitBundle.message("paths.affected.title", revision2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/GitUtil$1", "run"));
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(47);
        }
        if ((currentBranch = repository.getCurrentBranch()) == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesForFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(48);
        }
        if (files == null) {
            GitUtil.$$$reportNull$$$0(49);
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        Function ROOT_TO_REPO = root -> root != null ? (GitRepository)manager.getRepositoryForRoot((VirtualFile)root) : null;
        Collection collection = Collections2.filter((Collection)Collections2.transform(GitUtil.sortFilesByGitRootsIgnoringOthers(files).keySet(), (Function)ROOT_TO_REPO), (Predicate)Predicates.notNull());
        if (collection == null) {
            GitUtil.$$$reportNull$$$0(50);
        }
        return collection;
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootsIgnoringOthers(@NotNull Collection<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> map;
        if (files == null) {
            GitUtil.$$$reportNull$$$0(51);
        }
        try {
            map = GitUtil.sortFilesByGitRoot(files, true);
        }
        catch (VcsException e) {
            LOG.error("Should never happen, since we passed 'ignore non-git' parameter", (Throwable)e);
            Map<VirtualFile, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(53);
            }
            return map2;
        }
        if (map == null) {
            GitUtil.$$$reportNull$$$0(52);
        }
        return map;
    }

    public static boolean hasLocalChanges(boolean staged, Project project, VirtualFile root) throws VcsException {
        GitSimpleHandler diff = new GitSimpleHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        if (staged) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output = diff.run();
        return !output.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull String absolutePath) {
        VirtualFile file;
        if (absolutePath == null) {
            GitUtil.$$$reportNull$$$0(54);
        }
        if ((file = LocalFileSystem.getInstance().findFileByPath(absolutePath)) == null) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file == null) {
            LOG.warn("VirtualFile not found for " + absolutePath);
        }
        return file;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(55);
        }
        if (relativePath == null) {
            GitUtil.$$$reportNull$$$0(56);
        }
        String string = StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static Collection<String> toAbsolute(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(58);
        }
        if (relativePaths == null) {
            GitUtil.$$$reportNull$$$0(59);
        }
        List list = ContainerUtil.map(relativePaths, s -> {
            if (root == null) {
                GitUtil.$$$reportNull$$$0(97);
            }
            return GitUtil.toAbsolute(root, s);
        });
        if (list == null) {
            GitUtil.$$$reportNull$$$0(60);
        }
        return list;
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> affectedPaths, boolean relativePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(61);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(62);
        }
        if (affectedPaths == null) {
            GitUtil.$$$reportNull$$$0(63);
        }
        ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file == null) continue;
            Change change = changeListManager.getChange(file);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
                LOG.debug(message);
                continue;
            }
            LOG.info(message);
        }
        ArrayList<Change> arrayList = affectedChanges;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<String> absolutePaths, @NotNull String title, @Nullable String description) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(65);
        }
        if (absolutePaths == null) {
            GitUtil.$$$reportNull$$$0(66);
        }
        if (title == null) {
            GitUtil.$$$reportNull$$$0(67);
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)new GitSimplePathsBrowser(project, absolutePaths));
        if (description != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NotNull
    public static String cleanupErrorPrefixes(@NotNull String msg) {
        if (msg == null) {
            GitUtil.$$$reportNull$$$0(68);
        }
        String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        String string = msg;
        if (string == null) {
            GitUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(70);
        }
        for (GitRemote remote : remotes) {
            if (!remote.getName().equals("origin")) continue;
            return remote;
        }
        return null;
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(71);
        }
        String string = StringUtil.join(repositories, repository -> repository.getPresentableUrl(), (String)"<br/>");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(73);
        }
        String string = GitUtil.getRepositoryManager(repository.getProject()).moreThanOneRoot() ? " in " + DvcsUtil.getShortRepositoryName((Repository)repository) : "";
        if (string == null) {
            GitUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(75);
        }
        String string = GitUtil.mention(repositories, -1);
        if (string == null) {
            GitUtil.$$$reportNull$$$0(76);
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull Collection<GitRepository> repositories, int limit) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(77);
        }
        if (repositories.isEmpty()) {
            if ("" == null) {
                GitUtil.$$$reportNull$$$0(78);
            }
            return "";
        }
        String string = " in " + DvcsUtil.joinShortNames(repositories, (int)limit);
        if (string == null) {
            GitUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    public static void updateRepositories(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(80);
        }
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(81);
        }
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(82);
        }
        List<GitRepository> list = GitUtil.getRepositoryManager(project).getRepositories();
        if (list == null) {
            GitUtil.$$$reportNull$$$0(83);
        }
        return list;
    }

    public static boolean isCaseOnlyChange(@NotNull String oldPath, @NotNull String newPath) {
        if (oldPath == null) {
            GitUtil.$$$reportNull$$$0(84);
        }
        if (newPath == null) {
            GitUtil.$$$reportNull$$$0(85);
        }
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.info("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getLogString(@NotNull String root, @NotNull Collection<Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(86);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(87);
        }
        String string = StringUtil.join(changes, change -> {
            if (root == null) {
                GitUtil.$$$reportNull$$$0(96);
            }
            ContentRevision after = change.getAfterRevision();
            ContentRevision before = change.getBeforeRevision();
            switch (change.getType()) {
                case NEW: {
                    return "A: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)after));
                }
                case DELETED: {
                    return "D: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)before));
                }
                case MOVED: {
                    return "M: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)before)) + " -> " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)after));
                }
            }
            return "M: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)after));
        }, (String)", ");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(88);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull ContentRevision after) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(89);
        }
        if (after == null) {
            GitUtil.$$$reportNull$$$0(90);
        }
        return FileUtil.getRelativePath((String)root, (String)after.getFile().getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<? extends Change> originalChanges) {
        if (changeListManager == null) {
            GitUtil.$$$reportNull$$$0(91);
        }
        if (originalChanges == null) {
            GitUtil.$$$reportNull$$$0(92);
        }
        OpenTHashSet allChanges = new OpenTHashSet(changeListManager.getAllChanges());
        List list = ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((OpenTHashSet)allChanges).get(arg_0));
        if (list == null) {
            GitUtil.$$$reportNull$$$0(93);
        }
        return list;
    }

    public static void refreshVfs(@NotNull VirtualFile root, @Nullable Collection<Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(94);
        }
        if (changes == null || Registry.is((String)"git.refresh.vfs.total")) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        } else {
            RefreshVFsSynchronously.updateChanges(changes);
        }
    }

    public static void updateAndRefreshVfs(@NotNull GitRepository repository, @Nullable Collection<Change> changes) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(95);
        }
        repository.update();
        GitUtil.refreshVfs(repository.getRoot(), changes);
    }

    public static void updateAndRefreshVfs(GitRepository ... repositories) {
        Arrays.stream(repositories).forEach(Repository::update);
        for (GitRepository repository : repositories) {
            GitUtil.refreshVfs(repository.getRoot(), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 29: 
            case 31: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: 
            case 88: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 29: 
            case 31: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: 
            case 88: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 29: 
            case 31: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: 
            case 88: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotGit";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 11: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 36: 
            case 47: 
            case 73: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 21: 
            case 22: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: 
            case 27: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 25: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAtRemote";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 30: 
            case 71: 
            case 75: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRef";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRef";
                break;
            }
            case 41: 
            case 43: 
            case 48: 
            case 61: 
            case 65: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: 
            case 55: 
            case 58: 
            case 62: 
            case 86: 
            case 89: 
            case 94: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 45: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedPaths";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePaths";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePathToRepository";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRoot";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilePathsByGitRoot";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateRemoteBranch";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsFromRepositories";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesFromRoots";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsDiffBetweenRefs";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrintableRemotes";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesForFiles";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRootsIgnoringOthers";
                break;
            }
            case 57: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "toAbsolute";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalChangesForPaths";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupErrorPrefixes";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "joinToHtml";
                break;
            }
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "mention";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "findCorrespondentLocalChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGitDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRealRepositoryDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePathToRepository";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 29: 
            case 31: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: 
            case 88: 
            case 93: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortFilePathsByGitRoot";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGitRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGitRootOrNull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unescapePath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteByName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRemoteBranch";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRootsFromRepositories";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesFromRoots";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPathsDiffBetweenRefs";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForRootOrLogError";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPrintableRemotes";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForCurrentBranch";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesForFiles";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRootsIgnoringOthers";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findRefreshFileOrLog";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "toAbsolute";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findLocalChangesForPaths";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "showPathsInDialog";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "cleanupErrorPrefixes";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRemote";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "joinToHtml";
                break;
            }
            case 73: 
            case 75: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "mention";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "updateRepositories";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRepositories";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyChange";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "findCorrespondentLocalChanges";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfs";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "updateAndRefreshVfs";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLogString$8";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toAbsolute$6";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRemoteBranch$3";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRemoteByName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 29: 
            case 31: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: 
            case 88: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

