/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileAnnotation
extends FileAnnotation {
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    @Nullable
    private TObjectIntHashMap<VcsRevisionNumber> myRevisionMap;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        if (project == null) {
            GitFileAnnotation.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GitFileAnnotation.$$$reportNull$$$0(1);
        }
        if (lines == null) {
            GitFileAnnotation.$$$reportNull$$$0(2);
        }
        super(project);
        this.DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

            @Override
            public String doGetValue(LineInfo info) {
                return DateFormatUtil.formatPrettyDate((Date)info.getAuthorDate());
            }
        };
        this.REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return String.valueOf(lineInfo.getRevisionNumber().getShortRev());
            }
        };
        this.AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return lineInfo.getAuthor();
            }
        };
        this.myProject = project;
        this.myFile = file;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(this.myProject))));
        this.myBaseRevision = revision;
        this.myLines = lines;
    }

    public GitFileAnnotation(@NotNull GitFileAnnotation annotation) {
        if (annotation == null) {
            GitFileAnnotation.$$$reportNull$$$0(3);
        }
        this(annotation.getProject(), annotation.getFile(), annotation.getCurrentRevision(), annotation.getLines());
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFile, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        if (revisions == null) {
            GitFileAnnotation.$$$reportNull$$$0(4);
        }
        this.myRevisions = revisions;
        this.myRevisionMap = new TObjectIntHashMap();
        for (int i = 0; i < this.myRevisions.size(); ++i) {
            this.myRevisionMap.put((Object)this.myRevisions.get(i).getRevisionNumber(), i);
        }
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        if (lineInfo == null) {
            return null;
        }
        GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
        VcsFileRevision fileRevision = null;
        if (this.myRevisions != null && this.myRevisionMap != null && this.myRevisionMap.contains((Object)revisionNumber)) {
            fileRevision = this.myRevisions.get(this.myRevisionMap.get((Object)revisionNumber));
        }
        String commitMessage = fileRevision != null ? fileRevision.getCommitMessage() : lineInfo.getSubject() + "\n...";
        return GitBundle.message("annotation.tool.tip", revisionNumber.asString(), lineInfo.getAuthor(), DateFormatUtil.formatDateTime((Date)lineInfo.getAuthorDate()), commitMessage);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getAuthorDate() : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        List<LineInfo> list = this.myLines;
        if (list == null) {
            GitFileAnnotation.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GitFileAnnotation.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @Nullable
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        };
    }

    @Nullable
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new FileAnnotation.PreviousFileRevisionProvider(){

            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                int index;
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
                if (lineInfo == null) {
                    return null;
                }
                VcsFileRevision previousFileRevision = lineInfo.getPreviousFileRevision();
                if (previousFileRevision != null) {
                    return previousFileRevision;
                }
                GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
                if (GitFileAnnotation.this.myRevisions != null && GitFileAnnotation.this.myRevisionMap != null && GitFileAnnotation.this.myRevisionMap.contains((Object)revisionNumber) && (index = GitFileAnnotation.this.myRevisionMap.get((Object)revisionNumber)) + 1 < GitFileAnnotation.this.myRevisions.size()) {
                    return (VcsFileRevision)GitFileAnnotation.this.myRevisions.get(index + 1);
                }
                return null;
            }

            @Nullable
            public VcsFileRevision getLastRevision() {
                if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                    return new GitFileRevision(GitFileAnnotation.this.myProject, VcsUtil.getFilePath((VirtualFile)GitFileAnnotation.this.myFile), (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
                }
                return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
            }
        };
    }

    @Nullable
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        HashMap authorsMap = new HashMap();
        for (int i = 0; i < this.getLineCount(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo == null || authorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
            authorsMap.put(lineInfo.getRevisionNumber(), lineInfo.getAuthor());
        }
        return () -> GitFileAnnotation.lambda$getAuthorsMappingProvider$1((Map)authorsMap);
    }

    @Nullable
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
        for (int i = 0; i < this.getLineCount(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo == null) continue;
            GitRevisionNumber number = lineInfo.getRevisionNumber();
            Date date = lineInfo.getCommitterDate();
            dates.putValue((Object)date, (Object)number);
        }
        ArrayList orderedRevisions = new ArrayList();
        NavigableSet orderedDates = dates.navigableKeySet();
        for (Date date : orderedDates.descendingSet()) {
            Collection revisionNumbers = dates.get((Object)date);
            orderedRevisions.add(new ArrayList(revisionNumbers));
        }
        return () -> orderedRevisions;
    }

    private static /* synthetic */ Map lambda$getAuthorsMappingProvider$1(Map authorsMap) {
        return authorsMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/annotate/GitFileAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/annotate/GitFileAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRevisions";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LineInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myCommitterDate;
        @NotNull
        private final Date myAuthorDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        private final String mySubject;

        public LineInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date committerDate, @NotNull Date authorDate, @NotNull VcsUser author, @NotNull String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            if (project == null) {
                LineInfo.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                LineInfo.$$$reportNull$$$0(1);
            }
            if (path == null) {
                LineInfo.$$$reportNull$$$0(2);
            }
            if (committerDate == null) {
                LineInfo.$$$reportNull$$$0(3);
            }
            if (authorDate == null) {
                LineInfo.$$$reportNull$$$0(4);
            }
            if (author == null) {
                LineInfo.$$$reportNull$$$0(5);
            }
            if (subject == null) {
                LineInfo.$$$reportNull$$$0(6);
            }
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myCommitterDate = committerDate;
            this.myAuthorDate = authorDate;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            GitRevisionNumber gitRevisionNumber = this.myRevision;
            if (gitRevisionNumber == null) {
                LineInfo.$$$reportNull$$$0(7);
            }
            return gitRevisionNumber;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                LineInfo.$$$reportNull$$$0(8);
            }
            return filePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            GitFileRevision gitFileRevision = new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
            if (gitFileRevision == null) {
                LineInfo.$$$reportNull$$$0(9);
            }
            return gitFileRevision;
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getCommitterDate() {
            Date date = this.myCommitterDate;
            if (date == null) {
                LineInfo.$$$reportNull$$$0(10);
            }
            return date;
        }

        @NotNull
        public Date getAuthorDate() {
            Date date = this.myAuthorDate;
            if (date == null) {
                LineInfo.$$$reportNull$$$0(11);
            }
            return date;
        }

        @NotNull
        public String getAuthor() {
            String string = this.myAuthor.getName();
            if (string == null) {
                LineInfo.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        public String getSubject() {
            String string = this.mySubject;
            if (string == null) {
                LineInfo.$$$reportNull$$$0(13);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "committerDate";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authorDate";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subject";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/annotate/GitFileAnnotation$LineInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/annotate/GitFileAnnotation$LineInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileRevision";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitterDate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorDate";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (VirtualFile)GitFileAnnotation.this.myFile, (VcsKey)GitVcs.getKey());
            }
        }
    }
}

