/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.rebase.GitRebaseEditorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseParams {
    @Nullable
    private final String myBranch;
    @Nullable
    private final String myNewBase;
    @NotNull
    private final String myUpstream;
    private final boolean myInteractive;
    private final boolean myPreserveMerges;
    @Nullable
    private final GitRebaseEditorHandler myEditorHandler;

    @NotNull
    public static GitRebaseParams editCommits(@NotNull String base, @Nullable GitRebaseEditorHandler editorHandler, boolean preserveMerges) {
        if (base == null) {
            GitRebaseParams.$$$reportNull$$$0(0);
        }
        GitRebaseParams gitRebaseParams = new GitRebaseParams(null, null, base, true, preserveMerges, editorHandler);
        if (gitRebaseParams == null) {
            GitRebaseParams.$$$reportNull$$$0(1);
        }
        return gitRebaseParams;
    }

    public GitRebaseParams(@NotNull String upstream) {
        if (upstream == null) {
            GitRebaseParams.$$$reportNull$$$0(2);
        }
        this(null, null, upstream, false, false);
    }

    public GitRebaseParams(@Nullable String branch, @Nullable String newBase, @NotNull String upstream, boolean interactive, boolean preserveMerges) {
        if (upstream == null) {
            GitRebaseParams.$$$reportNull$$$0(3);
        }
        this(branch, newBase, upstream, interactive, preserveMerges, null);
    }

    private GitRebaseParams(@Nullable String branch, @Nullable String newBase, @NotNull String upstream, boolean interactive, boolean preserveMerges, @Nullable GitRebaseEditorHandler editorHandler) {
        if (upstream == null) {
            GitRebaseParams.$$$reportNull$$$0(4);
        }
        this.myBranch = StringUtil.nullize((String)branch, (boolean)true);
        this.myNewBase = StringUtil.nullize((String)newBase, (boolean)true);
        this.myUpstream = upstream;
        this.myInteractive = interactive;
        this.myPreserveMerges = preserveMerges;
        this.myEditorHandler = editorHandler;
    }

    @NotNull
    public List<String> asCommandLineArguments() {
        ArrayList args = ContainerUtil.newArrayList();
        if (this.myInteractive) {
            args.add("--interactive");
        }
        if (this.myPreserveMerges) {
            args.add("--preserve-merges");
        }
        if (this.myNewBase != null) {
            args.addAll(Arrays.asList("--onto", this.myNewBase));
        }
        args.add(this.myUpstream);
        if (this.myBranch != null) {
            args.add(this.myBranch);
        }
        ArrayList arrayList = args;
        if (arrayList == null) {
            GitRebaseParams.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public String getNewBase() {
        return this.myNewBase;
    }

    @NotNull
    public String getUpstream() {
        String string = this.myUpstream;
        if (string == null) {
            GitRebaseParams.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String toString() {
        return StringUtil.join(this.asCommandLineArguments(), (String)" ");
    }

    public boolean isInteractive() {
        return this.myInteractive;
    }

    @Nullable
    public String getBranch() {
        return this.myBranch;
    }

    @Nullable
    public GitRebaseEditorHandler getEditorHandler() {
        return this.myEditorHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitRebaseParams";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitRebaseParams";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "editCommits";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asCommandLineArguments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpstream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editCommits";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

