/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.idea.RareLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsAnnotationCachedProxy;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnCopiesRefreshManager;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnEditFileProvider;
import org.jetbrains.idea.svn.SvnEntriesFileListener;
import org.jetbrains.idea.svn.SvnExceptionLogFilter;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.annotate.SvnAnnotationProvider;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.CmdClientFactory;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.SvnKitClientFactory;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExecutableChecker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.svnkit.SvnKitManager;
import org.jetbrains.idea.svn.update.SvnIntegrateEnvironment;
import org.jetbrains.idea.svn.update.SvnUpdateEnvironment;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnVcs
extends AbstractVcs<CommittedChangeList> {
    private static final String DO_NOT_LISTEN_TO_WC_DB = "svn.do.not.listen.to.wc.db";
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#svn_refresh");
    public static boolean ourListenToWcDb = !Boolean.getBoolean("svn.do.not.listen.to.wc.db");
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance((String)"org.jetbrains.idea.svn.SvnVcs"));
    @NonNls
    public static final String VCS_NAME = "svn";
    public static final String VCS_DISPLAY_NAME = "Subversion";
    private static final VcsKey ourKey = SvnVcs.createKey((String)"svn");
    public static final Topic<Runnable> WC_CONVERTED = new Topic("WC_CONVERTED", Runnable.class);
    private final Map<String, Map<String, Pair<PropertyValue, Trinity<Long, Long, Long>>>> myPropertyCache;
    @NotNull
    private final SvnConfiguration myConfiguration;
    private final SvnEntriesFileListener myEntriesFileListener;
    private CheckinEnvironment myCheckinEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private UpdateEnvironment mySvnUpdateEnvironment;
    private UpdateEnvironment mySvnIntegrateEnvironment;
    private AnnotationProvider myAnnotationProvider;
    private DiffProvider mySvnDiffProvider;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private EditFileProvider myEditFilesProvider;
    private SvnCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myCheckoutOptions;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;
    private final SvnChangelistListener myChangeListListener;
    private SvnCopiesRefreshManager myCopiesRefreshManager;
    private SvnFileUrlMappingImpl myMapping;
    private final MyFrameStateListener myFrameStateListener;
    public static final Topic<Consumer> ROOTS_RELOADED = new Topic("ROOTS_RELOADED", Consumer.class);
    private VcsListener myVcsListener;
    private SvnBranchPointsCalculator mySvnBranchPointsCalculator;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final SvnAuthenticationNotifier myAuthNotifier;
    private final SvnLoadedBranchesStorage myLoadedBranchesStorage;
    private final SvnExecutableChecker myChecker;
    private SvnCheckoutProvider myCheckoutProvider;
    @NotNull
    private final ClientFactory cmdClientFactory;
    @NotNull
    private final ClientFactory svnKitClientFactory;
    @NotNull
    private final SvnKitManager svnKitManager;
    private final boolean myLogExceptions;

    public SvnVcs(@NotNull Project project, MessageBus bus, SvnConfiguration svnConfiguration, SvnLoadedBranchesStorage storage) {
        if (project == null) {
            SvnVcs.$$$reportNull$$$0(0);
        }
        super(project, VCS_NAME);
        this.myPropertyCache = ContainerUtil.createSoftMap();
        this.myLoadedBranchesStorage = storage;
        this.myRootsToWorkingCopies = new RootsToWorkingCopies(this);
        this.myConfiguration = svnConfiguration;
        this.myAuthNotifier = new SvnAuthenticationNotifier(this);
        this.cmdClientFactory = new CmdClientFactory(this);
        this.svnKitClientFactory = new SvnKitClientFactory(this);
        this.svnKitManager = new SvnKitManager(this);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        if (this.myProject.isDefault()) {
            this.myChangeListListener = null;
            this.myEntriesFileListener = null;
        } else {
            this.myEntriesFileListener = new SvnEntriesFileListener(project);
            this.upgradeIfNeeded(bus);
            this.myChangeListListener = new SvnChangelistListener(this);
            this.myVcsListener = () -> this.invokeRefreshSvnRoots();
        }
        this.myFrameStateListener = project.isDefault() ? null : new MyFrameStateListener(ChangeListManager.getInstance((Project)project), VcsDirtyScopeManager.getInstance((Project)project));
        this.myChecker = new SvnExecutableChecker(this);
        Application app = ApplicationManager.getApplication();
        this.myLogExceptions = app != null && (app.isInternal() || app.isUnitTestMode());
    }

    public void postStartup() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myCopiesRefreshManager = new SvnCopiesRefreshManager((SvnFileUrlMappingImpl)this.getSvnFileUrlMapping());
        if (!this.myConfiguration.isCleanupRun()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.cleanup17copies();
                this.myConfiguration.setCleanupRun(true);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            this.invokeRefreshSvnRoots();
        }
    }

    private void cleanup17copies() {
        Runnable callCleanupWorker = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            new CleanupWorker(this, Collections.emptyList()){

                @Override
                protected void fillRoots() {
                    for (WCInfo info : SvnVcs.this.getAllWcInfos()) {
                        if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat())) continue;
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(info.getRootInfo().getIoFile());
                        if (file == null) {
                            LOG.info("Wasn't able to find virtual file for wc root: " + info.getPath());
                            continue;
                        }
                        this.myRoots.add(file);
                    }
                }
            }.execute();
        };
        this.myCopiesRefreshManager.waitRefresh(() -> ApplicationManager.getApplication().invokeLater(callCleanupWorker));
    }

    public boolean checkCommandLineVersion() {
        return this.getFactory() != this.cmdClientFactory || this.myChecker.checkExecutableAndNotifyIfNeeded();
    }

    public void invokeRefreshSvnRoots() {
        if (REFRESH_LOG.isDebugEnabled()) {
            REFRESH_LOG.debug("refresh: ", new Throwable());
        }
        if (this.myCopiesRefreshManager != null) {
            this.myCopiesRefreshManager.asynchRequest();
        }
    }

    private void upgradeIfNeeded(MessageBus bus) {
        MessageBusConnection connection = bus.connect();
        connection.subscribe(ChangeListManagerImpl.LISTS_LOADED, lists -> {
            if (lists.isEmpty()) {
                return;
            }
            try {
                ChangeListManager.getInstance((Project)this.myProject).setReadOnly(LocalChangeList.DEFAULT_NAME, true);
                if (!this.myConfiguration.changeListsSynchronized()) {
                    this.processChangeLists(lists);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                this.myConfiguration.upgrade();
            }
            connection.disconnect();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeLists(List<LocalChangeList> lists) {
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject);
        plVcsManager.startBackgroundVcsOperation();
        try {
            for (LocalChangeList list : lists) {
                if (list.isDefault()) continue;
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    this.correctListForRevision(plVcsManager, change.getBeforeRevision(), list.getName());
                    this.correctListForRevision(plVcsManager, change.getAfterRevision(), list.getName());
                }
            }
        }
        finally {
            Application appManager = ApplicationManager.getApplication();
            if (appManager.isDispatchThread()) {
                appManager.executeOnPooledThread(() -> plVcsManager.stopBackgroundVcsOperation());
            } else {
                plVcsManager.stopBackgroundVcsOperation();
            }
        }
    }

    private void correctListForRevision(@NotNull ProjectLevelVcsManager plVcsManager, @Nullable ContentRevision revision, @NotNull String name) {
        FilePath path;
        AbstractVcs vcs;
        if (plVcsManager == null) {
            SvnVcs.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SvnVcs.$$$reportNull$$$0(2);
        }
        if (revision != null && (vcs = plVcsManager.getVcsFor(path = revision.getFile())) != null && VCS_NAME.equals(vcs.getName())) {
            try {
                this.getFactory(path.getIOFile()).createChangeListClient().add(name, path.getIOFile(), null);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
    }

    public void activate() {
        if (!this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)this.myChangeListListener);
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
        }
        SvnApplicationSettings.getInstance().svnActivated();
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        LoadedRevisionsCache.getInstance(this.myProject);
        FrameStateManager.getInstance().addListener((FrameStateListener)this.myFrameStateListener);
        this.myAuthNotifier.init();
        this.mySvnBranchPointsCalculator = new SvnBranchPointsCalculator(this);
        this.svnKitManager.activate();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.checkCommandLineVersion();
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> this.postStartup()));
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myRootsToWorkingCopies);
        this.myLoadedBranchesStorage.activate();
    }

    public static Logger wrapLogger(Logger logger) {
        return RareLogger.wrap((Logger)logger, (boolean)Boolean.getBoolean("svn.logger.fairsynch"), (RareLogger.LogFilter[])new RareLogger.LogFilter[]{new SvnExceptionLogFilter()});
    }

    public RootsToWorkingCopies getRootsToWorkingCopies() {
        return this.myRootsToWorkingCopies;
    }

    public SvnAuthenticationNotifier getAuthNotifier() {
        return this.myAuthNotifier;
    }

    public void deactivate() {
        FrameStateManager.getInstance().removeListener((FrameStateListener)this.myFrameStateListener);
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        SvnApplicationSettings.getInstance().svnDeactivated();
        if (this.myCommittedChangesProvider != null) {
            this.myCommittedChangesProvider.deactivate();
        }
        if (this.myChangeListListener != null && !this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)this.myChangeListListener);
        }
        this.myRootsToWorkingCopies.clear();
        this.myAuthNotifier.stop();
        this.myAuthNotifier.clear();
        this.mySvnBranchPointsCalculator.deactivate();
        this.mySvnBranchPointsCalculator = null;
        this.myLoadedBranchesStorage.deactivate();
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        if (this.myEditFilesProvider == null) {
            this.myEditFilesProvider = new SvnEditFileProvider(this);
        }
        return this.myEditFilesProvider;
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new SvnChangeProvider(this);
        }
        ChangeProvider changeProvider = this.myChangeProvider;
        if (changeProvider == null) {
            SvnVcs.$$$reportNull$$$0(3);
        }
        return changeProvider;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.mySvnIntegrateEnvironment == null) {
            this.mySvnIntegrateEnvironment = new SvnIntegrateEnvironment(this);
        }
        return this.mySvnIntegrateEnvironment;
    }

    public UpdateEnvironment createUpdateEnvironment() {
        if (this.mySvnUpdateEnvironment == null) {
            this.mySvnUpdateEnvironment = new SvnUpdateEnvironment(this);
        }
        return this.mySvnUpdateEnvironment;
    }

    public String getDisplayName() {
        return VCS_DISPLAY_NAME;
    }

    public Configurable getConfigurable() {
        return null;
    }

    @NotNull
    public SvnConfiguration getSvnConfiguration() {
        SvnConfiguration svnConfiguration = this.myConfiguration;
        if (svnConfiguration == null) {
            SvnVcs.$$$reportNull$$$0(4);
        }
        return svnConfiguration;
    }

    public static SvnVcs getInstance(@NotNull Project project) {
        if (project == null) {
            SvnVcs.$$$reportNull$$$0(5);
        }
        return (SvnVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(VCS_NAME);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new SvnCheckinEnvironment(this);
        }
        CheckinEnvironment checkinEnvironment = this.myCheckinEnvironment;
        if (checkinEnvironment == null) {
            SvnVcs.$$$reportNull$$$0(6);
        }
        return checkinEnvironment;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myRollbackEnvironment == null) {
            this.myRollbackEnvironment = new SvnRollbackEnvironment(this);
        }
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            SvnVcs.$$$reportNull$$$0(7);
        }
        return rollbackEnvironment;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return new SvnHistoryProvider(this);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new SvnAnnotationProvider(this);
        }
        return new VcsAnnotationCachedProxy((AbstractVcs)this, this.myAnnotationProvider);
    }

    public DiffProvider getDiffProvider() {
        if (this.mySvnDiffProvider == null) {
            this.mySvnDiffProvider = new SvnDiffProvider(this);
        }
        return this.mySvnDiffProvider;
    }

    private static Trinity<Long, Long, Long> getTimestampForPropertiesChange(File ioFile, boolean isDir) {
        File dir = isDir ? ioFile : ioFile.getParentFile();
        String relPath = SVNAdminUtil.getPropPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathBase = SVNAdminUtil.getPropBasePath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathRevert = SVNAdminUtil.getPropRevertPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        return new Trinity((Object)new File(dir, relPath).lastModified(), (Object)new File(dir, relPathBase).lastModified(), (Object)new File(dir, relPathRevert).lastModified());
    }

    private static boolean trinitiesEqual(Trinity<Long, Long, Long> t1, Trinity<Long, Long, Long> t2) {
        if ((Long)t2.first == 0L && (Long)t2.second == 0L && (Long)t2.third == 0L) {
            return false;
        }
        return t1.equals(t2);
    }

    @Nullable
    public PropertyValue getPropertyWithCaching(VirtualFile file, String propName) throws VcsException {
        Map<String, Pair<PropertyValue, Trinity<Long, Long, Long>>> cachedMap = this.myPropertyCache.get(SvnVcs.keyForVf(file));
        Pair<PropertyValue, Trinity<Long, Long, Long>> cachedValue = cachedMap == null ? null : cachedMap.get(propName);
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        Trinity<Long, Long, Long> tsTrinity = SvnVcs.getTimestampForPropertiesChange(ioFile, file.isDirectory());
        if (cachedValue != null && SvnVcs.trinitiesEqual((Trinity<Long, Long, Long>)((Trinity)cachedValue.getSecond()), tsTrinity)) {
            return (PropertyValue)cachedValue.getFirst();
        }
        PropertyClient client = this.getFactory(ioFile).createPropertyClient();
        PropertyValue value = client.getProperty(SvnTarget.fromFile((File)ioFile, (SVNRevision)SVNRevision.WORKING), propName, false, SVNRevision.WORKING);
        if (cachedMap == null) {
            cachedMap = new HashMap<String, Pair<PropertyValue, Trinity<Long, Long, Long>>>();
            this.myPropertyCache.put(SvnVcs.keyForVf(file), cachedMap);
        }
        cachedMap.put(propName, (Pair<PropertyValue, Trinity<Long, Long, Long>>)Pair.create((Object)value, tsTrinity));
        return value;
    }

    public boolean fileExistsInVcs(FilePath path) {
        File file = path.getIOFile();
        try {
            Status status = this.getFactory(file).createStatusClient().doStatus(file, false);
            if (status != null) {
                return status.is(StatusType.STATUS_ADDED) ? status.isCopied() : !status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_IGNORED, StatusType.STATUS_OBSTRUCTED);
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return false;
    }

    public boolean fileIsUnderVcs(@NotNull FilePath path) {
        VirtualFile file;
        if (path == null) {
            SvnVcs.$$$reportNull$$$0(8);
        }
        return (file = path.getVirtualFile()) != null && SvnStatusUtil.isUnderControl(this, file);
    }

    @Nullable
    public Info getInfo(@NotNull SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SvnBindException {
        if (url == null) {
            SvnVcs.$$$reportNull$$$0(9);
        }
        return this.getFactory().createInfoClient().doInfo(SvnTarget.fromURL((SVNURL)url, (SVNRevision)pegRevision), revision);
    }

    @Nullable
    public Info getInfo(@NotNull SVNURL url, SVNRevision revision) throws SvnBindException {
        if (url == null) {
            SvnVcs.$$$reportNull$$$0(10);
        }
        return this.getInfo(url, SVNRevision.UNDEFINED, revision);
    }

    @Nullable
    public Info getInfo(@NotNull VirtualFile file) {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(11);
        }
        return this.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    public Info getInfo(@NotNull String path) {
        if (path == null) {
            SvnVcs.$$$reportNull$$$0(12);
        }
        return this.getInfo(new File(path));
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(13);
        }
        return this.getInfo(ioFile, SVNRevision.UNDEFINED);
    }

    public void collectInfo(@NotNull Collection<File> files, @Nullable InfoConsumer handler) {
        File first;
        if (files == null) {
            SvnVcs.$$$reportNull$$$0(14);
        }
        if ((first = (File)ContainerUtil.getFirstItem(files)) != null) {
            ClientFactory factory = this.getFactory(first);
            try {
                if (factory instanceof CmdClientFactory) {
                    factory.createInfoClient().doInfo(files, handler);
                } else {
                    for (File file : files) {
                        Info info = this.getInfo(file);
                        if (handler == null) continue;
                        handler.consume(info);
                    }
                }
            }
            catch (SVNException e) {
                this.handleInfoException(new SvnBindException(e));
            }
            catch (SvnBindException e) {
                this.handleInfoException(e);
            }
        }
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile, @NotNull SVNRevision revision) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(15);
        }
        if (revision == null) {
            SvnVcs.$$$reportNull$$$0(16);
        }
        Info result = null;
        try {
            result = this.getFactory(ioFile).createInfoClient().doInfo(ioFile, revision);
        }
        catch (SvnBindException e) {
            this.handleInfoException(e);
        }
        return result;
    }

    private void handleInfoException(@NotNull SvnBindException e) {
        if (e == null) {
            SvnVcs.$$$reportNull$$$0(17);
        }
        if (!this.myLogExceptions || SvnUtil.isUnversionedOrNotFound(e) || e.contains(SVNErrorCode.WC_UNSUPPORTED_FORMAT) || e.contains(SVNErrorCode.WC_UPGRADE_REQUIRED)) {
            LOG.debug((Throwable)((Object)e));
        } else {
            LOG.error((Throwable)((Object)e));
        }
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(18);
        }
        WorkingCopyFormat workingCopyFormat = this.getWorkingCopyFormat(ioFile, true);
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(19);
        }
        return workingCopyFormat;
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile, boolean useMapping) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(20);
        }
        WorkingCopyFormat format = WorkingCopyFormat.UNKNOWN;
        if (useMapping) {
            RootUrlInfo rootInfo = this.getSvnFileUrlMapping().getWcRootForFilePath(ioFile);
            format = rootInfo != null ? rootInfo.getFormat() : WorkingCopyFormat.UNKNOWN;
        }
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.findRootAndGetFormat(ioFile) : format;
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(21);
        }
        return workingCopyFormat;
    }

    public boolean isWcRoot(@NotNull FilePath filePath) {
        WorkingCopy wcRoot;
        if (filePath == null) {
            SvnVcs.$$$reportNull$$$0(22);
        }
        boolean isWcRoot = false;
        VirtualFile file = filePath.getVirtualFile();
        WorkingCopy workingCopy = wcRoot = file != null ? this.myRootsToWorkingCopies.getWcRoot(file) : null;
        if (wcRoot != null) {
            isWcRoot = wcRoot.getFile().getAbsolutePath().equals(filePath.getPath());
        }
        return isWcRoot;
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{SvnFileStatus.EXTERNAL, SvnFileStatus.OBSTRUCTED, SvnFileStatus.REPLACED};
    }

    @NotNull
    public CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new SvnCommittedChangesProvider(this);
        }
        SvnCommittedChangesProvider svnCommittedChangesProvider = this.myCommittedChangesProvider;
        if (svnCommittedChangesProvider == null) {
            SvnVcs.$$$reportNull$$$0(23);
        }
        return svnCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        SVNRevision revision = SVNRevision.parse((String)revisionNumberString);
        if (revision.equals((Object)SVNRevision.UNDEFINED)) {
            return null;
        }
        return new SvnRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return SvnUtil.seemsLikeVersionedDir(dir);
    }

    @NotNull
    public SvnFileUrlMapping getSvnFileUrlMapping() {
        if (this.myMapping == null) {
            this.myMapping = SvnFileUrlMappingImpl.getInstance(this.myProject);
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = this.myMapping;
        if (svnFileUrlMappingImpl == null) {
            SvnVcs.$$$reportNull$$$0(24);
        }
        return svnFileUrlMappingImpl;
    }

    public List<WCInfo> getAllWcInfos() {
        SvnFileUrlMapping urlMapping = this.getSvnFileUrlMapping();
        List<RootUrlInfo> infoList = urlMapping.getAllWcInfos();
        ArrayList<WCInfo> infos = new ArrayList<WCInfo>();
        for (RootUrlInfo info : infoList) {
            File file = info.getIoFile();
            infos.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this, file)));
        }
        return infos;
    }

    public List<WCInfo> getWcInfosWithErrors() {
        ArrayList<WCInfo> result = new ArrayList<WCInfo>(this.getAllWcInfos());
        for (RootUrlInfo info : this.getSvnFileUrlMapping().getErrorRoots()) {
            result.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(info.getIoFile()), Depth.UNKNOWN));
        }
        return result;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.getSvnFileUrlMapping();
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new SvnMergeProvider(this.myProject);
        }
        return this.myMergeProvider;
    }

    private static String keyForVf(VirtualFile vf) {
        return vf.getUrl();
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    @NotNull
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        if (in == null) {
            SvnVcs.$$$reportNull$$$0(25);
        }
        if (convertor == null) {
            SvnVcs.$$$reportNull$$$0(26);
        }
        if (in.size() <= 1) {
            List<S> list = in;
            if (list == null) {
                SvnVcs.$$$reportNull$$$0(27);
            }
            return list;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        ArrayList notMatched = ContainerUtil.newArrayList();
        for (S s : in) {
            VirtualFile vf = convertor.apply(s);
            if (vf == null) continue;
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
            SVNURL url = this.getSvnFileUrlMapping().getUrlForFile(ioFile);
            if (url == null && (url = SvnUtil.getUrl(this, ioFile)) == null) {
                notMatched.add(s);
                continue;
            }
            infos.add(new MyPair(vf, url, s));
        }
        List filtered = new UniqueRootsFilter().filter(infos);
        List converted = ContainerUtil.map(filtered, MyPair::getSrc);
        List list = ContainerUtil.concat((List)converted, (List)notMatched);
        if (list == null) {
            SvnVcs.$$$reportNull$$$0(28);
        }
        return list;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean isVcsBackgroundOperationsAllowed(@NotNull VirtualFile root) {
        ClientFactory factory;
        if (root == null) {
            SvnVcs.$$$reportNull$$$0(29);
        }
        return ThreeState.YES.equals((Object)this.myAuthNotifier.isAuthenticatedFor(root, (factory = this.getFactory(VfsUtilCore.virtualToIoFile((VirtualFile)root))) == this.cmdClientFactory ? factory : null));
    }

    public SvnBranchPointsCalculator getSvnBranchPointsCalculator() {
        return this.mySvnBranchPointsCalculator;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public CheckoutProvider getCheckoutProvider() {
        if (this.myCheckoutProvider == null) {
            this.myCheckoutProvider = new SvnCheckoutProvider();
        }
        return this.myCheckoutProvider;
    }

    @NotNull
    public SvnKitManager getSvnKitManager() {
        SvnKitManager svnKitManager = this.svnKitManager;
        if (svnKitManager == null) {
            SvnVcs.$$$reportNull$$$0(30);
        }
        return svnKitManager;
    }

    @NotNull
    private WorkingCopyFormat getProjectRootFormat() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        WorkingCopyFormat workingCopyFormat = baseDir != null ? this.getWorkingCopyFormat(VfsUtilCore.virtualToIoFile((VirtualFile)baseDir)) : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(31);
        }
        return workingCopyFormat;
    }

    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.getFactory(this.getProjectRootFormat(), false);
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(32);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            SvnVcs.$$$reportNull$$$0(33);
        }
        ClientFactory clientFactory = this.getFactory(format, false);
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(34);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file) {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(35);
        }
        ClientFactory clientFactory = this.getFactory(file, true);
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(36);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file, boolean useMapping) {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(37);
        }
        ClientFactory clientFactory = this.getFactory(this.getWorkingCopyFormat(file, useMapping), true);
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(38);
        }
        return clientFactory;
    }

    @NotNull
    private ClientFactory getFactory(@NotNull WorkingCopyFormat format, boolean useProjectRootForUnknown) {
        if (format == null) {
            SvnVcs.$$$reportNull$$$0(39);
        }
        boolean is18OrGreater = format.isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT);
        boolean isUnknown = WorkingCopyFormat.UNKNOWN.equals((Object)format);
        ClientFactory clientFactory = is18OrGreater ? this.cmdClientFactory : (!isUnknown && !this.isSupportedByCommandLine(format) ? this.svnKitClientFactory : (useProjectRootForUnknown && isUnknown ? this.getFactory() : this.getFactoryFromSettings()));
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(40);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull SvnTarget target) {
        if (target == null) {
            SvnVcs.$$$reportNull$$$0(41);
        }
        ClientFactory clientFactory = target.isFile() ? this.getFactory(target.getFile()) : this.getFactory();
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(42);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactoryFromSettings() {
        ClientFactory clientFactory = this.myConfiguration.isCommandLine() ? this.cmdClientFactory : this.svnKitClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(43);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getOtherFactory() {
        ClientFactory clientFactory = this.myConfiguration.isCommandLine() ? this.svnKitClientFactory : this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(44);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getOtherFactory(@NotNull ClientFactory factory) {
        if (factory == null) {
            SvnVcs.$$$reportNull$$$0(45);
        }
        ClientFactory clientFactory = factory.equals(this.cmdClientFactory) ? this.svnKitClientFactory : this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(46);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getCommandLineFactory() {
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(47);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getSvnKitFactory() {
        ClientFactory clientFactory = this.svnKitClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(48);
        }
        return clientFactory;
    }

    @NotNull
    public WorkingCopyFormat getLowestSupportedFormatForCommandLine() {
        WorkingCopyFormat result;
        try {
            result = WorkingCopyFormat.from(CmdVersionClient.parseVersion(Registry.stringValue((String)"svn.lowest.supported.format.for.command.line")));
        }
        catch (SvnBindException ignore) {
            result = WorkingCopyFormat.ONE_DOT_SEVEN;
        }
        WorkingCopyFormat workingCopyFormat = result;
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(49);
        }
        return workingCopyFormat;
    }

    public boolean isSupportedByCommandLine(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            SvnVcs.$$$reportNull$$$0(50);
        }
        return format.isOrGreater(this.getLowestSupportedFormatForCommandLine());
    }

    public boolean is16SupportedByCommandLine() {
        return this.isSupportedByCommandLine(WorkingCopyFormat.ONE_DOT_SIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plVcsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnVcs";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 33: 
            case 39: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnVcs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckinEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRollbackEnvironment";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingCopyFormat";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChangesProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnFileUrlMapping";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueRoots";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnKitManager";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRootFormat";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryFromSettings";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherFactory";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineFactory";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnKitFactory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowestSupportedFormatForCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctListForRevision";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileIsUnderVcs";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleInfoException";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingCopyFormat";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isWcRoot";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueRoots";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isVcsBackgroundOperationsAllowed";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFactory";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getOtherFactory";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedByCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private final ChangeListManager myClManager;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        private MyFrameStateListener(ChangeListManager clManager, VcsDirtyScopeManager dirtyScopeManager) {
            this.myClManager = clManager;
            this.myDirtyScopeManager = dirtyScopeManager;
        }

        public void onFrameActivated() {
            List folders = ((ChangeListManagerImpl)this.myClManager).getLockedFolders();
            if (!folders.isEmpty()) {
                this.myDirtyScopeManager.filesDirty(null, (Collection)folders);
            }
        }
    }

    private static class MyPair<T>
    implements RootUrlPair {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final SVNURL myUrl;
        private final T mySrc;

        private MyPair(@NotNull VirtualFile file, @NotNull SVNURL url, T src) {
            if (file == null) {
                MyPair.$$$reportNull$$$0(0);
            }
            if (url == null) {
                MyPair.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myUrl = url;
            this.mySrc = src;
        }

        public T getSrc() {
            return this.mySrc;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                MyPair.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @Override
        @NotNull
        public SVNURL getUrl() {
            SVNURL sVNURL = this.myUrl;
            if (sVNURL == null) {
                MyPair.$$$reportNull$$$0(3);
            }
            return sVNURL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnVcs$MyPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnVcs$MyPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

