/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.dialogs.SelectFilesDialog;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class MarkResolvedAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance(MarkResolvedAction.class);

    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("action.name.mark.resolved", new Object[0]);
        if (string == null) {
            MarkResolvedAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean needsAllFiles() {
        return false;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            MarkResolvedAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            MarkResolvedAction.$$$reportNull$$$0(2);
        }
        FileStatus status = FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file);
        return file.isDirectory() ? SvnStatusUtil.isUnderControl(vcs, file) : FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            MarkResolvedAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            MarkResolvedAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            MarkResolvedAction.$$$reportNull$$$0(5);
        }
        this.batchPerform(vcs, (VirtualFile[])ContainerUtil.ar((Object[])new VirtualFile[]{file}), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            MarkResolvedAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            MarkResolvedAction.$$$reportNull$$$0(7);
        }
        if (context == null) {
            MarkResolvedAction.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().saveAll();
        Collection<String> paths = MarkResolvedAction.collectResolvablePaths(vcs, files);
        if (paths.isEmpty()) {
            Messages.showInfoMessage((Project)vcs.getProject(), (String)SvnBundle.message("message.text.no.conflicts.found", new Object[0]), (String)SvnBundle.message("message.title.no.conflicts.found", new Object[0]));
            return;
        }
        String[] pathsArray = ArrayUtil.toStringArray(paths);
        SelectFilesDialog dialog = new SelectFilesDialog(vcs.getProject(), SvnBundle.message("label.select.files.and.directories.to.mark.resolved", new Object[0]), SvnBundle.message("dialog.title.mark.resolved", new Object[0]), SvnBundle.message("action.name.mark.resolved", new Object[0]), pathsArray, "vcs.subversion.resolve");
        if (!dialog.showAndGet()) {
            return;
        }
        pathsArray = dialog.getSelectedPaths();
        try {
            for (String string : pathsArray) {
                File ioFile = new File(string);
                ConflictClient client = vcs.getFactory(ioFile).createConflictClient();
                client.resolve(ioFile, Depth.EMPTY, true, true, true);
            }
        }
        finally {
            for (String string : files) {
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).fileDirty((VirtualFile)string);
                string.refresh(true, false);
                if (string.getParent() == null) continue;
                string.getParent().refresh(true, false);
            }
        }
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    @NotNull
    private static Collection<String> collectResolvablePaths(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files) {
        if (vcs == null) {
            MarkResolvedAction.$$$reportNull$$$0(9);
        }
        if (files == null) {
            MarkResolvedAction.$$$reportNull$$$0(10);
        }
        TreeSet result = ContainerUtil.newTreeSet();
        for (VirtualFile file : files) {
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                StatusClient client = vcs.getFactory(path).createStatusClient();
                client.doStatus(path, SVNRevision.UNDEFINED, Depth.INFINITY, false, false, false, false, status -> {
                    if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == StatusType.STATUS_CONFLICTED) {
                        result.add(status.getFile().getAbsolutePath());
                    }
                });
            }
            catch (SvnBindException e) {
                LOG.warn((Throwable)((Object)e));
            }
        }
        TreeSet treeSet = result;
        if (treeSet == null) {
            MarkResolvedAction.$$$reportNull$$$0(11);
        }
        return treeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/MarkResolvedAction";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/MarkResolvedAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectResolvablePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectResolvablePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

