/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class MacMessagesParser {
    private static final String ourMapName = "macMessages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String file = args[0];
        String outFile = args[1];
        File file1 = new File(file);
        File file2 = new File(outFile);
        if (!file1.exists()) {
            System.out.println("no file");
            return;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            String line;
            fis = new FileInputStream(file1);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
            fos = new FileOutputStream(file2);
            PrintStream printStream = new PrintStream(fos);
            int cnt = 0;
            while ((line = bufferedReader.readLine()) != null) {
                MacMessagesParser.processLine(line, printStream, cnt);
                if (++cnt < 3) continue;
                cnt = 0;
            }
            printStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void processLine(String line, PrintStream printStream, int cnt) {
        switch (cnt) {
            case 0: {
                String[] parts = line.trim().replace('\t', ' ').split(" ");
                if (parts.length != 2) {
                    throw new IllegalStateException(line);
                }
                printStream.println();
                printStream.append(ourMapName).append(".put(").append(parts[1]).append(", new Trinity<String, String, String>(\"").append(parts[0]).append("\", \"");
                break;
            }
            case 1: {
                printStream.append(line.trim()).append("\", \"");
                break;
            }
            case 2: {
                printStream.append(line.trim()).append("\"));");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

