/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.upgrade;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkout.SvnKitCheckoutClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitUpgradeClient
extends BaseSvnClient
implements UpgradeClient {
    @Override
    public void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        if (path == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(0);
        }
        if (format == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(1);
        }
        this.validateFormat(format, this.getSupportedFormats());
        SVNWCClient client = this.myVcs.getSvnKitManager().createUpgradeClient();
        client.setEventHandler(SvnKitUpgradeClient.toEventHandler(handler));
        try {
            SvnKitUpgradeClient.cleanupIfNecessary(path, format, client, handler);
            SvnKitUpgradeClient.upgrade(path, format, client, handler);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() {
        return SvnKitCheckoutClient.SUPPORTED_FORMATS;
    }

    private static void cleanupIfNecessary(@NotNull File path, @NotNull WorkingCopyFormat format, @NotNull SVNWCClient client, @Nullable ProgressTracker handler) throws SVNException, VcsException {
        if (path == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(2);
        }
        if (format == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(3);
        }
        if (client == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(4);
        }
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            SvnKitUpgradeClient.callHandler(handler, SvnKitUpgradeClient.createEvent(path, EventAction.UPDATE_STARTED));
            client.doCleanup(path);
        }
    }

    private static void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @NotNull SVNWCClient client, @Nullable ProgressTracker handler) throws SVNException, VcsException {
        if (path == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(5);
        }
        if (format == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(6);
        }
        if (client == null) {
            SvnKitUpgradeClient.$$$reportNull$$$0(7);
        }
        SvnKitUpgradeClient.callHandler(handler, SvnKitUpgradeClient.createEvent(path, EventAction.UPDATE_COMPLETED));
        client.doSetWCFormat(path, format.getFormat());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "upgrade";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanupIfNecessary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

