/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.rdr.Exception;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public abstract class InStream {
    public static int maxStringLength = 65535;
    protected byte[] b;
    protected int ptr;
    protected int end;

    public int check(int n, int n2, boolean bl) {
        if (this.ptr + n * n2 > this.end) {
            if (this.ptr + n > this.end) {
                return this.overrun(n, n2, bl);
            }
            n2 = (this.end - this.ptr) / n;
        }
        return n2;
    }

    public int check(int n, int n2) {
        return this.check(n, n2, true);
    }

    public int check(int n) {
        return this.check(n, 1);
    }

    public final boolean checkNoWait(int n) {
        return this.check(n, 1, false) != 0;
    }

    public final int readS8() {
        this.check(1);
        return this.b[this.ptr++];
    }

    public final int readS16() {
        this.check(2);
        byte by = this.b[this.ptr++];
        int n = this.b[this.ptr++] & 0xFF;
        return by << 8 | n;
    }

    public final int readS32() {
        this.check(4);
        byte by = this.b[this.ptr++];
        int n = this.b[this.ptr++] & 0xFF;
        int n2 = this.b[this.ptr++] & 0xFF;
        int n3 = this.b[this.ptr++] & 0xFF;
        return by << 24 | n << 16 | n2 << 8 | n3;
    }

    public final int readU8() {
        return this.readS8() & 0xFF;
    }

    public final int readU16() {
        return this.readS16() & 0xFFFF;
    }

    public final int readU32() {
        return this.readS32() & 0xFFFFFFFF;
    }

    public final String readString() {
        int n = this.readU32();
        if (n > maxStringLength) {
            throw new Exception("InStream max string length exceeded");
        }
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        String string = new String();
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public final void skip(int n) {
        while (n > 0) {
            int n2 = this.check(1, n);
            this.ptr += n2;
            n -= n2;
        }
    }

    public void readBytes(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.mark().position() + n;
        while (byteBuffer.position() < n2) {
            int n3 = this.check(1, n2 - byteBuffer.position());
            byteBuffer.put(this.b, this.ptr, n3);
            this.ptr += n3;
        }
        byteBuffer.reset();
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.check(1, n3 - n);
            System.arraycopy(this.b, this.ptr, byArray, n, n4);
            this.ptr += n4;
            n += n4;
        }
    }

    public final int readOpaque8() {
        return this.readU8();
    }

    public final int readOpaque16() {
        return this.readU16();
    }

    public final int readOpaque32() {
        return this.readU32();
    }

    public final int readOpaque24A() {
        this.check(3);
        byte by = this.b[this.ptr++];
        byte by2 = this.b[this.ptr++];
        byte by3 = this.b[this.ptr++];
        return by << 24 | by2 << 16 | by3 << 8;
    }

    public final int readOpaque24B() {
        this.check(3);
        byte by = this.b[this.ptr++];
        byte by2 = this.b[this.ptr++];
        byte by3 = this.b[this.ptr++];
        return by << 16 | by2 << 8 | by3;
    }

    public final int readPixel(int n, boolean bl) {
        byte[] byArray = new byte[4];
        this.readBytes(byArray, 0, n);
        if (bl) {
            return 0xFF000000 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
        }
        return 0xFF000000 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public final void readPixels(int[] nArray, int n, int n2, boolean bl) {
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        this.readBytes(byArray, 0, n3);
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, i * n2, byArray2, 0, n2);
            nArray[i] = bl ? 0xFF000000 | (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF : 0xFF000000 | (byArray2[2] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[0] & 0xFF;
        }
    }

    public abstract int pos();

    public boolean bytesAvailable() {
        return this.end != this.ptr;
    }

    public final byte[] getbuf() {
        return this.b;
    }

    public final int getptr() {
        return this.ptr;
    }

    public final int getend() {
        return this.end;
    }

    public final void setptr(int n) {
        this.ptr = n;
    }

    protected abstract int overrun(int var1, int var2, boolean var3);

    protected InStream() {
    }
}

