/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.ClipboardDialog;
import com.tigervnc.vncviewer.F8Menu;
import com.tigervnc.vncviewer.JavaPixelBuffer;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.swing.JPanel;

class Viewport
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    static LogWriter vlog = new LogWriter("Viewport");
    static final int[] dotcursor_xpm = new int[]{0, 0, 0, 0, 0, 0, -16777216, -16777216, -16777216, 0, 0, -16777216, -16777216, -16777216, 0, 0, -16777216, -16777216, -16777216, 0, 0, 0, 0, 0, 0};
    private static final Integer keyEventLock = 0;
    private CConn cc;
    private BufferedImage image;
    public PlatformPixelBuffer frameBuffer;
    static Toolkit tk = Toolkit.getDefaultToolkit();
    public int scaledWidth = 0;
    public int scaledHeight = 0;
    float scaleRatioX;
    float scaleRatioY;
    BufferedImage cursor;
    Point cursorHotspot = new Point();

    public Viewport(int n, int n2, PixelFormat pixelFormat, CConn cConn) {
        this.cc = cConn;
        this.setScaledSize(this.cc.cp.width, this.cc.cp.height);
        this.frameBuffer = this.createFramebuffer(pixelFormat, n, n2);
        assert (this.frameBuffer != null);
        this.setBackground(Color.BLACK);
        this.cc.setFramebuffer(this.frameBuffer);
        OptionsDialog.addCallback("handleOptions", this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ClipboardDialog.clientCutText();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Viewport.this.cc.releaseDownKeys();
            }
        });
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusable(true);
        this.cc.writer().writePointerEvent(new Point(n / 2, n2 / 2), 0);
    }

    public PixelFormat getPreferredPF() {
        return this.frameBuffer.getPF();
    }

    public void updateWindow() {
        Rect rect = this.frameBuffer.getDamage();
        if (!rect.is_empty()) {
            if (this.image == null) {
                this.image = (BufferedImage)this.frameBuffer.getImage();
            }
            if (this.cc.cp.width != this.scaledWidth || this.cc.cp.height != this.scaledHeight) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(this.scaleRatioX, this.scaleRatioY);
                Rectangle rectangle = new Rectangle(rect.tl.x, rect.tl.y, rect.width(), rect.height());
                rectangle = affineTransform.createTransformedShape(rectangle).getBounds();
                this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                this.paintImmediately(rect.tl.x, rect.tl.y, rect.width(), rect.height());
            }
        }
    }

    public void setCursor(int n, int n2, Point point, byte[] byArray) {
        Cursor cursor;
        int n3;
        for (n3 = 0; n3 < n * n2 && byArray[n3 * 4 + 3] == 0; ++n3) {
        }
        if (n3 == n * n2 && Parameters.dotWhenNoCursor.getValue()) {
            vlog.debug("cursor is empty - using dot");
            this.cursor = new BufferedImage(5, 5, 3);
            this.cursor.setRGB(0, 0, 5, 5, dotcursor_xpm, 0, 5);
            this.cursorHotspot.y = 3;
            this.cursorHotspot.x = 3;
        } else if (n == 0 || n2 == 0) {
            this.cursor = new BufferedImage(Viewport.tk.getBestCursorSize((int)0, (int)0).width, Viewport.tk.getBestCursorSize((int)0, (int)0).height, 3);
            this.cursorHotspot.y = 0;
            this.cursorHotspot.x = 0;
        } else {
            IntBuffer intBuffer = IntBuffer.allocate(n * n2);
            intBuffer.put(ByteBuffer.wrap(byArray).asIntBuffer());
            this.cursor = new BufferedImage(n, n2, 3);
            this.cursor.setRGB(0, 0, n, n2, intBuffer.array(), 0, n);
            this.cursorHotspot = point;
        }
        int n4 = (int)Math.floor((float)this.cursor.getWidth() * this.scaleRatioX);
        int n5 = (int)Math.floor((float)this.cursor.getHeight() * this.scaleRatioY);
        int n6 = (int)Math.floor((float)this.cursorHotspot.x * this.scaleRatioX);
        int n7 = (int)Math.floor((float)this.cursorHotspot.y * this.scaleRatioY);
        Dimension dimension = tk.getBestCursorSize(n4, n5);
        if (dimension.width != n4 && dimension.height != n5) {
            n4 = Math.min(n4, dimension.width);
            n5 = Math.min(n5, dimension.height);
            n6 = Math.min(n6, Math.max(dimension.width - 1, 0));
            n7 = Math.min(n7, Math.max(dimension.height - 1, 0));
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.drawImage(this.cursor, 0, 0, n4, n5, 0, 0, this.cursor.getWidth(), this.cursor.getHeight(), null);
            graphics2D.dispose();
            java.awt.Point point2 = new java.awt.Point(n6, n7);
            cursor = tk.createCustomCursor(bufferedImage, point2, "softCursor");
            bufferedImage.flush();
        } else {
            java.awt.Point point3 = new java.awt.Point(n6, n7);
            cursor = tk.createCustomCursor(this.cursor, point3, "softCursor");
        }
        this.cursor.flush();
        this.setCursor(cursor);
    }

    public void resize(int n, int n2, int n3, int n4) {
        if (n3 != this.frameBuffer.width() || n4 != this.frameBuffer.height()) {
            vlog.debug("Resizing framebuffer from " + this.frameBuffer.width() + "x" + this.frameBuffer.height() + " to " + n3 + "x" + n4);
            this.frameBuffer = this.createFramebuffer(this.frameBuffer.getPF(), n3, n4);
            assert (this.frameBuffer != null);
            this.cc.setFramebuffer(this.frameBuffer);
            this.image = (BufferedImage)this.frameBuffer.getImage();
        }
        this.setScaledSize(n3, n4);
    }

    private PlatformPixelBuffer createFramebuffer(PixelFormat pixelFormat, int n, int n2) {
        JavaPixelBuffer javaPixelBuffer = new JavaPixelBuffer(n, n2);
        return javaPixelBuffer;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.cc.cp.width != this.scaledWidth || this.cc.cp.height != this.scaledHeight) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.drawImage(this.image, 0, 0, this.scaledWidth, this.scaledHeight, null);
        } else {
            graphics2D.drawImage((Image)this.image, 0, 0, null);
        }
        graphics2D.dispose();
    }

    private void mouseMotionCB(MouseEvent mouseEvent) {
        if (!Parameters.viewOnly.getValue() && mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.scaledWidth && mouseEvent.getY() >= 0 && mouseEvent.getY() <= this.scaledHeight) {
            this.cc.writePointerEvent(this.translateMouseEvent(mouseEvent));
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMotionCB(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMotionCB(mouseEvent);
    }

    private void mouseCB(MouseEvent mouseEvent) {
        if (!Parameters.viewOnly.getValue() && (mouseEvent.getID() == 502 || mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.scaledWidth && mouseEvent.getY() >= 0 && mouseEvent.getY() <= this.scaledHeight)) {
            this.cc.writePointerEvent(this.translateMouseEvent(mouseEvent));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseCB(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseCB(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (Parameters.embed.getValue()) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void mouseWheelCB(MouseWheelEvent mouseWheelEvent) {
        if (!Parameters.viewOnly.getValue()) {
            this.cc.writeWheelEvent(mouseWheelEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseWheelCB(mouseWheelEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Integer n = keyEventLock;
        synchronized (n) {
            this.cc.writeKeyEvent(keyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == MenuKey.getMenuKeyCode()) {
            java.awt.Point point = keyEvent.getComponent().getMousePosition();
            if (point != null) {
                F8Menu f8Menu = new F8Menu(this.cc);
                f8Menu.show(keyEvent.getComponent(), (int)point.getX(), (int)point.getY());
            }
            return;
        }
        int n = 11;
        if ((keyEvent.getModifiers() & n) == n) {
            switch (keyEvent.getKeyCode()) {
                case 65: {
                    VncViewer.showAbout(this);
                    return;
                }
                case 70: {
                    if (this.cc.desktop.fullscreen_active()) {
                        this.cc.desktop.fullscreen_on();
                    } else {
                        this.cc.desktop.fullscreen_off();
                    }
                    return;
                }
                case 72: {
                    this.cc.refresh();
                    return;
                }
                case 73: {
                    this.cc.showInfo();
                    return;
                }
                case 79: {
                    OptionsDialog.showDialog(this);
                    return;
                }
                case 87: {
                    VncViewer.newViewer();
                    return;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    return;
                }
            }
        }
        if ((keyEvent.getModifiers() & 4) == 4) {
            switch (keyEvent.getKeyCode()) {
                case 44: 
                case 70: 
                case 73: 
                case 76: 
                case 78: 
                case 82: 
                case 84: 
                case 87: 
                case 90: {
                    return;
                }
            }
        }
        Integer n2 = keyEventLock;
        synchronized (n2) {
            this.cc.writeKeyEvent(keyEvent);
        }
    }

    public void setScaledSize(int n, int n2) {
        assert (n != 0 && n2 != 0);
        String string = Parameters.scalingFactor.getValue();
        if (Parameters.remoteResize.getValue()) {
            this.scaledWidth = n;
            this.scaledHeight = n2;
            this.scaleRatioX = 1.0f;
            this.scaleRatioY = 1.0f;
        } else {
            if (string.matches("^[0-9]+$")) {
                int n3 = Integer.parseInt(string);
                this.scaledWidth = (int)Math.floor((double)((float)n * (float)n3) / 100.0);
                this.scaledHeight = (int)Math.floor((double)((float)n2 * (float)n3) / 100.0);
            } else if (string.equalsIgnoreCase("Auto")) {
                this.scaledWidth = n;
                this.scaledHeight = n2;
            } else {
                float f = (float)n / (float)this.cc.cp.width;
                float f2 = (float)n2 / (float)this.cc.cp.height;
                float f3 = Math.min(f, f2);
                this.scaledWidth = (int)Math.floor((float)this.cc.cp.width * f3);
                this.scaledHeight = (int)Math.floor((float)this.cc.cp.height * f3);
            }
            this.scaleRatioX = (float)this.scaledWidth / (float)this.cc.cp.width;
            this.scaleRatioY = (float)this.scaledHeight / (float)this.cc.cp.height;
        }
        if (this.scaledWidth != this.getWidth() || this.scaledHeight != this.getHeight()) {
            this.setSize(new Dimension(this.scaledWidth, this.scaledHeight));
        }
    }

    private MouseEvent translateMouseEvent(MouseEvent mouseEvent) {
        if (this.cc.cp.width != this.scaledWidth || this.cc.cp.height != this.scaledHeight) {
            int n = (double)this.scaleRatioX == 1.0 ? mouseEvent.getX() : (int)Math.floor((float)mouseEvent.getX() / this.scaleRatioX);
            int n2 = (double)this.scaleRatioY == 1.0 ? mouseEvent.getY() : (int)Math.floor((float)mouseEvent.getY() / this.scaleRatioY);
            mouseEvent.translatePoint(n - mouseEvent.getX(), n2 - mouseEvent.getY());
        }
        return mouseEvent;
    }

    public void handleOptions() {
    }
}

