/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBox;

import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.SliceChecksumDictHelper;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice.UserException;
import com.zeroc.IceBox.AlreadyStartedException;
import com.zeroc.IceBox.AlreadyStoppedException;
import com.zeroc.IceBox.NoSuchServiceException;
import com.zeroc.IceBox.ServiceObserverPrx;
import com.zeroc.IceBox._ServiceManagerPrxI;
import com.zeroc.IceInternal.OutgoingAsync;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface ServiceManagerPrx
extends ObjectPrx {
    public static final Class<?>[] _iceE_startService = new Class[]{AlreadyStartedException.class, NoSuchServiceException.class};
    public static final Class<?>[] _iceE_stopService = new Class[]{AlreadyStoppedException.class, NoSuchServiceException.class};

    default public Map<String, String> getSliceChecksums() {
        return this.getSliceChecksums(ObjectPrx.noExplicitContext);
    }

    default public Map<String, String> getSliceChecksums(Map<String, String> context) {
        return this._iceI_getSliceChecksumsAsync(context, true).waitForResponse();
    }

    default public CompletableFuture<Map<String, String>> getSliceChecksumsAsync() {
        return this._iceI_getSliceChecksumsAsync(ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Map<String, String>> getSliceChecksumsAsync(Map<String, String> context) {
        return this._iceI_getSliceChecksumsAsync(context, false);
    }

    default public OutgoingAsync<Map<String, String>> _iceI_getSliceChecksumsAsync(Map<String, String> context, boolean sync) {
        OutgoingAsync<Map<String, String>> f = new OutgoingAsync<Map<String, String>>(this, "getSliceChecksums", OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
            Map<String, String> ret = SliceChecksumDictHelper.read(istr);
            return ret;
        });
        return f;
    }

    default public void startService(String service) throws AlreadyStartedException, NoSuchServiceException {
        this.startService(service, ObjectPrx.noExplicitContext);
    }

    default public void startService(String service, Map<String, String> context) throws AlreadyStartedException, NoSuchServiceException {
        try {
            this._iceI_startServiceAsync(service, context, true).waitForResponseOrUserEx();
        }
        catch (AlreadyStartedException ex) {
            throw ex;
        }
        catch (NoSuchServiceException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    default public CompletableFuture<Void> startServiceAsync(String service) {
        return this._iceI_startServiceAsync(service, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> startServiceAsync(String service, Map<String, String> context) {
        return this._iceI_startServiceAsync(service, context, false);
    }

    default public OutgoingAsync<Void> _iceI_startServiceAsync(String iceP_service, Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "startService", null, sync, _iceE_startService);
        f.invoke(true, context, null, ostr -> ostr.writeString(iceP_service), null);
        return f;
    }

    default public void stopService(String service) throws AlreadyStoppedException, NoSuchServiceException {
        this.stopService(service, ObjectPrx.noExplicitContext);
    }

    default public void stopService(String service, Map<String, String> context) throws AlreadyStoppedException, NoSuchServiceException {
        try {
            this._iceI_stopServiceAsync(service, context, true).waitForResponseOrUserEx();
        }
        catch (AlreadyStoppedException ex) {
            throw ex;
        }
        catch (NoSuchServiceException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    default public CompletableFuture<Void> stopServiceAsync(String service) {
        return this._iceI_stopServiceAsync(service, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> stopServiceAsync(String service, Map<String, String> context) {
        return this._iceI_stopServiceAsync(service, context, false);
    }

    default public OutgoingAsync<Void> _iceI_stopServiceAsync(String iceP_service, Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "stopService", null, sync, _iceE_stopService);
        f.invoke(true, context, null, ostr -> ostr.writeString(iceP_service), null);
        return f;
    }

    default public void addObserver(ServiceObserverPrx observer) {
        this.addObserver(observer, ObjectPrx.noExplicitContext);
    }

    default public void addObserver(ServiceObserverPrx observer, Map<String, String> context) {
        this._iceI_addObserverAsync(observer, context, true).waitForResponse();
    }

    default public CompletableFuture<Void> addObserverAsync(ServiceObserverPrx observer) {
        return this._iceI_addObserverAsync(observer, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> addObserverAsync(ServiceObserverPrx observer, Map<String, String> context) {
        return this._iceI_addObserverAsync(observer, context, false);
    }

    default public OutgoingAsync<Void> _iceI_addObserverAsync(ServiceObserverPrx iceP_observer, Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "addObserver", null, sync, null);
        f.invoke(false, context, null, ostr -> ostr.writeProxy(iceP_observer), null);
        return f;
    }

    default public void shutdown() {
        this.shutdown(ObjectPrx.noExplicitContext);
    }

    default public void shutdown(Map<String, String> context) {
        this._iceI_shutdownAsync(context, true).waitForResponse();
    }

    default public CompletableFuture<Void> shutdownAsync() {
        return this._iceI_shutdownAsync(ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> shutdownAsync(Map<String, String> context) {
        return this._iceI_shutdownAsync(context, false);
    }

    default public OutgoingAsync<Void> _iceI_shutdownAsync(Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "shutdown", null, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    public static ServiceManagerPrx checkedCast(ObjectPrx obj) {
        return ObjectPrx._checkedCast(obj, ServiceManagerPrx.ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    public static ServiceManagerPrx checkedCast(ObjectPrx obj, Map<String, String> context) {
        return ObjectPrx._checkedCast(obj, context, ServiceManagerPrx.ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    public static ServiceManagerPrx checkedCast(ObjectPrx obj, String facet) {
        return ObjectPrx._checkedCast(obj, facet, ServiceManagerPrx.ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    public static ServiceManagerPrx checkedCast(ObjectPrx obj, String facet, Map<String, String> context) {
        return ObjectPrx._checkedCast(obj, facet, context, ServiceManagerPrx.ice_staticId(), ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    public static ServiceManagerPrx uncheckedCast(ObjectPrx obj) {
        return ObjectPrx._uncheckedCast(obj, ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    public static ServiceManagerPrx uncheckedCast(ObjectPrx obj, String facet) {
        return ObjectPrx._uncheckedCast(obj, facet, ServiceManagerPrx.class, _ServiceManagerPrxI.class);
    }

    @Override
    default public ServiceManagerPrx ice_context(Map<String, String> newContext) {
        return (ServiceManagerPrx)this._ice_context(newContext);
    }

    @Override
    default public ServiceManagerPrx ice_adapterId(String newAdapterId) {
        return (ServiceManagerPrx)this._ice_adapterId(newAdapterId);
    }

    @Override
    default public ServiceManagerPrx ice_endpoints(Endpoint[] newEndpoints) {
        return (ServiceManagerPrx)this._ice_endpoints(newEndpoints);
    }

    @Override
    default public ServiceManagerPrx ice_locatorCacheTimeout(int newTimeout) {
        return (ServiceManagerPrx)this._ice_locatorCacheTimeout(newTimeout);
    }

    @Override
    default public ServiceManagerPrx ice_invocationTimeout(int newTimeout) {
        return (ServiceManagerPrx)this._ice_invocationTimeout(newTimeout);
    }

    @Override
    default public ServiceManagerPrx ice_connectionCached(boolean newCache) {
        return (ServiceManagerPrx)this._ice_connectionCached(newCache);
    }

    @Override
    default public ServiceManagerPrx ice_endpointSelection(EndpointSelectionType newType) {
        return (ServiceManagerPrx)this._ice_endpointSelection(newType);
    }

    @Override
    default public ServiceManagerPrx ice_secure(boolean b) {
        return (ServiceManagerPrx)this._ice_secure(b);
    }

    @Override
    default public ServiceManagerPrx ice_encodingVersion(EncodingVersion e) {
        return (ServiceManagerPrx)this._ice_encodingVersion(e);
    }

    @Override
    default public ServiceManagerPrx ice_preferSecure(boolean b) {
        return (ServiceManagerPrx)this._ice_preferSecure(b);
    }

    @Override
    default public ServiceManagerPrx ice_router(RouterPrx router) {
        return (ServiceManagerPrx)this._ice_router(router);
    }

    @Override
    default public ServiceManagerPrx ice_locator(LocatorPrx locator) {
        return (ServiceManagerPrx)this._ice_locator(locator);
    }

    @Override
    default public ServiceManagerPrx ice_collocationOptimized(boolean b) {
        return (ServiceManagerPrx)this._ice_collocationOptimized(b);
    }

    @Override
    default public ServiceManagerPrx ice_twoway() {
        return (ServiceManagerPrx)this._ice_twoway();
    }

    @Override
    default public ServiceManagerPrx ice_oneway() {
        return (ServiceManagerPrx)this._ice_oneway();
    }

    @Override
    default public ServiceManagerPrx ice_batchOneway() {
        return (ServiceManagerPrx)this._ice_batchOneway();
    }

    @Override
    default public ServiceManagerPrx ice_datagram() {
        return (ServiceManagerPrx)this._ice_datagram();
    }

    @Override
    default public ServiceManagerPrx ice_batchDatagram() {
        return (ServiceManagerPrx)this._ice_batchDatagram();
    }

    @Override
    default public ServiceManagerPrx ice_compress(boolean co) {
        return (ServiceManagerPrx)this._ice_compress(co);
    }

    @Override
    default public ServiceManagerPrx ice_timeout(int t) {
        return (ServiceManagerPrx)this._ice_timeout(t);
    }

    @Override
    default public ServiceManagerPrx ice_connectionId(String connectionId) {
        return (ServiceManagerPrx)this._ice_connectionId(connectionId);
    }

    public static String ice_staticId() {
        return "::IceBox::ServiceManager";
    }
}

