/*
 * Decompiled with CFR 0.152.
 */
package IceLocatorDiscovery;

import Ice.AMD_Locator_findAdapterById;
import Ice.AMD_Locator_findObjectById;
import Ice.AMD_Object_ice_invoke;
import Ice.AsyncResult;
import Ice.BlobjectAsync;
import Ice.Callback;
import Ice.Callback_Object_ice_invoke;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.Current;
import Ice.Endpoint;
import Ice.EndpointInfo;
import Ice.IPEndpointInfo;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.LocatorRegistryPrx;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import Ice.OperationMode;
import Ice.Properties;
import Ice.RequestFailedException;
import Ice.UDPEndpointInfo;
import Ice.UnknownException;
import Ice._LocatorDisp;
import IceInternal.Network;
import IceInternal.Time;
import IceInternal.Util;
import IceLocatorDiscovery.LookupPrx;
import IceLocatorDiscovery.LookupPrxHelper;
import IceLocatorDiscovery.LookupReplyPrx;
import IceLocatorDiscovery.LookupReplyPrxHelper;
import IceLocatorDiscovery.Plugin;
import IceLocatorDiscovery._LookupReplyDisp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class PluginI
implements Plugin {
    private String _name;
    private Communicator _communicator;
    private ObjectAdapter _locatorAdapter;
    private ObjectAdapter _replyAdapter;
    private LocatorI _locator;
    private LocatorPrx _locatorPrx;
    private LocatorPrx _defaultLocator;

    public PluginI(String name, Communicator communicator) {
        this._name = name;
        this._communicator = communicator;
    }

    @Override
    public void initialize() {
        Properties properties = this._communicator.getProperties();
        boolean ipv4 = properties.getPropertyAsIntWithDefault("Ice.IPv4", 1) > 0;
        boolean preferIPv6 = properties.getPropertyAsInt("Ice.PreferIPv6Address") > 0;
        String address = ipv4 && !preferIPv6 ? properties.getPropertyWithDefault(this._name + ".Address", "239.255.0.1") : properties.getPropertyWithDefault(this._name + ".Address", "ff15::1");
        int port = properties.getPropertyAsIntWithDefault(this._name + ".Port", 4061);
        String intf = properties.getProperty(this._name + ".Interface");
        String lookupEndpoints = properties.getProperty(this._name + ".Lookup");
        if (lookupEndpoints.isEmpty()) {
            int protocol = ipv4 && !preferIPv6 ? 0 : 1;
            List<String> interfaces = Network.getInterfacesForMulticast(intf, protocol);
            for (String p : interfaces) {
                if (p != interfaces.get(0)) {
                    lookupEndpoints = lookupEndpoints + ":";
                }
                lookupEndpoints = lookupEndpoints + "udp -h \"" + address + "\" -p " + port + " --interface \"" + p + "\"";
            }
        }
        if (properties.getProperty(this._name + ".Reply.Endpoints").isEmpty()) {
            properties.setProperty(this._name + ".Reply.Endpoints", "udp -h " + (intf.isEmpty() ? "*" : "\"" + intf + "\""));
        }
        if (properties.getProperty(this._name + ".Locator.Endpoints").isEmpty()) {
            properties.setProperty(this._name + ".Locator.AdapterId", UUID.randomUUID().toString());
        }
        this._replyAdapter = this._communicator.createObjectAdapter(this._name + ".Reply");
        this._locatorAdapter = this._communicator.createObjectAdapter(this._name + ".Locator");
        this._replyAdapter.setLocator(null);
        this._locatorAdapter.setLocator(null);
        ObjectPrx lookupPrx = this._communicator.stringToProxy("IceLocatorDiscovery/Lookup -d:" + lookupEndpoints);
        lookupPrx = lookupPrx.ice_collocationOptimized(false).ice_router(null);
        LocatorPrx voidLoc = LocatorPrxHelper.uncheckedCast(this._locatorAdapter.addWithUUID(new VoidLocatorI()));
        String instanceName = properties.getProperty(this._name + ".InstanceName");
        Identity id = new Identity();
        id.name = "Locator";
        id.category = !instanceName.isEmpty() ? instanceName : UUID.randomUUID().toString();
        this._locator = new LocatorI(this._name, LookupPrxHelper.uncheckedCast(lookupPrx), properties, instanceName, voidLoc);
        this._defaultLocator = this._communicator.getDefaultLocator();
        this._locatorPrx = LocatorPrxHelper.uncheckedCast(this._locatorAdapter.addWithUUID(this._locator));
        this._communicator.setDefaultLocator(this._locatorPrx);
        ObjectPrx lookupReply = this._replyAdapter.addWithUUID(new LookupReplyI(this._locator)).ice_datagram();
        this._locator.setLookupReply(LookupReplyPrxHelper.uncheckedCast(lookupReply));
        this._replyAdapter.activate();
        this._locatorAdapter.activate();
    }

    @Override
    public void destroy() {
        if (this._replyAdapter != null) {
            this._replyAdapter.destroy();
        }
        if (this._locatorAdapter != null) {
            this._locatorAdapter.destroy();
        }
        if (this._communicator.getDefaultLocator().equals(this._locatorPrx)) {
            this._communicator.setDefaultLocator(this._defaultLocator);
        }
    }

    @Override
    public List<LocatorPrx> getLocators(String instanceName, int waitTime) {
        return this._locator.getLocators(instanceName, waitTime);
    }

    private class LookupReplyI
    extends _LookupReplyDisp {
        private final LocatorI _locator;

        LookupReplyI(LocatorI locator) {
            this._locator = locator;
        }

        @Override
        public void foundLocator(LocatorPrx locator, Current curr) {
            this._locator.foundLocator(locator);
        }
    }

    private static class LocatorI
    extends BlobjectAsync {
        private Runnable _retryTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocatorI locatorI = LocatorI.this;
                synchronized (locatorI) {
                    if (--LocatorI.this._pendingRetryCount > 0) {
                        try {
                            LocatorI.this._failureCount = 0;
                            for (Map.Entry entry : LocatorI.this._lookups.entrySet()) {
                                ((LookupPrx)entry.getKey()).begin_findLocator(LocatorI.this._instanceName, (LookupReplyPrx)entry.getValue(), new Callback(){

                                    @Override
                                    public void completed(AsyncResult r) {
                                        try {
                                            r.throwLocalException();
                                        }
                                        catch (LocalException ex) {
                                            LocatorI.this.exception(ex);
                                        }
                                    }
                                });
                            }
                            LocatorI.this._future = LocatorI.this._timer.schedule(LocatorI.this._retryTask, (long)LocatorI.this._timeout, TimeUnit.MILLISECONDS);
                            return;
                        }
                        catch (LocalException localException) {
                            LocatorI.this._pendingRetryCount = 0;
                        }
                    }
                    if (LocatorI.this._pendingRequests.isEmpty()) {
                        this.notify();
                    } else {
                        for (Request req : LocatorI.this._pendingRequests) {
                            req.invoke(LocatorI.this._voidLocator);
                        }
                        LocatorI.this._pendingRequests.clear();
                    }
                    LocatorI.this._nextRetry = Time.currentMonotonicTimeMillis() + (long)LocatorI.this._retryDelay;
                }
            }
        };
        private final LookupPrx _lookup;
        private final Map<LookupPrx, LookupReplyPrx> _lookups = new HashMap<LookupPrx, LookupReplyPrx>();
        private final int _timeout;
        private Future<?> _future;
        private final ScheduledExecutorService _timer;
        private final int _retryCount;
        private final int _retryDelay;
        private String _instanceName;
        private boolean _warned;
        private LocatorPrx _locator;
        private LocatorPrx _voidLocator;
        private Map<String, LocatorPrx> _locators = new HashMap<String, LocatorPrx>();
        private int _pendingRetryCount;
        private int _failureCount;
        private boolean _warnOnce;
        private List<Request> _pendingRequests = new ArrayList<Request>();
        private long _nextRetry;

        LocatorI(String name, LookupPrx lookup, Properties properties, String instanceName, LocatorPrx voidLocator) {
            this._lookup = lookup;
            this._timeout = properties.getPropertyAsIntWithDefault(name + ".Timeout", 300);
            this._retryCount = properties.getPropertyAsIntWithDefault(name + ".RetryCount", 3);
            this._retryDelay = properties.getPropertyAsIntWithDefault(name + ".RetryDelay", 2000);
            this._timer = Util.getInstance(lookup.ice_getCommunicator()).timer();
            this._instanceName = instanceName;
            this._warned = false;
            this._locator = lookup.ice_getCommunicator().getDefaultLocator();
            this._voidLocator = voidLocator;
            this._pendingRetryCount = 0;
            this._failureCount = 0;
            this._warnOnce = true;
            Endpoint[] single = new Endpoint[1];
            Endpoint[] endpointArray = lookup.ice_getEndpoints();
            int n = endpointArray.length;
            for (int i = 0; i < n; ++i) {
                Endpoint endpt;
                single[0] = endpt = endpointArray[i];
                this._lookups.put((LookupPrx)lookup.ice_endpoints(single), null);
            }
            assert (!this._lookups.isEmpty());
        }

        public void setLookupReply(LookupReplyPrx lookupReply) {
            Endpoint[] single = new Endpoint[1];
            for (Map.Entry<LookupPrx, LookupReplyPrx> entry : this._lookups.entrySet()) {
                UDPEndpointInfo info = (UDPEndpointInfo)entry.getKey().ice_getEndpoints()[0].getInfo();
                if (!info.mcastInterface.isEmpty()) {
                    for (Endpoint q : lookupReply.ice_getEndpoints()) {
                        EndpointInfo r = q.getInfo();
                        if (!(r instanceof IPEndpointInfo) || !((IPEndpointInfo)r).host.equals(info.mcastInterface)) continue;
                        single[0] = q;
                        entry.setValue((LookupReplyPrx)lookupReply.ice_endpoints(single));
                    }
                }
                if (entry.getValue() != null) continue;
                entry.setValue(lookupReply);
            }
        }

        @Override
        public synchronized void ice_invoke_async(AMD_Object_ice_invoke amdCB, byte[] inParams, Current current) {
            this.invoke(null, new Request(this, current.operation, current.mode, inParams, current.ctx, amdCB));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<LocatorPrx> getLocators(String instanceName, int waitTime) {
            LocatorI locatorI;
            block13: {
                locatorI = this;
                synchronized (locatorI) {
                    this._locators.clear();
                }
                this.invoke(null, null);
                try {
                    if (instanceName.isEmpty()) {
                        Thread.sleep(waitTime);
                        break block13;
                    }
                    locatorI = this;
                    synchronized (locatorI) {
                        while (!this._locators.containsKey(instanceName) && this._pendingRetryCount > 0) {
                            this.wait(waitTime);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
            locatorI = this;
            synchronized (locatorI) {
                return new ArrayList<LocatorPrx>(this._locators.values());
            }
        }

        public synchronized void foundLocator(LocatorPrx locator) {
            LocatorPrx l;
            if (locator == null || !this._instanceName.isEmpty() && !locator.ice_getIdentity().category.equals(this._instanceName)) {
                return;
            }
            if (!this._pendingRequests.isEmpty() && this._locator != null && !locator.ice_getIdentity().category.equals(this._locator.ice_getIdentity().category)) {
                if (!this._warned) {
                    this._warned = true;
                    locator.ice_getCommunicator().getLogger().warning("received Ice locator with different instance name:\nusing = `" + this._locator.ice_getIdentity().category + "'\nreceived = `" + locator.ice_getIdentity().category + "'\nThis is typically the case if multiple Ice locators with different instance names are deployed and the property `IceLocatorDiscovery.InstanceName'is not set.");
                }
                return;
            }
            if (this._pendingRetryCount > 0) {
                this._future.cancel(false);
                this._future = null;
                this._pendingRetryCount = 0;
            }
            LocatorPrx locatorPrx = l = this._pendingRequests.isEmpty() ? this._locators.get(locator.ice_getIdentity().category) : this._locator;
            if (l != null) {
                ArrayList<Endpoint> newEndpoints = new ArrayList<Endpoint>(Arrays.asList(l.ice_getEndpoints()));
                for (Endpoint p : locator.ice_getEndpoints()) {
                    boolean found = false;
                    for (Endpoint q : newEndpoints) {
                        if (!p.equals(q)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newEndpoints.add(p);
                }
                l = (LocatorPrx)l.ice_endpoints(newEndpoints.toArray(new Endpoint[newEndpoints.size()]));
            } else {
                l = locator;
            }
            if (this._pendingRequests.isEmpty()) {
                this._locators.put(locator.ice_getIdentity().category, l);
                this.notify();
            } else {
                this._locator = l;
                if (this._instanceName.isEmpty()) {
                    this._instanceName = this._locator.ice_getIdentity().category;
                }
                for (Request req : this._pendingRequests) {
                    req.invoke(this._locator);
                }
                this._pendingRequests.clear();
            }
        }

        public synchronized void invoke(LocatorPrx locator, Request request) {
            if (request != null && this._locator != null && this._locator != locator) {
                request.invoke(this._locator);
            } else if (request != null && Time.currentMonotonicTimeMillis() < this._nextRetry) {
                request.invoke(this._voidLocator);
            } else {
                this._locator = null;
                if (request != null) {
                    this._pendingRequests.add(request);
                }
                if (this._pendingRetryCount == 0) {
                    this._pendingRetryCount = this._retryCount;
                    this._failureCount = 0;
                    try {
                        for (Map.Entry<LookupPrx, LookupReplyPrx> entry : this._lookups.entrySet()) {
                            entry.getKey().begin_findLocator(this._instanceName, entry.getValue(), new Callback(){

                                @Override
                                public void completed(AsyncResult r) {
                                    try {
                                        r.throwLocalException();
                                    }
                                    catch (LocalException ex) {
                                        LocatorI.this.exception(ex);
                                    }
                                }
                            });
                        }
                        this._future = this._timer.schedule(this._retryTask, (long)this._timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (LocalException ex) {
                        for (Request req : this._pendingRequests) {
                            req.invoke(this._voidLocator);
                        }
                        this._pendingRequests.clear();
                        this._pendingRetryCount = 0;
                    }
                }
            }
        }

        synchronized void exception(LocalException ex) {
            if (++this._failureCount == this._lookups.size() && this._pendingRetryCount > 0) {
                this._future.cancel(false);
                this._future = null;
                this._pendingRetryCount = 0;
                if (this._warnOnce) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("failed to lookup locator with lookup proxy `");
                    builder.append(this._lookup);
                    builder.append("':\n");
                    builder.append(ex);
                    this._lookup.ice_getCommunicator().getLogger().warning(builder.toString());
                    this._warnOnce = false;
                }
                if (this._pendingRequests.isEmpty()) {
                    this.notify();
                } else {
                    for (Request req : this._pendingRequests) {
                        req.invoke(this._voidLocator);
                    }
                    this._pendingRequests.clear();
                }
            }
        }
    }

    private static class VoidLocatorI
    extends _LocatorDisp {
        private VoidLocatorI() {
        }

        @Override
        public void findObjectById_async(AMD_Locator_findObjectById amdCB, Identity id, Current current) {
            amdCB.ice_response(null);
        }

        @Override
        public void findAdapterById_async(AMD_Locator_findAdapterById amdCB, String id, Current current) {
            amdCB.ice_response(null);
        }

        @Override
        public LocatorRegistryPrx getRegistry(Current current) {
            return null;
        }
    }

    private static class Request {
        private final LocatorI _locator;
        private final String _operation;
        private final OperationMode _mode;
        private final Map<String, String> _context;
        private final byte[] _inParams;
        private final AMD_Object_ice_invoke _amdCB;
        private LocatorPrx _locatorPrx = null;
        private LocalException _exception = null;

        Request(LocatorI locator, String operation, OperationMode mode, byte[] inParams, Map<String, String> context, AMD_Object_ice_invoke amdCB) {
            this._locator = locator;
            this._operation = operation;
            this._mode = mode;
            this._inParams = inParams;
            this._context = context;
            this._amdCB = amdCB;
        }

        void invoke(LocatorPrx l) {
            if (this._locatorPrx == null || !this._locatorPrx.equals(l)) {
                this._locatorPrx = l;
                try {
                    l.begin_ice_invoke(this._operation, this._mode, this._inParams, this._context, new Callback_Object_ice_invoke(){

                        @Override
                        public void response(boolean ok, byte[] outParams) {
                            Request.this._amdCB.ice_response(ok, outParams);
                        }

                        @Override
                        public void exception(LocalException ex) {
                            Request.this.exception(ex);
                        }
                    });
                }
                catch (LocalException ex) {
                    this.exception(ex);
                }
            } else {
                assert (this._exception != null);
                this._amdCB.ice_exception(this._exception);
            }
        }

        private void exception(LocalException ex) {
            try {
                throw ex;
            }
            catch (RequestFailedException exc) {
                this._amdCB.ice_exception(ex);
            }
            catch (UnknownException exc) {
                this._amdCB.ice_exception(ex);
            }
            catch (NoEndpointException exc) {
                this._amdCB.ice_exception(new ObjectNotExistException());
            }
            catch (ObjectAdapterDeactivatedException exc) {
                this._amdCB.ice_exception(new ObjectNotExistException());
            }
            catch (CommunicatorDestroyedException exc) {
                this._amdCB.ice_exception(new ObjectNotExistException());
            }
            catch (LocalException exc) {
                this._exception = exc;
                this._locator.invoke(this._locatorPrx, this);
            }
        }
    }
}

