/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.IceGridGUI.Coordinator;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeNodeBase
implements TreeCellRenderer,
TreeNode {
    protected TreeNodeBase _parent;
    protected String _id;
    protected Comparator<TreeNodeBase> _childComparator = new Comparator<TreeNodeBase>(){

        @Override
        public int compare(TreeNodeBase o1, TreeNodeBase o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };

    public Coordinator getCoordinator() {
        return this._parent.getCoordinator();
    }

    public Enumeration<Object> children() {
        return new Enumeration<Object>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode node) {
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return null;
    }

    public String toString() {
        return this._id;
    }

    public JPopupMenu getPopupMenu() {
        return null;
    }

    public String getId() {
        return this._id;
    }

    public TreePath getPath() {
        if (this._parent == null) {
            return new TreePath(this);
        }
        return this._parent.getPath().pathByAddingChild(this);
    }

    public LinkedList<String> getFullId() {
        LinkedList<Object> result = this._parent == null ? new LinkedList() : this._parent.getFullId();
        result.add(this._id);
        return result;
    }

    public TreeNodeBase findChild(String id) {
        Enumeration<Object> p = this.children();
        while (p.hasMoreElements()) {
            TreeNodeBase child = (TreeNodeBase)p.nextElement();
            if (!child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    protected String makeNewChildId(String base) {
        String id = base;
        int i = 0;
        while (this.findChild(id) != null) {
            id = base + "-" + ++i;
        }
        return id;
    }

    protected TreeNodeBase(TreeNodeBase parent, String id) {
        this._parent = parent;
        this._id = id;
    }

    protected boolean insertSortedChild(TreeNodeBase newChild, List c, DefaultTreeModel treeModel) {
        int i;
        List children = c;
        String id = newChild.getId();
        for (i = 0; i < children.size(); ++i) {
            String otherId = ((TreeNodeBase)children.get(i)).getId();
            int cmp = id.compareTo(otherId);
            if (cmp == 0) {
                return false;
            }
            if (cmp < 0) break;
        }
        children.add(i, newChild);
        if (treeModel != null) {
            treeModel.nodesWereInserted(this, new int[]{this.getIndex(newChild)});
        }
        return true;
    }

    protected String insertSortedChildren(List nc, List ic, DefaultTreeModel treeModel) {
        List newChildren = nc;
        List intoChildren = ic;
        TreeNodeBase[] children = newChildren.toArray(new TreeNodeBase[0]);
        Arrays.sort(children, this._childComparator);
        int[] indices = new int[children.length];
        int offset = -1;
        int i = 0;
        boolean checkInsert = true;
        for (int j = 0; j < children.length; ++j) {
            String id = children[j].getId();
            if (checkInsert) {
                while (i < intoChildren.size()) {
                    TreeNodeBase existingChild = (TreeNodeBase)intoChildren.get(i);
                    int cmp = id.compareTo(existingChild.getId());
                    if (cmp == 0) {
                        return id;
                    }
                    if (cmp < 0) break;
                    ++i;
                }
                if (i < intoChildren.size()) {
                    intoChildren.add(i, children[j]);
                    if (offset == -1) {
                        offset = this.getIndex((TreeNode)intoChildren.get(0));
                    }
                    indices[j] = offset + i;
                    ++i;
                    continue;
                }
                checkInsert = false;
            }
            intoChildren.add(children[j]);
            if (offset == -1) {
                offset = this.getIndex((TreeNode)intoChildren.get(0));
            }
            indices[j] = offset + i;
            ++i;
        }
        if (treeModel != null) {
            treeModel.nodesWereInserted(this, indices);
        }
        return null;
    }

    protected void removeSortedChildren(String[] childIds, List fc, DefaultTreeModel treeModel) {
        List fromChildren = fc;
        if (childIds.length == 0) {
            return;
        }
        assert (fromChildren.size() > 0);
        Object[] ids = (String[])childIds.clone();
        Arrays.sort(ids);
        Object[] childrenToRemove = new Object[ids.length];
        int[] indices = new int[ids.length];
        int i = this.getIndex((TreeNode)fromChildren.get(0));
        int j = 0;
        Iterator p = fromChildren.iterator();
        while (p.hasNext() && j < ids.length) {
            TreeNodeBase child = (TreeNodeBase)p.next();
            if (((String)ids[j]).equals(child.getId())) {
                childrenToRemove[j] = child;
                indices[j] = i;
                p.remove();
                ++j;
            }
            ++i;
        }
        assert (j == ids.length);
        if (treeModel != null) {
            treeModel.nodesWereRemoved(this, indices, childrenToRemove);
        }
    }

    protected void childrenChanged(List c, DefaultTreeModel treeModel) {
        List children = c;
        for (TreeNodeBase child : children) {
            treeModel.nodeStructureChanged(child);
        }
    }

    public int[] resize(int[] array, int size) {
        int[] result = new int[size];
        System.arraycopy(array, 0, result, 0, size);
        return result;
    }

    protected TreeNodeBase find(String id, List il) {
        List inList = il;
        for (TreeNodeBase node : inList) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }
}

