/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class HistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, HistogramAggregationBuilder>
implements MultiBucketAggregationBuilder {
    public static final String NAME = "histogram";
    private static final ObjectParser<double[], Void> EXTENDED_BOUNDS_PARSER = new ObjectParser(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName(), () -> new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY});
    private static final ObjectParser<HistogramAggregationBuilder, Void> PARSER;
    private double interval;
    private double offset = 0.0;
    private double minBound = Double.POSITIVE_INFINITY;
    private double maxBound = Double.NEGATIVE_INFINITY;
    private BucketOrder order = BucketOrder.key(true);
    private boolean keyed = false;
    private long minDocCount = 0L;

    public static HistogramAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new HistogramAggregationBuilder(aggregationName), null);
    }

    public HistogramAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.DOUBLE);
    }

    public HistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.DOUBLE);
        this.order = InternalOrder.Streams.readHistogramOrder(in, true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.interval = in.readDouble();
        this.offset = in.readDouble();
        this.minBound = in.readDouble();
        this.maxBound = in.readDouble();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out, true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeDouble(this.interval);
        out.writeDouble(this.offset);
        out.writeDouble(this.minBound);
        out.writeDouble(this.maxBound);
    }

    public double interval() {
        return this.interval;
    }

    public HistogramAggregationBuilder interval(double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be >0 for histogram aggregation [" + this.name + "]");
        }
        this.interval = interval;
        return this;
    }

    public double offset() {
        return this.offset;
    }

    public HistogramAggregationBuilder offset(double offset) {
        this.offset = offset;
        return this;
    }

    public double minBound() {
        return this.minBound;
    }

    public double maxBound() {
        return this.maxBound;
    }

    public HistogramAggregationBuilder extendedBounds(double minBound, double maxBound) {
        if (!Double.isFinite(minBound)) {
            throw new IllegalArgumentException("minBound must be finite, got: " + minBound);
        }
        if (!Double.isFinite(maxBound)) {
            throw new IllegalArgumentException("maxBound must be finite, got: " + maxBound);
        }
        if (maxBound < minBound) {
            throw new IllegalArgumentException("maxBound [" + maxBound + "] must be greater than minBound [" + minBound + "]");
        }
        this.minBound = minBound;
        this.maxBound = maxBound;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public HistogramAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder(order) ? order : BucketOrder.compound(order);
        return this;
    }

    public HistogramAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public HistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public HistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (Double.isFinite(this.minBound) || Double.isFinite(this.maxBound)) {
            builder.startObject(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName());
            if (Double.isFinite(this.minBound)) {
                builder.field("min", this.minBound);
            }
            if (Double.isFinite(this.maxBound)) {
                builder.field("max", this.maxBound);
            }
            builder.endObject();
        }
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new HistogramAggregatorFactory(this.name, config, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.minBound, this.maxBound, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.order, this.keyed, this.minDocCount, this.interval, this.offset, this.minBound, this.maxBound);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        HistogramAggregationBuilder other = (HistogramAggregationBuilder)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.interval, other.interval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.minBound, other.minBound) && Objects.equals(this.maxBound, other.maxBound);
    }

    static {
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[0] = d;
        }, new ParseField("min", new String[0]));
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[1] = d;
        }, new ParseField("max", new String[0]));
        PARSER = new ObjectParser(NAME);
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, false);
        PARSER.declareDouble(HistogramAggregationBuilder::interval, Histogram.INTERVAL_FIELD);
        PARSER.declareDouble(HistogramAggregationBuilder::offset, Histogram.OFFSET_FIELD);
        PARSER.declareBoolean(HistogramAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(HistogramAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField((histogram, extendedBounds) -> histogram.extendedBounds(extendedBounds[0], extendedBounds[1]), parser -> EXTENDED_BOUNDS_PARSER.apply((XContentParser)parser, (Void)null), ExtendedBounds.EXTENDED_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(HistogramAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam(p), Histogram.ORDER_FIELD);
    }
}

