#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: scientific
version: 0.3.5.2
id: scientific-0.3.5.2-IWSZVQGiPwx2zNrAPvmBEO
key: scientific-0.3.5.2-IWSZVQGiPwx2zNrAPvmBEO
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString.Builder.Scientific Data.Scientific
    Data.Text.Lazy.Builder.Scientific
hidden-modules: GHC.Integer.Compat Utils
abi: 6e538d6297179a35ae8f400426125b37
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/scientific-0.3.5.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/scientific-0.3.5.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/scientific-0.3.5.2
hs-libraries: HSscientific-0.3.5.2-IWSZVQGiPwx2zNrAPvmBEO
depends:
    base-4.10.1.0 integer-logarithms-1.0.2-DIHxxI1QWYABsCCmZt9aKs
    deepseq-1.4.3.0 text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj
    hashable-1.2.6.1-6LeHpYZ4iRgEy9P36eCQfR
    primitive-0.6.3.0-CXy1O9sQYlI58rn9KQkFyo containers-0.5.10.2
    binary-0.8.5.1 bytestring-0.10.8.2 integer-gmp-1.0.1.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             integer-logarithms-1.0.2-DIHxxI1QWYABsCCmZt9aKs=4fd8a063215c2e39e6b096349e215f3e
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj=b7726d921cac66adc5c8f9f66f5b25f0
             hashable-1.2.6.1-6LeHpYZ4iRgEy9P36eCQfR=e2c3f4e35e60b5547d3e7a8c501ca6de
             primitive-0.6.3.0-CXy1O9sQYlI58rn9KQkFyo=b4457a9f891c4eea587ee58a79b7f0fc
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             integer-gmp-1.0.1.0=7d948c9c98bb9ecc021f32964406f9ad
haddock-interfaces: /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html: /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

