/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends BufferedInputStream
implements SharedInputStream {
    protected RandomAccessFile in;
    protected int bufsize;
    protected long bufpos;
    protected long start = 0L;
    protected long datalen;
    private final int[] openCount;

    public SharedFileInputStream(File file) throws IOException {
        super(null);
        this.bufsize = this.buf.length;
        this.in = new RandomAccessFile(file, "r");
        this.datalen = this.in.length();
        this.openCount = new int[]{1};
    }

    public SharedFileInputStream(String file) throws IOException {
        super(null);
        this.bufsize = this.buf.length;
        this.in = new RandomAccessFile(file, "r");
        this.datalen = this.in.length();
        this.openCount = new int[]{1};
    }

    public SharedFileInputStream(File file, int size) throws IOException {
        super(null, size);
        this.bufsize = size;
        this.in = new RandomAccessFile(file, "r");
        this.datalen = this.in.length();
        this.openCount = new int[]{1};
    }

    public SharedFileInputStream(String file, int size) throws IOException {
        super(null, size);
        this.bufsize = size;
        this.in = new RandomAccessFile(file, "r");
        this.datalen = this.in.length();
        this.openCount = new int[]{1};
    }

    private SharedFileInputStream(SharedFileInputStream parent, long start, long datalen) {
        super(null, parent.bufsize);
        this.openCount = parent.openCount;
        this.in = parent.in;
        this.bufsize = parent.bufsize;
        this.start = start;
        this.datalen = datalen;
        this.bufpos = start;
    }

    @Override
    public int read() throws IOException {
        this.in.seek(this.bufpos);
        int ret = this.in.read();
        if (ret != -1) {
            ++this.bufpos;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.in.seek(this.bufpos);
        int ret = this.in.read(b, off, len);
        if (ret > 0) {
            this.bufpos += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long l2;
        long l1 = this.in.length();
        long l3 = Math.min(l1, l2 = this.start + this.datalen);
        long ret = this.bufpos + n > l3 ? l3 - (this.bufpos + n) : n;
        this.bufpos += ret;
        return ret;
    }

    @Override
    public int available() throws IOException {
        long l1 = this.in.length();
        long l2 = this.start + this.datalen;
        long l3 = Math.min(l1, l2);
        return (int)(l3 - this.bufpos);
    }

    @Override
    public void mark(int limit) {
        super.mark(limit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.in == null) return;
        int[] nArray = this.openCount;
        synchronized (this.openCount) {
            if (this.openCount[0] > 0) {
                this.openCount[0] = this.openCount[0] - 1;
                if (this.openCount[0] == 0) {
                    this.in.close();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.buf = null;
            this.in = null;
            return;
        }
    }

    @Override
    public long getPosition() {
        return this.bufpos - this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newStream(long start, long end) {
        int[] nArray = this.openCount;
        synchronized (this.openCount) {
            this.openCount[0] = this.openCount[0] + 1;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return new SharedFileInputStream(this, start, end - start);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

