/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.JosmBaseDirectories;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class Main {
    private static final String JOSM_WEBSITE = "https://josm.openstreetmap.de";
    private static final String OSM_WEBSITE = "https://www.openstreetmap.org";
    public static Component parent;
    public static volatile Main main;
    public static final Preferences pref;
    public final UndoRedoHandler undoRedo = new UndoRedoHandler();
    public static final FileWatcher fileWatcher;
    private static final Map<String, Throwable> NETWORK_ERRORS;
    private static final Set<OnlineResource> OFFLINE_RESOURCES;
    public static volatile PlatformHook platform;
    private static volatile InitStatusListener initListener;
    private static volatile Projection proj;
    private static final List<WeakReference<ProjectionChangeListener>> listeners;

    public static void setInitStatusListener(InitStatusListener listener) {
        CheckParameterUtil.ensureParameterNotNull(listener);
        initListener = listener;
    }

    protected Main() {
        Main.setInstance(this);
    }

    private static void setInstance(Main instance) {
        main = instance;
    }

    public void initialize() {
        Main.runInitializationTasks(this.beforeInitializationTasks());
        try {
            ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Utils.newThreadFactory("main-init-%d", 5));
            for (Future i : service.invokeAll(this.parallelInitializationTasks())) {
                i.get();
            }
            this.asynchronousRunnableTasks().forEach(service::submit);
            this.asynchronousCallableTasks().forEach(service::submit);
            service.shutdown();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new JosmRuntimeException(ex);
        }
        Main.runInitializationTasks(this.afterInitializationTasks());
    }

    private static void runInitializationTasks(List<InitializationTask> tasks) {
        for (InitializationTask task : tasks) {
            try {
                task.call();
            }
            catch (JosmRuntimeException e) {
                BugReport.intercept(e).warn();
            }
        }
    }

    protected List<InitializationTask> beforeInitializationTasks() {
        return Collections.emptyList();
    }

    protected Collection<InitializationTask> parallelInitializationTasks() {
        return Collections.emptyList();
    }

    protected List<Callable<?>> asynchronousCallableTasks() {
        return Collections.emptyList();
    }

    protected List<Runnable> asynchronousRunnableTasks() {
        return Collections.emptyList();
    }

    protected List<InitializationTask> afterInitializationTasks() {
        return Collections.emptyList();
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        return Collections.emptyList();
    }

    public abstract DataSet getEditDataSet();

    public abstract void setEditDataSet(DataSet var1);

    public abstract boolean containsDataSet(DataSet var1);

    public static void preConstructorInit() {
        ICoordinateFormat fmt = CoordinateFormatManager.getCoordinateFormat(Config.getPref().get("coordinates"));
        if (fmt == null) {
            fmt = DecimalDegreesCoordinateFormat.INSTANCE;
        }
        CoordinateFormatManager.setCoordinateFormat(fmt);
    }

    public static boolean exitJosm(boolean exit, int exitCode) {
        if (main != null) {
            main.shutdown();
        }
        if (exit) {
            System.exit(exitCode);
        }
        return true;
    }

    protected void shutdown() {
        if (!GraphicsEnvironment.isHeadless()) {
            ImageProvider.shutdown(false);
        }
        try {
            pref.saveDefaults();
        }
        catch (IOException ex) {
            Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to save default preferences.", new Object[0]), ex);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            ImageProvider.shutdown(true);
        }
    }

    public static void determinePlatformHook() {
        platform = Platform.determinePlatform().accept(PlatformHook.CONSTRUCT_FROM_PLATFORM);
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection p) {
        CheckParameterUtil.ensureParameterNotNull(p);
        Projection oldValue = proj;
        Bounds b = main != null ? main.getRealBounds() : null;
        proj = p;
        Main.fireProjectionChanged(oldValue, proj, b);
    }

    protected Bounds getRealBounds() {
        return null;
    }

    protected void restoreOldBounds(Bounds oldBounds) {
    }

    private static void fireProjectionChanged(Projection oldValue, Projection newValue, Bounds oldBounds) {
        if (newValue == null ^ oldValue == null || newValue != null && oldValue != null && !Objects.equals(newValue.toCode(), oldValue.toCode())) {
            listeners.removeIf(x -> x.get() == null);
            listeners.stream().map(Reference::get).filter(Objects::nonNull).forEach(x -> x.projectionChanged(oldValue, newValue));
            if (newValue != null && oldBounds != null && main != null) {
                main.restoreOldBounds(oldBounds);
            }
        }
    }

    public static void addProjectionChangeListener(ProjectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        for (WeakReference<ProjectionChangeListener> wr : listeners) {
            if (wr.get() != listener) continue;
            return;
        }
        listeners.add(new WeakReference<ProjectionChangeListener>(listener));
    }

    public static void removeProjectionChangeListener(ProjectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.removeIf(wr -> wr.get() == null || wr.get() == listener);
    }

    public static void clearProjectionChangeListeners() {
        listeners.clear();
    }

    public static Throwable addNetworkError(URL url, Throwable t) {
        if (url != null && t != null) {
            Throwable old = Main.addNetworkError(url.toExternalForm(), t);
            if (old != null) {
                Logging.warn("Already here " + old);
            }
            return old;
        }
        return null;
    }

    public static Throwable addNetworkError(String url, Throwable t) {
        if (url != null && t != null) {
            return NETWORK_ERRORS.put(url, t);
        }
        return null;
    }

    public static Map<String, Throwable> getNetworkErrors() {
        return new HashMap<String, Throwable>(NETWORK_ERRORS);
    }

    public static void clearNetworkErrors() {
        NETWORK_ERRORS.clear();
    }

    public static String getJOSMWebsite() {
        if (Config.getPref() != null) {
            return Config.getPref().get("josm.url", JOSM_WEBSITE);
        }
        return JOSM_WEBSITE;
    }

    public static String getXMLBase() {
        return "http://josm.openstreetmap.de";
    }

    public static String getOSMWebsite() {
        if (Config.getPref() != null) {
            return Config.getPref().get("osm.url", OSM_WEBSITE);
        }
        return OSM_WEBSITE;
    }

    private static String getOSMWebsiteDependingOnSelectedApi() {
        String api = OsmApi.getOsmApi().getServerUrl();
        if ("https://api.openstreetmap.org/api".equals(api)) {
            return Main.getOSMWebsite();
        }
        return api.replaceAll("/api$", "");
    }

    public static String getBaseBrowseUrl() {
        if (Config.getPref() != null) {
            return Config.getPref().get("osm-browse.url", Main.getOSMWebsiteDependingOnSelectedApi());
        }
        return Main.getOSMWebsiteDependingOnSelectedApi();
    }

    public static String getBaseUserUrl() {
        if (Config.getPref() != null) {
            return Config.getPref().get("osm-user.url", Main.getOSMWebsiteDependingOnSelectedApi() + "/user");
        }
        return Main.getOSMWebsiteDependingOnSelectedApi() + "/user";
    }

    public static boolean isPlatformOsx() {
        return platform instanceof PlatformHookOsx;
    }

    public static boolean isPlatformWindows() {
        return platform instanceof PlatformHookWindows;
    }

    public static boolean isOffline(OnlineResource r) {
        return OFFLINE_RESOURCES.contains((Object)r) || OFFLINE_RESOURCES.contains((Object)OnlineResource.ALL);
    }

    public static boolean setOffline(OnlineResource r) {
        return OFFLINE_RESOURCES.add(r);
    }

    public static boolean setOnline(OnlineResource r) {
        return OFFLINE_RESOURCES.remove((Object)r);
    }

    public static Set<OnlineResource> getOfflineResources() {
        return EnumSet.copyOf(OFFLINE_RESOURCES);
    }

    static {
        pref = new Preferences(JosmBaseDirectories.getInstance());
        fileWatcher = new FileWatcher();
        NETWORK_ERRORS = new HashMap<String, Throwable>();
        OFFLINE_RESOURCES = EnumSet.noneOf(OnlineResource.class);
        listeners = new CopyOnWriteArrayList<WeakReference<ProjectionChangeListener>>();
    }

    protected static final class InitializationTask
    implements Callable<Void> {
        private final String name;
        private final Runnable task;

        public InitializationTask(String name, Runnable task) {
            this.name = name;
            this.task = task;
        }

        @Override
        public Void call() {
            Object status = null;
            if (initListener != null) {
                status = initListener.updateStatus(this.name);
            }
            this.task.run();
            if (initListener != null) {
                initListener.finish(status);
            }
            return null;
        }
    }

    public static interface InitStatusListener {
        public Object updateStatus(String var1);

        public void finish(Object var1);
    }
}

