/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class RelationMemberConflictResolverCommand
extends ConflictResolveCommand {
    private final Conflict<Relation> conflict;
    private final List<RelationMember> mergedMembers;

    public RelationMemberConflictResolverCommand(Conflict<? extends OsmPrimitive> conflict, List<RelationMember> mergedMembers) {
        super(conflict.getMy().getDataSet());
        this.conflict = conflict;
        this.mergedMembers = mergedMembers;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in member list of relation {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.conflict.getMy().setMembers(this.mergedMembers);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }

    @Override
    public void undoCommand() {
        DataSet editDs = this.getAffectedDataSet();
        if (!Main.main.containsDataSet(editDs)) {
            Logging.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), editDs.getName()));
            return;
        }
        Main.main.setEditDataSet(editDs);
        super.undoCommand();
        if (!editDs.getConflicts().hasConflictForMy(this.conflict.getMy())) {
            editDs.getConflicts().add(this.conflict);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conflict, this.mergedMembers);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RelationMemberConflictResolverCommand that = (RelationMemberConflictResolverCommand)obj;
        return Objects.equals(this.conflict, that.conflict) && Objects.equals(this.mergedMembers, that.mergedMembers);
    }
}

