/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.datum.CentricDatum;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2Datum;
import org.openstreetmap.josm.data.projection.datum.NullDatum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.ICentralMeridianProvider;
import org.openstreetmap.josm.data.projection.proj.IScaleFactorProvider;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class CustomProjection
extends AbstractProjection {
    private static final double METER_PER_UNIT_DEGREE = 111319.49079327358;
    private static final Map<String, Double> UNITS_TO_METERS = CustomProjection.getUnitsToMeters();
    private static final Map<String, Double> PRIME_MERIDANS = CustomProjection.getPrimeMeridians();
    protected String pref;
    protected String name;
    protected String code;
    protected Bounds bounds;
    private double metersPerUnitWMTS;
    private String axis = "enu";
    private static final List<String> LON_LAT_VALUES = Arrays.asList("longlat", "latlon", "latlong");
    private EnumMap<Polarity, EastNorth> polesEN;

    public CustomProjection() {
    }

    public CustomProjection(String pref) {
        this(null, null, pref);
    }

    public CustomProjection(String name, String code, String pref) {
        this.name = name;
        this.code = code;
        this.pref = pref;
        try {
            this.update(pref);
        }
        catch (ProjectionConfigurationException ex) {
            Logging.trace(ex);
            try {
                this.update(null);
            }
            catch (ProjectionConfigurationException ex1) {
                throw BugReport.intercept(ex1).put("name", name).put("code", code).put("pref", pref);
            }
        }
    }

    public final void update(String pref) throws ProjectionConfigurationException {
        this.pref = pref;
        if (pref == null) {
            this.ellps = Ellipsoid.WGS84;
            this.datum = WGS84Datum.INSTANCE;
            this.proj = new Mercator();
            this.bounds = new Bounds(-85.05112877980659, -180.0, 85.05112877980659, 180.0, true);
        } else {
            String s;
            Map<String, String> parameters = CustomProjection.parseParameterList(pref, false);
            parameters = CustomProjection.resolveInits(parameters, false);
            this.ellps = this.parseEllipsoid(parameters);
            this.datum = this.parseDatum(parameters, this.ellps);
            if (this.ellps == null) {
                this.ellps = this.datum.getEllipsoid();
            }
            this.proj = this.parseProjection(parameters, this.ellps);
            if ("utm".equals(parameters.get(Param.proj.key))) {
                Integer zone;
                try {
                    zone = Integer.valueOf(Optional.ofNullable(parameters.get(Param.zone.key)).orElseThrow(() -> new ProjectionConfigurationException(I18n.tr("UTM projection (''+proj=utm'') requires ''+zone=...'' parameter.", new Object[0]))));
                }
                catch (NumberFormatException e) {
                    zone = null;
                }
                if (zone == null || zone < 1 || zone > 60) {
                    throw new ProjectionConfigurationException(I18n.tr("Expected integer value in range 1-60 for ''+zone=...'' parameter.", new Object[0]));
                }
                this.lon0 = 6.0 * (double)zone.intValue() - 183.0;
                this.k0 = 0.9996;
                this.x0 = 500000.0;
                double d = this.y0 = parameters.containsKey(Param.south.key) ? 1.0E7 : 0.0;
            }
            if ((s = parameters.get(Param.x_0.key)) != null) {
                this.x0 = CustomProjection.parseDouble(s, Param.x_0.key);
            }
            if ((s = parameters.get(Param.y_0.key)) != null) {
                this.y0 = CustomProjection.parseDouble(s, Param.y_0.key);
            }
            if ((s = parameters.get(Param.lon_0.key)) != null) {
                this.lon0 = CustomProjection.parseAngle(s, Param.lon_0.key);
            }
            if (this.proj instanceof ICentralMeridianProvider) {
                this.lon0 = ((ICentralMeridianProvider)((Object)this.proj)).getCentralMeridian();
            }
            if ((s = parameters.get(Param.pm.key)) != null) {
                this.pm = PRIME_MERIDANS.containsKey(s) ? PRIME_MERIDANS.get(s) : CustomProjection.parseAngle(s, Param.pm.key);
            }
            if ((s = parameters.get(Param.k_0.key)) != null) {
                this.k0 = CustomProjection.parseDouble(s, Param.k_0.key);
            }
            if (this.proj instanceof IScaleFactorProvider) {
                this.k0 *= ((IScaleFactorProvider)((Object)this.proj)).getScaleFactor();
            }
            if ((s = parameters.get(Param.bounds.key)) != null) {
                this.bounds = CustomProjection.parseBounds(s);
            }
            if ((s = parameters.get(Param.wmssrs.key)) != null) {
                this.code = s;
            }
            boolean defaultUnits = true;
            s = parameters.get(Param.units.key);
            if (s != null) {
                if (UNITS_TO_METERS.containsKey(s = Utils.strip(s, "\""))) {
                    this.metersPerUnitWMTS = this.toMeter = UNITS_TO_METERS.get(s).doubleValue();
                    defaultUnits = false;
                } else {
                    throw new ProjectionConfigurationException(I18n.tr("No unit found for: {0}", s));
                }
            }
            if ((s = parameters.get(Param.to_meter.key)) != null) {
                this.metersPerUnitWMTS = this.toMeter = CustomProjection.parseDouble(s, Param.to_meter.key);
                defaultUnits = false;
            }
            if (defaultUnits) {
                this.toMeter = 1.0;
                double d = this.metersPerUnitWMTS = this.proj.isGeographic() ? 111319.49079327358 : 1.0;
            }
            if ((s = parameters.get(Param.axis.key)) != null) {
                this.axis = s;
            }
        }
    }

    public static Map<String, String> parseParameterList(String pref, boolean ignoreUnknownParameter) throws ProjectionConfigurationException {
        String[] parts;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String trimmedPref = pref.trim();
        if (trimmedPref.isEmpty()) {
            return parameters;
        }
        Pattern keyPattern = Pattern.compile("\\+(?<key>[a-zA-Z0-9_]+)(=(?<value>.*))?");
        for (String part : parts = Utils.WHITE_SPACES_PATTERN.split(trimmedPref)) {
            String value;
            String key;
            Matcher m = keyPattern.matcher(part);
            if (m.matches()) {
                Param param;
                key = m.group("key");
                value = m.group("value");
                if (key.equals(Param.proj.key) && LON_LAT_VALUES.contains(value)) {
                    value = "lonlat";
                }
                if ((param = Param.paramsByKey.get(key)) == null) {
                    if (!ignoreUnknownParameter) {
                        throw new ProjectionConfigurationException(I18n.tr("Unknown parameter: ''{0}''.", key));
                    }
                } else {
                    if (param.hasValue && value == null) {
                        throw new ProjectionConfigurationException(I18n.tr("Value expected for parameter ''{0}''.", key));
                    }
                    if (!param.hasValue && value != null) {
                        throw new ProjectionConfigurationException(I18n.tr("No value expected for parameter ''{0}''.", key));
                    }
                    key = param.key;
                }
            } else {
                if (!part.startsWith("+")) {
                    throw new ProjectionConfigurationException(I18n.tr("Parameter must begin with a ''+'' character (found ''{0}'')", part));
                }
                throw new ProjectionConfigurationException(I18n.tr("Unexpected parameter format (''{0}'')", part));
            }
            parameters.put(key, value);
        }
        return parameters;
    }

    public static Map<String, String> resolveInits(Map<String, String> parameters, boolean ignoreUnknownParameter) throws ProjectionConfigurationException {
        String initKey = parameters.get(Param.init.key);
        if (initKey != null) {
            Map<String, String> initp;
            try {
                initp = CustomProjection.parseParameterList(Optional.ofNullable(Projections.getInit(initKey)).orElseThrow(() -> new ProjectionConfigurationException(I18n.tr("Value ''{0}'' for option +init not supported.", initKey))), ignoreUnknownParameter);
                initp = CustomProjection.resolveInits(initp, ignoreUnknownParameter);
            }
            catch (ProjectionConfigurationException ex) {
                throw new ProjectionConfigurationException(initKey + ": " + ex.getMessage(), ex);
            }
            initp.putAll(parameters);
            return initp;
        }
        return parameters;
    }

    public Ellipsoid parseEllipsoid(Map<String, String> parameters) throws ProjectionConfigurationException {
        String code = parameters.get(Param.ellps.key);
        if (code != null) {
            return Optional.ofNullable(Projections.getEllipsoid(code)).orElseThrow(() -> new ProjectionConfigurationException(I18n.tr("Ellipsoid ''{0}'' not supported.", code)));
        }
        String s = parameters.get(Param.a.key);
        if (s != null) {
            double a = CustomProjection.parseDouble(s, Param.a.key);
            if (parameters.get(Param.es.key) != null) {
                double es = CustomProjection.parseDouble(parameters, Param.es.key);
                return Ellipsoid.createAes(a, es);
            }
            if (parameters.get(Param.rf.key) != null) {
                double rf = CustomProjection.parseDouble(parameters, Param.rf.key);
                return Ellipsoid.createArf(a, rf);
            }
            if (parameters.get(Param.f.key) != null) {
                double f = CustomProjection.parseDouble(parameters, Param.f.key);
                return Ellipsoid.createAf(a, f);
            }
            if (parameters.get(Param.b.key) != null) {
                double b = CustomProjection.parseDouble(parameters, Param.b.key);
                return Ellipsoid.createAb(a, b);
            }
        }
        if (parameters.containsKey(Param.a.key) || parameters.containsKey(Param.es.key) || parameters.containsKey(Param.rf.key) || parameters.containsKey(Param.f.key) || parameters.containsKey(Param.b.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Combination of ellipsoid parameters is not supported.", new Object[0]));
        }
        return null;
    }

    public Datum parseDatum(Map<String, String> parameters, Ellipsoid ellps) throws ProjectionConfigurationException {
        String nadgridsId;
        String datumId = parameters.get(Param.datum.key);
        if (datumId != null) {
            return Optional.ofNullable(Projections.getDatum(datumId)).orElseThrow(() -> new ProjectionConfigurationException(I18n.tr("Unknown datum identifier: ''{0}''", datumId)));
        }
        if (ellps == null) {
            if (parameters.containsKey(Param.no_defs.key)) {
                throw new ProjectionConfigurationException(I18n.tr("Ellipsoid required (+ellps=* or +a=*, +b=*)", new Object[0]));
            }
            ellps = Ellipsoid.WGS84;
        }
        if ((nadgridsId = parameters.get(Param.nadgrids.key)) != null) {
            if (nadgridsId.startsWith("@")) {
                nadgridsId = nadgridsId.substring(1);
            }
            if ("null".equals(nadgridsId)) {
                return new NullDatum(null, ellps);
            }
            String fNadgridsId = nadgridsId;
            return new NTV2Datum(fNadgridsId, null, ellps, Optional.ofNullable(Projections.getNTV2Grid(fNadgridsId)).orElseThrow(() -> new ProjectionConfigurationException(I18n.tr("Grid shift file ''{0}'' for option +nadgrids not supported.", fNadgridsId))));
        }
        String towgs84 = parameters.get(Param.towgs84.key);
        if (towgs84 != null) {
            return this.parseToWGS84(towgs84, ellps);
        }
        return new NullDatum(null, ellps);
    }

    public Datum parseToWGS84(String paramList, Ellipsoid ellps) throws ProjectionConfigurationException {
        String[] numStr = paramList.split(",");
        if (numStr.length != 3 && numStr.length != 7) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''towgs84'' (must be 3 or 7)", new Object[0]));
        }
        ArrayList<Double> towgs84Param = new ArrayList<Double>();
        for (String str : numStr) {
            try {
                towgs84Param.add(Double.valueOf(str));
            }
            catch (NumberFormatException e) {
                throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of parameter ''towgs84'' (''{0}'')", str), e);
            }
        }
        boolean isCentric = true;
        for (Double param : towgs84Param) {
            if (param == 0.0) continue;
            isCentric = false;
            break;
        }
        if (isCentric) {
            return new CentricDatum(null, null, ellps);
        }
        boolean is3Param = true;
        for (int i = 3; i < towgs84Param.size(); ++i) {
            if ((Double)towgs84Param.get(i) == 0.0) continue;
            is3Param = false;
            break;
        }
        if (is3Param) {
            return new ThreeParameterDatum(null, null, ellps, (Double)towgs84Param.get(0), (Double)towgs84Param.get(1), (Double)towgs84Param.get(2));
        }
        return new SevenParameterDatum(null, null, ellps, (Double)towgs84Param.get(0), (Double)towgs84Param.get(1), (Double)towgs84Param.get(2), (Double)towgs84Param.get(3), (Double)towgs84Param.get(4), (Double)towgs84Param.get(5), (Double)towgs84Param.get(6));
    }

    public Proj parseProjection(Map<String, String> parameters, Ellipsoid ellps) throws ProjectionConfigurationException {
        Proj proj;
        String id = parameters.get(Param.proj.key);
        if (id == null) {
            throw new ProjectionConfigurationException(I18n.tr("Projection required (+proj=*)", new Object[0]));
        }
        if ("utm".equals(id)) {
            id = "tmerc";
        }
        if ((proj = Projections.getBaseProjection(id)) == null) {
            throw new ProjectionConfigurationException(I18n.tr("Unknown projection identifier: ''{0}''", id));
        }
        ProjParameters projParams = new ProjParameters();
        projParams.ellps = ellps;
        String s = parameters.get(Param.lat_0.key);
        if (s != null) {
            projParams.lat0 = CustomProjection.parseAngle(s, Param.lat_0.key);
        }
        if ((s = parameters.get(Param.lat_1.key)) != null) {
            projParams.lat1 = CustomProjection.parseAngle(s, Param.lat_1.key);
        }
        if ((s = parameters.get(Param.lat_2.key)) != null) {
            projParams.lat2 = CustomProjection.parseAngle(s, Param.lat_2.key);
        }
        if ((s = parameters.get(Param.lat_ts.key)) != null) {
            projParams.lat_ts = CustomProjection.parseAngle(s, Param.lat_ts.key);
        }
        if ((s = parameters.get(Param.lonc.key)) != null) {
            projParams.lonc = CustomProjection.parseAngle(s, Param.lonc.key);
        }
        if ((s = parameters.get(Param.alpha.key)) != null) {
            projParams.alpha = CustomProjection.parseAngle(s, Param.alpha.key);
        }
        if ((s = parameters.get(Param.gamma.key)) != null) {
            projParams.gamma = CustomProjection.parseAngle(s, Param.gamma.key);
        }
        if ((s = parameters.get(Param.lon_1.key)) != null) {
            projParams.lon1 = CustomProjection.parseAngle(s, Param.lon_1.key);
        }
        if ((s = parameters.get(Param.lon_2.key)) != null) {
            projParams.lon2 = CustomProjection.parseAngle(s, Param.lon_2.key);
        }
        if (parameters.containsKey(Param.no_off.key) || parameters.containsKey(Param.no_uoff.key)) {
            projParams.no_off = Boolean.TRUE;
        }
        proj.initialize(projParams);
        return proj;
    }

    public static Bounds parseBounds(String boundsStr) throws ProjectionConfigurationException {
        String[] numStr = boundsStr.split(",");
        if (numStr.length != 4) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''+bounds'' (must be 4)", new Object[0]));
        }
        return new Bounds(CustomProjection.parseAngle(numStr[1], "minlat (+bounds)"), CustomProjection.parseAngle(numStr[0], "minlon (+bounds)"), CustomProjection.parseAngle(numStr[3], "maxlat (+bounds)"), CustomProjection.parseAngle(numStr[2], "maxlon (+bounds)"), false);
    }

    public static double parseDouble(Map<String, String> parameters, String parameterName) throws ProjectionConfigurationException {
        if (!parameters.containsKey(parameterName)) {
            throw new ProjectionConfigurationException(I18n.tr("Unknown parameter ''{0}''", parameterName));
        }
        return CustomProjection.parseDouble(Optional.ofNullable(parameters.get(parameterName)).orElseThrow(() -> new ProjectionConfigurationException(I18n.tr("Expected number argument for parameter ''{0}''", parameterName))), parameterName);
    }

    public static double parseDouble(String doubleStr, String parameterName) throws ProjectionConfigurationException {
        try {
            return Double.parseDouble(doubleStr);
        }
        catch (NumberFormatException e) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as number.", parameterName, doubleStr), e);
        }
    }

    public static double parseAngle(String angleStr, String parameterName) throws ProjectionConfigurationException {
        try {
            return LatLonParser.parseCoordinate(angleStr);
        }
        catch (IllegalArgumentException e) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as coordinate value.", parameterName, angleStr), e);
        }
    }

    @Override
    public Integer getEpsgCode() {
        if (this.code != null && this.code.startsWith("EPSG:")) {
            try {
                return Integer.valueOf(this.code.substring(5));
            }
            catch (NumberFormatException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    @Override
    public String toCode() {
        if (this.code != null) {
            return this.code;
        }
        if (this.pref != null) {
            return "proj:" + this.pref;
        }
        return "proj:ERROR";
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        if (this.bounds == null) {
            Bounds ab = this.proj.getAlgorithmBounds();
            if (ab != null) {
                double minlon = Math.max(ab.getMinLon() + this.lon0 + this.pm, -180.0);
                double maxlon = Math.min(ab.getMaxLon() + this.lon0 + this.pm, 180.0);
                this.bounds = new Bounds(ab.getMinLat(), minlon, ab.getMaxLat(), maxlon, false);
            } else {
                this.bounds = new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
            }
        }
        return this.bounds;
    }

    @Override
    public String toString() {
        return this.name != null ? this.name : I18n.tr("Custom Projection", new Object[0]);
    }

    @Override
    public double getMetersPerUnit() {
        return this.metersPerUnitWMTS;
    }

    @Override
    public boolean switchXY() {
        return this.axis.startsWith("ne");
    }

    private static Map<String, Double> getUnitsToMeters() {
        ConcurrentHashMap<String, Double> ret = new ConcurrentHashMap<String, Double>();
        ret.put("km", 1000.0);
        ret.put("m", 1.0);
        ret.put("dm", 0.1);
        ret.put("cm", 0.01);
        ret.put("mm", 0.001);
        ret.put("kmi", 1852.0);
        ret.put("in", 0.0254);
        ret.put("ft", 0.3048);
        ret.put("yd", 0.9144);
        ret.put("mi", 1609.344);
        ret.put("fathom", 1.8288);
        ret.put("chain", 20.1168);
        ret.put("link", 0.201168);
        ret.put("us-in", 0.025400050800101603);
        ret.put("us-ft", 0.304800609601219);
        ret.put("us-yd", 0.914401828803658);
        ret.put("us-ch", 20.11684023368047);
        ret.put("us-mi", 1609.347218694437);
        ret.put("ind-yd", 0.91439523);
        ret.put("ind-ft", 0.30479841);
        ret.put("ind-ch", 20.11669506);
        ret.put("degree", 111319.49079327358);
        return ret;
    }

    private static Map<String, Double> getPrimeMeridians() {
        ConcurrentHashMap<String, Double> ret = new ConcurrentHashMap<String, Double>();
        try {
            ret.put("greenwich", 0.0);
            ret.put("lisbon", CustomProjection.parseAngle("9d07'54.862\"W", null));
            ret.put("paris", CustomProjection.parseAngle("2d20'14.025\"E", null));
            ret.put("bogota", CustomProjection.parseAngle("74d04'51.3\"W", null));
            ret.put("madrid", CustomProjection.parseAngle("3d41'16.58\"W", null));
            ret.put("rome", CustomProjection.parseAngle("12d27'8.4\"E", null));
            ret.put("bern", CustomProjection.parseAngle("7d26'22.5\"E", null));
            ret.put("jakarta", CustomProjection.parseAngle("106d48'27.79\"E", null));
            ret.put("ferro", CustomProjection.parseAngle("17d40'W", null));
            ret.put("brussels", CustomProjection.parseAngle("4d22'4.71\"E", null));
            ret.put("stockholm", CustomProjection.parseAngle("18d3'29.8\"E", null));
            ret.put("athens", CustomProjection.parseAngle("23d42'58.815\"E", null));
            ret.put("oslo", CustomProjection.parseAngle("10d43'22.5\"E", null));
        }
        catch (ProjectionConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        return ret;
    }

    private static EastNorth getPointAlong(int i, int n, ProjectionBounds r) {
        double dEast = (r.maxEast - r.minEast) / (double)n;
        double dNorth = (r.maxNorth - r.minNorth) / (double)n;
        if (i < n) {
            return new EastNorth(r.minEast + (double)i * dEast, r.minNorth);
        }
        if (i < 2 * n) {
            return new EastNorth(r.maxEast, r.minNorth + (double)(i -= n) * dNorth);
        }
        if (i < 3 * n) {
            return new EastNorth(r.maxEast - (double)(i -= 2 * n) * dEast, r.maxNorth);
        }
        if (i < 4 * n) {
            return new EastNorth(r.minEast, r.maxNorth - (double)(i -= 3 * n) * dNorth);
        }
        throw new AssertionError();
    }

    private EastNorth getPole(Polarity whichPole) {
        if (this.polesEN == null) {
            this.polesEN = new EnumMap(Polarity.class);
            for (Polarity p : Polarity.values()) {
                this.polesEN.put(p, null);
                LatLon ll = p.getLatLon();
                try {
                    LatLon llBack;
                    EastNorth enPole = this.latlon2eastNorth(ll);
                    if (!enPole.isValid() || !(llBack = this.eastNorth2latlon(enPole)).isValid() || !(ll.greatCircleDistance(llBack) < 1000.0)) continue;
                    this.polesEN.put(p, enPole);
                }
                catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                    Logging.error(e);
                }
            }
        }
        return this.polesEN.get((Object)whichPole);
    }

    @Override
    public Bounds getLatLonBoundsBox(ProjectionBounds r) {
        int n = 10;
        Bounds result = new Bounds(this.eastNorth2latlon(r.getMin()));
        result.extend(this.eastNorth2latlon(r.getMax()));
        LatLon llPrev = null;
        for (int i = 0; i < 40; ++i) {
            LatLon llNow = this.eastNorth2latlon(CustomProjection.getPointAlong(i, 10, r));
            result.extend(llNow);
            if (llPrev != null) {
                double lon1 = llPrev.lon();
                double lon2 = llNow.lon();
                if (90.0 < lon1 && lon1 < 180.0 && -180.0 < lon2 && lon2 < -90.0) {
                    result.extend(new LatLon(llPrev.lat(), 180.0));
                    result.extend(new LatLon(llNow.lat(), -180.0));
                }
                if (90.0 < lon2 && lon2 < 180.0 && -180.0 < lon1 && lon1 < -90.0) {
                    result.extend(new LatLon(llNow.lat(), 180.0));
                    result.extend(new LatLon(llPrev.lat(), -180.0));
                }
            }
            llPrev = llNow;
        }
        for (Polarity p : Polarity.values()) {
            EastNorth pole = this.getPole(p);
            if (pole == null || !r.contains(pole)) continue;
            result.extend(p.getLatLon());
        }
        return result;
    }

    @Override
    public ProjectionBounds getEastNorthBoundsBox(ProjectionBounds box, Projection boxProjection) {
        int n = 8;
        ProjectionBounds result = null;
        for (int i = 0; i < 32; ++i) {
            EastNorth en = this.latlon2eastNorth(boxProjection.eastNorth2latlon(CustomProjection.getPointAlong(i, 8, box)));
            if (result == null) {
                result = new ProjectionBounds(en);
                continue;
            }
            result.extend(en);
        }
        return result;
    }

    public boolean isGeographic() {
        return this.proj.isGeographic();
    }

    static enum Polarity {
        NORTH(LatLon.NORTH_POLE),
        SOUTH(LatLon.SOUTH_POLE);

        private final LatLon latlon;

        private Polarity(LatLon latlon) {
            this.latlon = latlon;
        }

        LatLon getLatLon() {
            return this.latlon;
        }
    }

    public static enum Param {
        x_0("x_0", true),
        y_0("y_0", true),
        lon_0("lon_0", true),
        pm("pm", true),
        k_0("k_0", true),
        ellps("ellps", true),
        a("a", true),
        es("es", true),
        rf("rf", true),
        f("f", true),
        b("b", true),
        datum("datum", true),
        towgs84("towgs84", true),
        nadgrids("nadgrids", true),
        proj("proj", true),
        lat_0("lat_0", true),
        lat_1("lat_1", true),
        lat_2("lat_2", true),
        lat_ts("lat_ts", true),
        lonc("lonc", true),
        alpha("alpha", true),
        gamma("gamma", true),
        no_off("no_off", false),
        no_uoff("no_uoff", false),
        lon_1("lon_1", true),
        lon_2("lon_2", true),
        wktext("wktext", false),
        units("units", true),
        no_defs("no_defs", false),
        init("init", true),
        to_meter("to_meter", true),
        axis("axis", true),
        zone("zone", true),
        south("south", false),
        vunits("vunits", true),
        wmssrs("wmssrs", true),
        bounds("bounds", true);

        public final String key;
        public final boolean hasValue;
        static final Map<String, Param> paramsByKey;

        private Param(String key, boolean hasValue) {
            this.key = key;
            this.hasValue = hasValue;
        }

        static {
            paramsByKey = new ConcurrentHashMap<String, Param>();
            for (Param p : Param.values()) {
                paramsByKey.put(p.key, p);
            }
            paramsByKey.put("k", k_0);
        }
    }
}

