/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.logging.PrefixLogger;

public class Loggers {
    public static final String SPACE = " ";

    public static Logger getLogger(Logger parentLogger, String s) {
        assert (parentLogger instanceof PrefixLogger);
        return ESLoggerFactory.getLogger(((PrefixLogger)parentLogger).prefix(), parentLogger.getName() + s);
    }

    public static Logger getLogger(String s) {
        return ESLoggerFactory.getLogger(s);
    }

    public static Logger getLogger(Class<?> clazz) {
        return ESLoggerFactory.getLogger(clazz);
    }

    public static Logger getLogger(Class<?> clazz, String ... prefixes) {
        return ESLoggerFactory.getLogger(Loggers.formatPrefix(prefixes), clazz);
    }

    public static Logger getLogger(String name, String ... prefixes) {
        return ESLoggerFactory.getLogger(Loggers.formatPrefix(prefixes), name);
    }

    private static String formatPrefix(String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                sb.append(SPACE);
                prefix = sb.toString();
            }
        }
        return prefix;
    }
}

