/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JavaVersion {
    static final List<Integer> CURRENT = JavaVersion.parse(System.getProperty("java.specification.version"));
    static final List<Integer> JAVA_8 = JavaVersion.parse("1.8");

    static List<Integer> parse(String value) {
        String[] components;
        if (!value.matches("^0*[0-9]+(\\.[0-9]+)*$")) {
            throw new IllegalArgumentException(value);
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        for (String component : components = value.split("\\.")) {
            version.add(Integer.valueOf(component));
        }
        return version;
    }

    static int majorVersion(List<Integer> javaVersion) {
        Objects.requireNonNull(javaVersion);
        if (javaVersion.get(0) > 1) {
            return javaVersion.get(0);
        }
        return javaVersion.get(1);
    }

    static int compare(List<Integer> left, List<Integer> right) {
        int len = Math.max(left.size(), right.size());
        for (int i = 0; i < len; ++i) {
            int r;
            int l = i < left.size() ? left.get(i) : 0;
            int n = r = i < right.size() ? right.get(i) : 0;
            if (l < r) {
                return -1;
            }
            if (r >= l) continue;
            return 1;
        }
        return 0;
    }
}

