/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.open;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class OpenIndexResponse
extends AcknowledgedResponse
implements ToXContentObject {
    private static final String SHARDS_ACKNOWLEDGED = "shards_acknowledged";
    private static final ParseField SHARDS_ACKNOWLEDGED_PARSER = new ParseField("shards_acknowledged", new String[0]);
    private static final ConstructingObjectParser<OpenIndexResponse, Void> PARSER = new ConstructingObjectParser("open_index", true, args -> new OpenIndexResponse((Boolean)args[0], (Boolean)args[1]));
    private boolean shardsAcknowledged;

    OpenIndexResponse() {
    }

    OpenIndexResponse(boolean acknowledged, boolean shardsAcknowledged) {
        super(acknowledged);
        assert (acknowledged || !shardsAcknowledged);
        this.shardsAcknowledged = shardsAcknowledged;
    }

    public boolean isShardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.readAcknowledged(in);
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.shardsAcknowledged = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeAcknowledged(out);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.shardsAcknowledged);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addAcknowledgedField(builder);
        builder.field(SHARDS_ACKNOWLEDGED, this.isShardsAcknowledged());
        builder.endObject();
        return builder;
    }

    public static OpenIndexResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    static {
        OpenIndexResponse.declareAcknowledgedField(PARSER);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), SHARDS_ACKNOWLEDGED_PARSER, ObjectParser.ValueType.BOOLEAN);
    }
}

