/*
 * Decompiled with CFR 0.152.
 */
package net.iharder.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.fibs.geotag.util.ClassLoaderUtil;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;
    private static String ZERO_CHAR_STRING;

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
        ZERO_CHAR_STRING = "\u0000";
    }

    public FileDrop(Component c, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public FileDrop(Component c, boolean recursive, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(PrintStream out, Component c, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public FileDrop(PrintStream out, Component c, boolean recursive, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(Component c, Border dragBorder, Listener listener) {
        this(null, c, dragBorder, false, listener);
    }

    public FileDrop(Component c, Border dragBorder, boolean recursive, Listener listener) {
        this(null, c, dragBorder, recursive, listener);
    }

    public FileDrop(PrintStream out, Component c, Border dragBorder, Listener listener) {
        this(out, c, dragBorder, false, listener);
    }

    public FileDrop(final PrintStream out, final Component c, final Border dragBorder, boolean recursive, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent evt) {
                    FileDrop.log(out, "FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(out, evt)) {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            FileDrop.this.normalBorder = jc.getBorder();
                            FileDrop.log(out, "FileDrop: normal border saved.");
                            jc.setBorder(dragBorder);
                            FileDrop.log(out, "FileDrop: drag border set.");
                        }
                        evt.acceptDrag(1);
                        FileDrop.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        FileDrop.log(out, "FileDrop: event rejected.");
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent evt) {
                }

                @Override
                public void drop(DropTargetDropEvent evt) {
                    FileDrop.log(out, "FileDrop: drop event.");
                    try {
                        try {
                            Transferable tr = evt.getTransferable();
                            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                                evt.acceptDrop(1);
                                FileDrop.log(out, "FileDrop: file list accepted.");
                                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                                Iterator iterator = fileList.iterator();
                                File[] filesTemp = new File[fileList.size()];
                                fileList.toArray(filesTemp);
                                File[] files = filesTemp;
                                if (listener != null) {
                                    listener.filesDropped(files);
                                }
                                evt.getDropTargetContext().dropComplete(true);
                                FileDrop.log(out, "FileDrop: drop complete.");
                            } else {
                                DataFlavor[] flavors = tr.getTransferDataFlavors();
                                boolean handled = false;
                                int zz = 0;
                                while (zz < flavors.length) {
                                    if (flavors[zz].isRepresentationClassReader()) {
                                        evt.acceptDrop(1);
                                        FileDrop.log(out, "FileDrop: reader accepted.");
                                        Reader reader = flavors[zz].getReaderForText(tr);
                                        BufferedReader br = new BufferedReader(reader);
                                        if (listener != null) {
                                            listener.filesDropped(FileDrop.createFileArray(br, out));
                                        }
                                        evt.getDropTargetContext().dropComplete(true);
                                        FileDrop.log(out, "FileDrop: drop complete.");
                                        handled = true;
                                        break;
                                    }
                                    ++zz;
                                }
                                if (!handled) {
                                    FileDrop.log(out, "FileDrop: not a file list or reader - abort.");
                                    evt.rejectDrop();
                                }
                            }
                        }
                        catch (IOException io) {
                            FileDrop.log(out, "FileDrop: IOException - abort:");
                            io.printStackTrace(out);
                            evt.rejectDrop();
                            if (c instanceof JComponent) {
                                JComponent jc = (JComponent)c;
                                jc.setBorder(FileDrop.this.normalBorder);
                                FileDrop.log(out, "FileDrop: normal border restored.");
                            }
                        }
                        catch (UnsupportedFlavorException ufe) {
                            FileDrop.log(out, "FileDrop: UnsupportedFlavorException - abort:");
                            ufe.printStackTrace(out);
                            evt.rejectDrop();
                            if (c instanceof JComponent) {
                                JComponent jc = (JComponent)c;
                                jc.setBorder(FileDrop.this.normalBorder);
                                FileDrop.log(out, "FileDrop: normal border restored.");
                            }
                        }
                    }
                    finally {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(out, "FileDrop: normal border restored.");
                        }
                    }
                }

                @Override
                public void dragExit(DropTargetEvent evt) {
                    FileDrop.log(out, "FileDrop: dragExit event.");
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(out, "FileDrop: normal border restored.");
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent evt) {
                    FileDrop.log(out, "FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(out, evt)) {
                        evt.acceptDrag(1);
                        FileDrop.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        FileDrop.log(out, "FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(out, c, recursive);
        } else {
            FileDrop.log(out, "FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean support = false;
            try {
                Class<?> arbitraryDndClass = ClassLoaderUtil.getClassForName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            supportsDnD = new Boolean(support);
        }
        return supportsDnD;
    }

    private static File[] createFileArray(BufferedReader bReader, PrintStream out) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (URISyntaxException ex) {
                    FileDrop.log(out, "FileDrop: URISyntaxException");
                }
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException ex) {
            FileDrop.log(out, "FileDrop: IOException");
            return new File[0];
        }
    }

    private void makeDropTarget(final PrintStream out, final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            FileDrop.log(out, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                FileDrop.log(out, "FileDrop: Hierarchy changed.");
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                    FileDrop.log(out, "FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                    FileDrop.log(out, "FileDrop: Drop target added to component.");
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            int i = 0;
            while (i < comps.length) {
                this.makeDropTarget(out, comps[i], recursive);
                ++i;
            }
        }
    }

    private boolean isDragOk(PrintStream out, DropTargetDragEvent evt) {
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        int i = 0;
        while (!ok && i < flavors.length) {
            DataFlavor curFlavor = flavors[i];
            if (curFlavor.equals(DataFlavor.javaFileListFlavor) || curFlavor.isRepresentationClassReader()) {
                ok = true;
            }
            ++i;
        }
        if (out != null) {
            if (flavors.length == 0) {
                FileDrop.log(out, "FileDrop: no data flavors.");
            }
            i = 0;
            while (i < flavors.length) {
                FileDrop.log(out, flavors[i].toString());
                ++i;
            }
        }
        return ok;
    }

    private static void log(PrintStream out, String message) {
        if (out != null) {
            out.println(message);
        }
    }

    public static boolean remove(Component c) {
        return FileDrop.remove(null, c, true);
    }

    public static boolean remove(PrintStream out, Component c, boolean recursive) {
        if (FileDrop.supportsDnD()) {
            FileDrop.log(out, "FileDrop: Removing drag-and-drop hooks.");
            c.setDropTarget(null);
            if (recursive && c instanceof Container) {
                Component[] comps = ((Container)c).getComponents();
                int i = 0;
                while (i < comps.length) {
                    FileDrop.remove(out, comps[i], recursive);
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("FileDrop");
        final JTextArea text = new JTextArea();
        frame.getContentPane().add((Component)new JScrollPane(text), "Center");
        new FileDrop(System.out, text, new Listener(){

            @Override
            public void filesDropped(File[] files) {
                int i = 0;
                while (i < files.length) {
                    try {
                        text.append(String.valueOf(files[i].getCanonicalPath()) + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        });
        frame.setBounds(100, 100, 300, 400);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

