/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterVNA;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterVNAPanel;
import org.openide.util.NbBundle;

public class UIExporterVNA
implements ExporterUI {
    UIExporterVNAPanel panel;
    ExporterVNA exporter;
    ExporterVNASettings settings = new ExporterVNASettings();

    public JPanel getPanel() {
        this.panel = new UIExporterVNAPanel();
        return this.panel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (ExporterVNA)exporter;
        this.settings.load(this.exporter);
        this.panel.setup((ExporterVNA)exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterVNA;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterVNA.class, (String)"UIExporterVNA.name");
    }

    private static class ExporterVNASettings {
        private boolean exportEdgeWeight = true;
        private boolean exportCoords = true;
        private boolean exportSize = true;
        private boolean exportShortLabel = true;
        private boolean exportColor = true;
        private boolean normalize = false;
        private boolean exportAttributes = true;

        private ExporterVNASettings() {
        }

        private void load(ExporterVNA exporter) {
            exporter.setExportColor(this.exportColor);
            exporter.setExportCoords(this.exportCoords);
            exporter.setExportEdgeWeight(this.exportEdgeWeight);
            exporter.setExportShortLabel(this.exportShortLabel);
            exporter.setExportSize(this.exportSize);
            exporter.setExportAttributes(this.exportAttributes);
            exporter.setNormalize(this.normalize);
        }

        private void save(ExporterVNA exporter) {
            this.exportColor = exporter.isExportColor();
            this.exportCoords = exporter.isExportCoords();
            this.exportEdgeWeight = exporter.isExportEdgeWeight();
            this.exportShortLabel = exporter.isExportShortLabel();
            this.exportSize = exporter.isExportSize();
            this.exportAttributes = exporter.isExportAttributes();
            this.normalize = exporter.isNormalize();
        }
    }
}

