/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.function.edit.FieldEdit;
import tim.prune.function.edit.FieldEditList;

public class PointNameEditor
extends GenericFunction {
    private JDialog _dialog = null;
    private DataPoint _point = null;
    private JTextField _nameField = null;
    private JButton _okButton = null;

    public PointNameEditor(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.editwaypointname";
    }

    public void begin() {
        this._point = this._app.getTrackInfo().getCurrentPoint();
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        String string = this._point.getWaypointName();
        this.resetDialog(string);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(8, 8));
        jPanel2.add((Component)new JLabel(String.valueOf(I18nManager.getText("dialog.pointnameedit.name")) + ": "), "West");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointNameEditor.this.confirmEdit();
                PointNameEditor.this._dialog.dispose();
            }
        };
        this._nameField = new JTextField("", 12);
        this._nameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PointNameEditor.this._dialog.dispose();
                }
                PointNameEditor.this._okButton.setEnabled(PointNameEditor.this.hasNameChanged());
            }
        });
        this._nameField.addActionListener(actionListener);
        jPanel2.add((Component)this._nameField, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JButton jButton = new JButton(I18nManager.getText("dialog.pointnameedit.uppercase"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointNameEditor.this._nameField.setText(PointNameEditor.this._nameField.getText().toUpperCase());
                PointNameEditor.this._okButton.setEnabled(true);
                PointNameEditor.this._nameField.requestFocus();
            }
        });
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("dialog.pointnameedit.lowercase"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointNameEditor.this._nameField.setText(PointNameEditor.this._nameField.getText().toLowerCase());
                PointNameEditor.this._okButton.setEnabled(true);
                PointNameEditor.this._nameField.requestFocus();
            }
        });
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(I18nManager.getText("dialog.pointnameedit.titlecase"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointNameEditor.this._nameField.setText(PointNameEditor.titleCase(PointNameEditor.this._nameField.getText()));
                PointNameEditor.this._okButton.setEnabled(true);
                PointNameEditor.this._nameField.requestFocus();
            }
        });
        jPanel4.add(jButton3);
        jPanel.add((Component)jPanel4, "East");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        JButton jButton4 = new JButton(I18nManager.getText("button.cancel"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointNameEditor.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton4);
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(actionListener);
        jPanel5.add(this._okButton);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void resetDialog(String string) {
        this._nameField.setText(string);
        this._okButton.setEnabled(false);
    }

    private static String titleCase(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 32;
        int n2 = 32;
        int n3 = 0;
        while (n3 < string.length()) {
            n2 = string.charAt(n3);
            stringBuffer.append(n == 32 ? Character.toUpperCase((char)n2) : Character.toLowerCase((char)n2));
            n = n2;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void confirmEdit() {
        if (this.hasNameChanged()) {
            FieldEditList fieldEditList = new FieldEditList();
            FieldEditList fieldEditList2 = new FieldEditList();
            fieldEditList.addEdit(new FieldEdit(Field.WAYPT_NAME, this._nameField.getText().trim()));
            fieldEditList2.addEdit(new FieldEdit(Field.WAYPT_NAME, this._point.getWaypointName()));
            this._app.completePointEdit(fieldEditList, fieldEditList2);
        }
    }

    private boolean hasNameChanged() {
        boolean bl;
        String string = this._point.getWaypointName();
        String string2 = this._nameField.getText().trim();
        boolean bl2 = string == null || string.equals("");
        boolean bl3 = bl = string2 == null || string2.equals("");
        return bl2 && !bl || !bl2 && bl || !bl2 && !bl && !string.equals(string2);
    }
}

