/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class AlbersEqualArea
extends AbstractProj {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-6;
    private double n;
    private double c;
    private double rho0;
    private double ec;

    @Override
    public String getName() {
        return I18n.tr("Albers Equal Area", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "aea";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        double phi2;
        super.initialize(params);
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        if (params.lat1 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_1"));
        }
        double lat0 = Utils.toRadians(params.lat0);
        double phi1 = Utils.toRadians(params.lat1);
        double d = phi2 = params.lat2 == null ? phi1 : Utils.toRadians(params.lat2);
        if (Math.abs(phi1 + phi2) < 1.0E-6) {
            throw new ProjectionConfigurationException(I18n.tr("standard parallels are opposite", new Object[0]));
        }
        double sinphi = Math.sin(phi1);
        double cosphi = Math.cos(phi1);
        double n = sinphi;
        boolean secant = Math.abs(phi1 - phi2) >= 1.0E-6;
        double m1 = this.msfn(sinphi, cosphi);
        double q1 = this.qsfn(sinphi);
        if (secant) {
            sinphi = Math.sin(phi2);
            cosphi = Math.cos(phi2);
            double m2 = this.msfn(sinphi, cosphi);
            double q2 = this.qsfn(sinphi);
            n = (m1 * m1 - m2 * m2) / (q2 - q1);
        }
        this.c = m1 * m1 + n * q1;
        this.rho0 = Math.sqrt(this.c - n * this.qsfn(Math.sin(lat0))) / n;
        this.ec = 1.0 - 0.5 * (1.0 - this.e2) * Math.log((1.0 - this.e) / (1.0 + this.e)) / this.e;
        this.n = n;
    }

    @Override
    public double[] project(double y, double x) {
        x *= this.n;
        double rho = this.c - this.n * this.qsfn(Math.sin(y));
        if (rho < 0.0) {
            if (rho > -1.0E-6) {
                rho = 0.0;
            } else {
                throw new AssertionError();
            }
        }
        rho = Math.sqrt(rho) / this.n;
        y = this.rho0 - rho * Math.cos(x);
        x = rho * Math.sin(x);
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        double rho = Math.hypot(x, y = this.rho0 - y);
        if (rho > 1.0E-6) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            x = Math.atan2(x, y) / this.n;
            y = rho * this.n;
            y = Math.abs(y = (this.c - y * y) / this.n) <= this.ec ? this.phi1(y) : (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
        } else {
            x = 0.0;
            y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return new double[]{y, x};
    }

    public double phi1(double qs) {
        double toneEs = 1.0 - this.e2;
        double phi = Math.asin(0.5 * qs);
        if (this.e < 1.0E-6) {
            return phi;
        }
        for (int i = 0; i < 15; ++i) {
            double sinpi = Math.sin(phi);
            double cospi = Math.cos(phi);
            double con = this.e * sinpi;
            double com = 1.0 - con * con;
            double dphi = 0.5 * com * com / cospi * (qs / toneEs - sinpi / com + 0.5 / this.e * Math.log((1.0 - con) / (1.0 + con)));
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new IllegalStateException("no convergence for qs=" + qs);
    }

    private double qsfn(double sinphi) {
        double oneEs = 1.0 - this.e2;
        if (this.e >= 1.0E-6) {
            double con = this.e * sinphi;
            return oneEs * (sinphi / (1.0 - con * con) - 0.5 / this.e * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -180.0, 89.0, 180.0, false);
    }
}

