/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.history.NodeListTableColumnModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListViewer
extends JPanel {
    private transient HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private transient AdjustmentSynchronizer adjustmentSynchronizer;
    private transient SelectionSynchronizer selectionSynchronizer;
    private NodeListPopupMenu popupMenu;

    public NodeListViewer(HistoryBrowserModel model) {
        this.setModel(model);
        this.build();
    }

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(pane.getVerticalScrollBar());
        return pane;
    }

    protected JTable buildReferenceNodeListTable() {
        DiffTableModel tableModel = this.model.getNodeListTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
        NodeListTableColumnModel columnModel = new NodeListTableColumnModel();
        JTable table = new JTable(tableModel, columnModel);
        tableModel.addTableModelListener(new ReversedChangeListener(table, columnModel));
        table.setName("table.referencenodelisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.addMouseListener(new InternalPopupMenuLauncher());
        table.addMouseListener(new DoubleClickAdapter(table));
        return table;
    }

    protected JTable buildCurrentNodeListTable() {
        DiffTableModel tableModel = this.model.getNodeListTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
        NodeListTableColumnModel columnModel = new NodeListTableColumnModel();
        JTable table = new JTable(tableModel, columnModel);
        tableModel.addTableModelListener(new ReversedChangeListener(table, columnModel));
        table.setName("table.currentnodelisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.addMouseListener(new InternalPopupMenuLauncher());
        table.addMouseListener(new DoubleClickAdapter(table));
        return table;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 0);
        gc.fill = 2;
        gc.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gc);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        this.popupMenu = new NodeListPopupMenu();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildReferenceNodeListTable()), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildCurrentNodeListTable()), gc);
    }

    protected void unregisterAsChangeListener(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.removeChangeListener(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.removeChangeListener(this.referenceInfoPanel);
        }
    }

    protected void registerAsChangeListener(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.addChangeListener(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.addChangeListener(this.referenceInfoPanel);
        }
    }

    public void setModel(HistoryBrowserModel model) {
        if (this.model != null) {
            this.unregisterAsChangeListener(model);
        }
        this.model = model;
        if (this.model != null) {
            this.registerAsChangeListener(model);
        }
    }

    private static PrimitiveId primitiveIdAtRow(DiffTableModel model, int row) {
        Long id = (Long)model.getValueAt((int)row, (int)0).value;
        return id == null ? null : new SimplePrimitiveId(id, OsmPrimitiveType.NODE);
    }

    static class DoubleClickAdapter
    extends MouseAdapter {
        private final JTable table;
        private final ShowHistoryAction showHistoryAction;

        DoubleClickAdapter(JTable table) {
            this.table = table;
            this.showHistoryAction = new ShowHistoryAction();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            int row = this.table.rowAtPoint(e.getPoint());
            if (row <= 0) {
                return;
            }
            PrimitiveId pid = NodeListViewer.primitiveIdAtRow((DiffTableModel)this.table.getModel(), row);
            if (pid == null || pid.isNew()) {
                return;
            }
            this.showHistoryAction.setPrimitiveId(pid);
            this.showHistoryAction.run();
        }
    }

    class InternalPopupMenuLauncher
    extends PopupMenuLauncher {
        InternalPopupMenuLauncher() {
            super(NodeListViewer.this.popupMenu);
        }

        @Override
        protected int checkTableSelection(JTable table, Point p) {
            int row = super.checkTableSelection(table, p);
            NodeListViewer.this.popupMenu.prepare(NodeListViewer.primitiveIdAtRow((DiffTableModel)table.getModel(), row));
            return row;
        }
    }

    static class ShowHistoryAction
    extends AbstractAction {
        private transient PrimitiveId primitiveId;

        ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a history browser with the history of this node", new Object[0]));
            new ImageProvider("dialogs", "history").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this.run();
            }
        }

        public void setPrimitiveId(PrimitiveId pid) {
            this.primitiveId = pid;
            this.updateEnabledState();
        }

        public void run() {
            if (HistoryDataSet.getInstance().getHistory(this.primitiveId) == null) {
                MainApplication.worker.submit(new HistoryLoadTask().add(this.primitiveId));
            }
            MainApplication.worker.submit(() -> {
                History h = HistoryDataSet.getInstance().getHistory(this.primitiveId);
                if (h == null) {
                    return;
                }
                GuiHelper.runInEDT(() -> HistoryBrowserDialogManager.getInstance().show(h));
            });
        }

        public void updateEnabledState() {
            this.setEnabled(this.primitiveId != null && !this.primitiveId.isNew());
        }
    }

    static class ZoomToNodeAction
    extends AbstractAction {
        private transient PrimitiveId primitiveId;

        ZoomToNodeAction() {
            this.putValue("Name", I18n.tr("Zoom to node", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to this node in the current data layer", new Object[0]));
            new ImageProvider("dialogs", "zoomin").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OsmDataLayer editLayer;
            if (!this.isEnabled()) {
                return;
            }
            OsmPrimitive p = this.getPrimitiveToZoom();
            if (p != null && (editLayer = MainApplication.getLayerManager().getEditLayer()) != null) {
                editLayer.data.setSelected(p.getPrimitiveId());
                AutoScaleAction.autoScale("selection");
            }
        }

        public void setPrimitiveId(PrimitiveId pid) {
            this.primitiveId = pid;
            this.updateEnabledState();
        }

        protected OsmPrimitive getPrimitiveToZoom() {
            if (this.primitiveId == null) {
                return null;
            }
            OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
            if (editLayer == null) {
                return null;
            }
            return editLayer.data.getPrimitiveById(this.primitiveId);
        }

        public void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getEditLayer() != null && this.getPrimitiveToZoom() != null);
        }
    }

    static class NodeListPopupMenu
    extends JPopupMenu {
        private final ZoomToNodeAction zoomToNodeAction = new ZoomToNodeAction();
        private final ShowHistoryAction showHistoryAction;

        NodeListPopupMenu() {
            this.add(this.zoomToNodeAction);
            this.showHistoryAction = new ShowHistoryAction();
            this.add(this.showHistoryAction);
        }

        public void prepare(PrimitiveId pid) {
            this.zoomToNodeAction.setPrimitiveId(pid);
            this.zoomToNodeAction.updateEnabledState();
            this.showHistoryAction.setPrimitiveId(pid);
            this.showHistoryAction.updateEnabledState();
        }
    }

    static final class ReversedChangeListener
    implements TableModelListener {
        private final NodeListTableColumnModel columnModel;
        private final JTable table;
        private Boolean reversed;
        private final String nonReversedText;
        private final String reversedText;

        ReversedChangeListener(JTable table, NodeListTableColumnModel columnModel) {
            this.columnModel = columnModel;
            this.table = table;
            this.nonReversedText = I18n.tr("Nodes", new Object[0]) + (table.getFont().canDisplay('\u25bc') ? " \u25bc" : " (1-n)");
            this.reversedText = I18n.tr("Nodes", new Object[0]) + (table.getFont().canDisplay('\u25b2') ? " \u25b2" : " (n-1)");
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getSource() instanceof DiffTableModel) {
                DiffTableModel mod = (DiffTableModel)e.getSource();
                if (this.reversed == null || this.reversed.booleanValue() != mod.isReversed()) {
                    this.reversed = mod.isReversed();
                    this.columnModel.getColumn(0).setHeaderValue(this.reversed != false ? this.reversedText : this.nonReversedText);
                    this.table.getTableHeader().setToolTipText(this.reversed != false ? I18n.tr("The nodes of this way are in reverse order", new Object[0]) : null);
                    this.table.getTableHeader().repaint();
                }
            }
        }
    }
}

