/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuffer;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.IOBase;
import org.python.core.io.RawIOBase;

public abstract class TextIOBase
extends IOBase {
    public static final int CHUNK_SIZE = 300;
    protected static final byte CR_BYTE = 13;
    protected BufferedIOBase bufferedIO;
    protected ByteBuffer readahead;
    protected StringBuilder builder;
    protected char[] interimBuilder;

    public TextIOBase(BufferedIOBase bufferedIO) {
        this.bufferedIO = bufferedIO;
        this.readahead = ByteBuffer.allocate(300);
        this.readahead.flip();
        this.builder = new StringBuilder(300);
        this.interimBuilder = new char[300];
    }

    public String read(int size) {
        this.unsupported("read");
        return null;
    }

    public String readall() {
        this.unsupported("readall");
        return null;
    }

    public String readline(int size) {
        this.unsupported("read");
        return null;
    }

    public int readinto(PyObject buf) {
        if (buf instanceof PyArray) {
            PyArray array = (PyArray)buf;
            String read = this.read(array.__len__());
            for (int i = 0; i < read.length(); ++i) {
                array.set(i, new PyString(read.charAt(i)));
            }
            return read.length();
        }
        if (buf instanceof BufferProtocol) {
            try (PyBuffer view = ((BufferProtocol)((Object)buf)).getBuffer(284);){
                if (view.isReadonly()) {
                    throw Py.TypeError("cannot read into read-only " + buf.getType().fastGetName());
                }
                String read = this.read(view.getLen());
                int n = read.length();
                for (int i = 0; i < n; ++i) {
                    view.storeAt((byte)read.charAt(i), i);
                }
                int n2 = read.length();
                return n2;
            }
        }
        throw Py.TypeError("argument 1 must be read-write buffer, not " + buf.getType().fastGetName());
    }

    public int write(String buf) {
        this.unsupported("write");
        return -1;
    }

    @Override
    public long truncate(long pos) {
        long initialPos = this.tell();
        this.flush();
        pos = this.bufferedIO.truncate(pos);
        if (initialPos > pos) {
            this.seek(initialPos);
        }
        return pos;
    }

    @Override
    public void flush() {
        this.bufferedIO.flush();
    }

    @Override
    public void close() {
        this.bufferedIO.close();
    }

    @Override
    public long seek(long pos, int whence) {
        pos = this.bufferedIO.seek(pos, whence);
        this.clearReadahead();
        return pos;
    }

    @Override
    public long tell() {
        return this.bufferedIO.tell() - (long)this.readahead.remaining();
    }

    @Override
    public RawIOBase fileno() {
        return this.bufferedIO.fileno();
    }

    @Override
    public boolean isatty() {
        return this.bufferedIO.isatty();
    }

    @Override
    public boolean readable() {
        return this.bufferedIO.readable();
    }

    @Override
    public boolean writable() {
        return this.bufferedIO.writable();
    }

    @Override
    public boolean closed() {
        return this.bufferedIO.closed();
    }

    @Override
    public InputStream asInputStream() {
        return this.bufferedIO.asInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return this.bufferedIO.asOutputStream();
    }

    public PyObject getNewlines() {
        return Py.None;
    }

    protected boolean atEOF() {
        return this.readahead.hasRemaining() ? false : this.readChunk() == 0;
    }

    protected int readChunk() {
        this.readahead.clear();
        if (this.readahead.remaining() > 300) {
            this.readahead.limit(this.readahead.position() + 300);
        }
        this.bufferedIO.read1(this.readahead);
        this.readahead.flip();
        return this.readahead.remaining();
    }

    protected int readChunk(int size) {
        if (size > 300) {
            this.readahead = ByteBuffer.allocate(size);
        } else {
            size = 300;
            this.readahead.clear().limit(size);
        }
        this.bufferedIO.readinto(this.readahead);
        this.readahead.flip();
        return this.readahead.remaining();
    }

    protected void packReadahead() {
        if (this.readahead.capacity() > 300) {
            ByteBuffer old = this.readahead;
            this.readahead = ByteBuffer.allocate(300);
            this.readahead.put(old);
            this.readahead.flip();
        }
    }

    protected void clearReadahead() {
        this.readahead.clear().flip();
    }

    protected String drainBuilder() {
        String result = this.builder.toString();
        if (this.builder.capacity() > 300) {
            this.builder = new StringBuilder(300);
        } else {
            this.builder.setLength(0);
        }
        return result;
    }
}

