/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    @NotNull
    private final KotlinType type;
    private final KotlinBuiltIns builtIns;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(other.getClass(), this.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)((List)this.getValue()), (Object)((List)((ArrayValue)other).getValue()));
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull KotlinType type2, @NotNull KotlinBuiltIns builtIns) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        super(value);
        this.type = type2;
        this.builtIns = builtIns;
        boolean bl2 = bl = KotlinBuiltIns.isArray(this.getType()) || KotlinBuiltIns.isPrimitiveArray(this.getType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Type should be an array, but was " + this.getType() + ": " + value;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

