/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class ReadAction<T>
extends BaseActionRunnable<T> {
    public static AccessToken start() {
        return ApplicationManager.getApplication().acquireReadActionLock();
    }

    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/ReadAction", "run"));
        }
        AccessToken token = ReadAction.start();
        try {
            action.run();
        }
        finally {
            token.finish();
        }
    }

    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/ReadAction", "compute"));
        }
        AccessToken token = ReadAction.start();
        try {
            T t = action.compute();
            return t;
        }
        finally {
            token.finish();
        }
    }
}

