/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet((short)Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return false;
        }
    };
    public static final TokenSet ANY = new TokenSet((short)Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return true;
        }
    };
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
    }

    private boolean get(int index2) {
        int wordIndex = (index2 >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index2) != 0L;
    }

    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i);
    }

    @NotNull
    public IElementType[] getTypes() {
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list2 = new ArrayList<IElementType>();
                for (short i = (short)Math.max(1, this.myShift << 6); i <= this.myMax; i = (short)(i + 1)) {
                    IElementType type2;
                    if (!this.get(i) || (type2 = IElementType.find(i)) == null) continue;
                    list2.add(type2);
                }
                types = list2.toArray(new IElementType[list2.size()]);
            }
            this.myTypes = types;
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "getTypes"));
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        short s;
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/tree/TokenSet", "create"));
        }
        if (types.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "create"));
            }
            return tokenSet;
        }
        int n = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type2 : types) {
            if (type2 == null) continue;
            short index2 = type2.getIndex();
            assert (index2 >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass(type2);
            if (s > index2) {
                s = index2;
            }
            if (max >= index2) continue;
            max = index2;
        }
        short shift = (short)(s >> 6);
        TokenSet set = new TokenSet(shift, max);
        for (IElementType type3 : types) {
            int wordIndex;
            if (type3 == null) continue;
            short index3 = type3.getIndex();
            int n2 = wordIndex = (index3 >> 6) - shift;
            set.myWords[n2] = set.myWords[n2] | 1L << index3;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "create"));
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sets", "com/intellij/psi/tree/TokenSet", "orSet"));
        }
        if (sets.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "orSet"));
            }
            return tokenSet;
        }
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i = 1; i < sets.length; ++i) {
            if (shift > sets[i].myShift) {
                shift = sets[i].myShift;
            }
            if (max >= sets[i].myMax) continue;
            max = sets[i].myMax;
        }
        TokenSet newSet = new TokenSet(shift, max);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i = 0; i < set.myWords.length; ++i) {
                int n = i + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i];
            }
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "orSet"));
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/psi/tree/TokenSet", "andSet"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/psi/tree/TokenSet", "andSet"));
        }
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "andSet"));
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/psi/tree/TokenSet", "andNot"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/psi/tree/TokenSet", "andNot"));
        }
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "andNot"));
        }
        return tokenSet;
    }
}

