/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Objects;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Element;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;

class Indexer
extends DefaultBindingTargetVisitor<Object, IndexedBinding>
implements BindingScopingVisitor<Object> {
    final Injector injector;
    private static final Object EAGER_SINGLETON = new Object();

    Indexer(Injector injector) {
        this.injector = injector;
    }

    boolean isIndexable(Binding<?> binding) {
        return binding.getKey().getAnnotation() instanceof Element;
    }

    private Object scope(Binding<?> binding) {
        return binding.acceptScopingVisitor((BindingScopingVisitor)this);
    }

    public IndexedBinding visit(ConstructorBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.CONSTRUCTOR, this.scope((Binding<?>)binding), binding.getConstructor());
    }

    public IndexedBinding visit(ConvertedConstantBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.CONSTANT, this.scope((Binding<?>)binding), binding.getValue());
    }

    public IndexedBinding visit(ExposedBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.EXPOSED, this.scope((Binding<?>)binding), binding);
    }

    public IndexedBinding visit(InstanceBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.INSTANCE, this.scope((Binding<?>)binding), binding.getInstance());
    }

    public IndexedBinding visit(LinkedKeyBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.LINKED_KEY, this.scope((Binding<?>)binding), binding.getLinkedKey());
    }

    public IndexedBinding visit(ProviderBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.PROVIDED_BY, this.scope((Binding<?>)binding), this.injector.getBinding(binding.getProvidedKey()));
    }

    public IndexedBinding visit(ProviderInstanceBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.PROVIDER_INSTANCE, this.scope((Binding<?>)binding), binding.getUserSuppliedProvider());
    }

    public IndexedBinding visit(ProviderKeyBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.PROVIDER_KEY, this.scope((Binding<?>)binding), binding.getProviderKey());
    }

    public IndexedBinding visit(UntargettedBinding<? extends Object> binding) {
        return new IndexedBinding((Binding<?>)binding, BindingType.UNTARGETTED, this.scope((Binding<?>)binding), null);
    }

    public Object visitEagerSingleton() {
        return EAGER_SINGLETON;
    }

    public Object visitNoScoping() {
        return Scopes.NO_SCOPE;
    }

    public Object visitScope(Scope scope) {
        return scope;
    }

    public Object visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
        return scopeAnnotation;
    }

    static class IndexedBinding {
        final String annotationName;
        final Element.Type annotationType;
        final TypeLiteral<?> typeLiteral;
        final Object scope;
        final BindingType type;
        final Object extraEquality;

        IndexedBinding(Binding<?> binding, BindingType type, Object scope, Object extraEquality) {
            this.scope = scope;
            this.type = type;
            this.extraEquality = extraEquality;
            this.typeLiteral = binding.getKey().getTypeLiteral();
            Element annotation = (Element)binding.getKey().getAnnotation();
            this.annotationName = annotation.setName();
            this.annotationType = annotation.type();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexedBinding)) {
                return false;
            }
            IndexedBinding o = (IndexedBinding)obj;
            return this.type == o.type && Objects.equal((Object)this.scope, (Object)o.scope) && this.typeLiteral.equals(o.typeLiteral) && this.annotationType == o.annotationType && this.annotationName.equals(o.annotationName) && Objects.equal((Object)this.extraEquality, (Object)o.extraEquality);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.scope, this.typeLiteral, this.annotationType, this.annotationName, this.extraEquality});
        }
    }

    static enum BindingType {
        INSTANCE,
        PROVIDER_INSTANCE,
        PROVIDER_KEY,
        LINKED_KEY,
        UNTARGETTED,
        CONSTRUCTOR,
        CONSTANT,
        EXPOSED,
        PROVIDED_BY;

    }
}

