/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Glacier2;

import com.zeroc.Glacier2.CannotCreateSessionException;
import com.zeroc.Glacier2.PermissionDeniedException;
import com.zeroc.Glacier2.RouterPrx;
import com.zeroc.Glacier2.SessionCallback;
import com.zeroc.Glacier2.SessionNotExistException;
import com.zeroc.Glacier2.SessionPrx;
import com.zeroc.Ice.ACMHeartbeat;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.Connection;
import com.zeroc.Ice.ConnectionLostException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.InitializationException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.RouterFinderPrx;
import com.zeroc.Ice.Util;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.Semaphore;

public class SessionHelper {
    private final InitializationData _initData;
    private Communicator _communicator;
    private ObjectAdapter _adapter;
    private RouterPrx _router;
    private SessionPrx _session;
    private String _category;
    private String _finderStr;
    private boolean _useCallbacks;
    private final SessionCallback _callback;
    private boolean _destroy = false;
    private boolean _connected = false;
    private Thread _shutdownHook;

    SessionHelper(SessionCallback callback, InitializationData initData, String finderStr, boolean useCallbacks) {
        this._callback = callback;
        this._initData = initData;
        this._finderStr = finderStr;
        this._useCallbacks = useCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        SessionHelper sessionHelper = this;
        synchronized (sessionHelper) {
            if (this._destroy) {
                return;
            }
            this._destroy = true;
            if (!this._connected) {
                new Thread(() -> this.destroyCommunicator()).start();
                return;
            }
            this._session = null;
            this._connected = false;
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        new Thread(() -> this.destroyInternal()).start();
    }

    public synchronized Communicator communicator() {
        return this._communicator;
    }

    public synchronized String categoryForClient() throws SessionNotExistException {
        if (this._router == null) {
            throw new SessionNotExistException();
        }
        return this._category;
    }

    public synchronized ObjectPrx addWithUUID(Object servant) throws SessionNotExistException {
        if (this._router == null) {
            throw new SessionNotExistException();
        }
        return this.internalObjectAdapter().add(servant, new Identity(UUID.randomUUID().toString(), this._category));
    }

    public synchronized SessionPrx session() {
        return this._session;
    }

    public synchronized boolean isConnected() {
        return this._connected;
    }

    public synchronized ObjectAdapter objectAdapter() throws SessionNotExistException {
        return this.internalObjectAdapter();
    }

    private ObjectAdapter internalObjectAdapter() throws SessionNotExistException {
        if (this._router == null) {
            throw new SessionNotExistException();
        }
        if (!this._useCallbacks) {
            throw new InitializationException("Object adapter not available, call SessionFactoryHelper.setUseCallbacks(true)");
        }
        return this._adapter;
    }

    protected synchronized void connect(final Map<String, String> context) {
        this.connectImpl(new ConnectStrategy(){

            @Override
            public SessionPrx connect(RouterPrx router) throws CannotCreateSessionException, PermissionDeniedException {
                return router.createSessionFromSecureConnection(context);
            }
        });
    }

    protected synchronized void connect(final String username, final String password, final Map<String, String> context) {
        this.connectImpl(new ConnectStrategy(){

            @Override
            public SessionPrx connect(RouterPrx router) throws CannotCreateSessionException, PermissionDeniedException {
                return router.createSession(username, password, context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(RouterPrx router, SessionPrx session) {
        assert (router != null);
        Connection conn = router.ice_getCachedConnection();
        String category = router.getCategoryForClient();
        int acmTimeout = 0;
        try {
            acmTimeout = router.getACMTimeout();
        }
        catch (OperationNotExistException operationNotExistException) {
            // empty catch block
        }
        if (acmTimeout <= 0) {
            acmTimeout = (int)router.getSessionTimeout();
        }
        if (this._useCallbacks) {
            assert (this._adapter == null);
            this._adapter = this._communicator.createObjectAdapterWithRouter("", router);
            this._adapter.activate();
        }
        SessionHelper sessionHelper = this;
        synchronized (sessionHelper) {
            this._router = router;
            if (this._destroy) {
                new Thread(() -> this.destroyInternal()).start();
                return;
            }
            this._category = category;
            this._session = session;
            this._connected = true;
            if (acmTimeout > 0) {
                Connection connection = this._router.ice_getCachedConnection();
                assert (connection != null);
                connection.setACM(OptionalInt.of(acmTimeout), null, Optional.of(ACMHeartbeat.HeartbeatAlways));
                connection.setCloseCallback(con -> this.destroy());
            }
            this._shutdownHook = new Thread("Shutdown hook"){

                @Override
                public void run() {
                    SessionHelper.this.destroy();
                }
            };
            try {
                Runtime.getRuntime().addShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.dispatchCallback(() -> {
            try {
                this._callback.connected(this);
            }
            catch (SessionNotExistException ex) {
                this.destroy();
            }
        }, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInternal() {
        assert (this._destroy);
        RouterPrx router = null;
        Communicator communicator = null;
        SessionHelper sessionHelper = this;
        synchronized (sessionHelper) {
            if (this._router == null) {
                return;
            }
            router = this._router;
            this._router = null;
            communicator = this._communicator;
        }
        assert (communicator != null);
        try {
            router.destroySession();
        }
        catch (ConnectionLostException connectionLostException) {
        }
        catch (SessionNotExistException sessionNotExistException) {
        }
        catch (Throwable e) {
            communicator.getLogger().warning("SessionHelper: unexpected exception when destroying the session:\n" + e);
        }
        communicator.destroy();
        this.dispatchCallback(() -> this._callback.disconnected(this), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCommunicator() {
        Communicator communicator = null;
        SessionHelper sessionHelper = this;
        synchronized (sessionHelper) {
            communicator = this._communicator;
        }
        if (communicator != null) {
            this._communicator.destroy();
        }
    }

    private void connectImpl(ConnectStrategy factory) {
        assert (!this._destroy);
        try {
            this._communicator = Util.initialize(this._initData);
        }
        catch (LocalException ex) {
            this._destroy = true;
            new Thread(() -> this.dispatchCallback(() -> this._callback.connectFailed(this, ex), null)).start();
            return;
        }
        RouterFinderPrx finder = RouterFinderPrx.uncheckedCast(this._communicator.stringToProxy(this._finderStr));
        new Thread(() -> {
            if (this._communicator.getDefaultRouter() == null) {
                try {
                    this._communicator.setDefaultRouter(finder.getRouter());
                }
                catch (CommunicatorDestroyedException ex) {
                    this.dispatchCallback(() -> this._callback.connectFailed(this, ex), null);
                    return;
                }
                catch (Exception ex) {
                    Identity ident = new Identity("router", "Glacier2");
                    this._communicator.setDefaultRouter(com.zeroc.Ice.RouterPrx.uncheckedCast(finder.ice_identity(ident)));
                }
            }
            try {
                this.dispatchCallbackAndWait(() -> this._callback.createdCommunicator(this));
                RouterPrx routerPrx = RouterPrx.uncheckedCast(this._communicator.getDefaultRouter());
                SessionPrx session = factory.connect(routerPrx);
                this.connected(routerPrx, session);
            }
            catch (Exception ex) {
                this._communicator.destroy();
                this.dispatchCallback(() -> this._callback.connectFailed(this, ex), null);
            }
        }).start();
    }

    private void dispatchCallback(Runnable runnable, Connection conn) {
        if (this._initData.dispatcher != null) {
            this._initData.dispatcher.accept(runnable, conn);
        } else {
            runnable.run();
        }
    }

    private void dispatchCallbackAndWait(Runnable runnable) {
        if (this._initData.dispatcher != null) {
            Semaphore sem = new Semaphore(0);
            this._initData.dispatcher.accept(() -> {
                runnable.run();
                sem.release();
            }, null);
            sem.acquireUninterruptibly();
        } else {
            runnable.run();
        }
    }

    private static interface ConnectStrategy {
        public SessionPrx connect(RouterPrx var1) throws CannotCreateSessionException, PermissionDeniedException;
    }
}

