/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AllocationException;
import com.zeroc.IceGrid.ObjectNotRegisteredException;
import com.zeroc.IceGrid._SessionPrxI;
import com.zeroc.IceInternal.OutgoingAsync;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface SessionPrx
extends com.zeroc.Glacier2.SessionPrx {
    public static final Class<?>[] _iceE_allocateObjectById = new Class[]{AllocationException.class, ObjectNotRegisteredException.class};
    public static final Class<?>[] _iceE_allocateObjectByType = new Class[]{AllocationException.class};
    public static final Class<?>[] _iceE_releaseObject = new Class[]{AllocationException.class, ObjectNotRegisteredException.class};

    default public void keepAlive() {
        this.keepAlive(ObjectPrx.noExplicitContext);
    }

    default public void keepAlive(Map<String, String> context) {
        this._iceI_keepAliveAsync(context, true).waitForResponse();
    }

    default public CompletableFuture<Void> keepAliveAsync() {
        return this._iceI_keepAliveAsync(ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> keepAliveAsync(Map<String, String> context) {
        return this._iceI_keepAliveAsync(context, false);
    }

    default public OutgoingAsync<Void> _iceI_keepAliveAsync(Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "keepAlive", OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    default public ObjectPrx allocateObjectById(Identity id) throws AllocationException, ObjectNotRegisteredException {
        return this.allocateObjectById(id, ObjectPrx.noExplicitContext);
    }

    default public ObjectPrx allocateObjectById(Identity id, Map<String, String> context) throws AllocationException, ObjectNotRegisteredException {
        try {
            return this._iceI_allocateObjectByIdAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch (AllocationException ex) {
            throw ex;
        }
        catch (ObjectNotRegisteredException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByIdAsync(Identity id) {
        return this._iceI_allocateObjectByIdAsync(id, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByIdAsync(Identity id, Map<String, String> context) {
        return this._iceI_allocateObjectByIdAsync(id, context, false);
    }

    default public OutgoingAsync<ObjectPrx> _iceI_allocateObjectByIdAsync(Identity iceP_id, Map<String, String> context, boolean sync) {
        OutgoingAsync<ObjectPrx> f = new OutgoingAsync<ObjectPrx>(this, "allocateObjectById", null, sync, _iceE_allocateObjectById);
        f.invoke(true, context, null, ostr -> Identity.ice_write(ostr, iceP_id), istr -> {
            ObjectPrx ret = istr.readProxy();
            return ret;
        });
        return f;
    }

    default public ObjectPrx allocateObjectByType(String type) throws AllocationException {
        return this.allocateObjectByType(type, ObjectPrx.noExplicitContext);
    }

    default public ObjectPrx allocateObjectByType(String type, Map<String, String> context) throws AllocationException {
        try {
            return this._iceI_allocateObjectByTypeAsync(type, context, true).waitForResponseOrUserEx();
        }
        catch (AllocationException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByTypeAsync(String type) {
        return this._iceI_allocateObjectByTypeAsync(type, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByTypeAsync(String type, Map<String, String> context) {
        return this._iceI_allocateObjectByTypeAsync(type, context, false);
    }

    default public OutgoingAsync<ObjectPrx> _iceI_allocateObjectByTypeAsync(String iceP_type, Map<String, String> context, boolean sync) {
        OutgoingAsync<ObjectPrx> f = new OutgoingAsync<ObjectPrx>(this, "allocateObjectByType", null, sync, _iceE_allocateObjectByType);
        f.invoke(true, context, null, ostr -> ostr.writeString(iceP_type), istr -> {
            ObjectPrx ret = istr.readProxy();
            return ret;
        });
        return f;
    }

    default public void releaseObject(Identity id) throws AllocationException, ObjectNotRegisteredException {
        this.releaseObject(id, ObjectPrx.noExplicitContext);
    }

    default public void releaseObject(Identity id, Map<String, String> context) throws AllocationException, ObjectNotRegisteredException {
        try {
            this._iceI_releaseObjectAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch (AllocationException ex) {
            throw ex;
        }
        catch (ObjectNotRegisteredException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    default public CompletableFuture<Void> releaseObjectAsync(Identity id) {
        return this._iceI_releaseObjectAsync(id, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> releaseObjectAsync(Identity id, Map<String, String> context) {
        return this._iceI_releaseObjectAsync(id, context, false);
    }

    default public OutgoingAsync<Void> _iceI_releaseObjectAsync(Identity iceP_id, Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "releaseObject", null, sync, _iceE_releaseObject);
        f.invoke(true, context, null, ostr -> Identity.ice_write(ostr, iceP_id), null);
        return f;
    }

    default public void setAllocationTimeout(int timeout) {
        this.setAllocationTimeout(timeout, ObjectPrx.noExplicitContext);
    }

    default public void setAllocationTimeout(int timeout, Map<String, String> context) {
        this._iceI_setAllocationTimeoutAsync(timeout, context, true).waitForResponse();
    }

    default public CompletableFuture<Void> setAllocationTimeoutAsync(int timeout) {
        return this._iceI_setAllocationTimeoutAsync(timeout, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> setAllocationTimeoutAsync(int timeout, Map<String, String> context) {
        return this._iceI_setAllocationTimeoutAsync(timeout, context, false);
    }

    default public OutgoingAsync<Void> _iceI_setAllocationTimeoutAsync(int iceP_timeout, Map<String, String> context, boolean sync) {
        OutgoingAsync<Void> f = new OutgoingAsync<Void>(this, "setAllocationTimeout", OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, ostr -> ostr.writeInt(iceP_timeout), null);
        return f;
    }

    public static SessionPrx checkedCast(ObjectPrx obj) {
        return ObjectPrx._checkedCast(obj, SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx checkedCast(ObjectPrx obj, Map<String, String> context) {
        return ObjectPrx._checkedCast(obj, context, SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx checkedCast(ObjectPrx obj, String facet) {
        return ObjectPrx._checkedCast(obj, facet, SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx checkedCast(ObjectPrx obj, String facet, Map<String, String> context) {
        return ObjectPrx._checkedCast(obj, facet, context, SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx uncheckedCast(ObjectPrx obj) {
        return ObjectPrx._uncheckedCast(obj, SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx uncheckedCast(ObjectPrx obj, String facet) {
        return ObjectPrx._uncheckedCast(obj, facet, SessionPrx.class, _SessionPrxI.class);
    }

    @Override
    default public SessionPrx ice_context(Map<String, String> newContext) {
        return (SessionPrx)this._ice_context(newContext);
    }

    @Override
    default public SessionPrx ice_adapterId(String newAdapterId) {
        return (SessionPrx)this._ice_adapterId(newAdapterId);
    }

    @Override
    default public SessionPrx ice_endpoints(Endpoint[] newEndpoints) {
        return (SessionPrx)this._ice_endpoints(newEndpoints);
    }

    @Override
    default public SessionPrx ice_locatorCacheTimeout(int newTimeout) {
        return (SessionPrx)this._ice_locatorCacheTimeout(newTimeout);
    }

    @Override
    default public SessionPrx ice_invocationTimeout(int newTimeout) {
        return (SessionPrx)this._ice_invocationTimeout(newTimeout);
    }

    @Override
    default public SessionPrx ice_connectionCached(boolean newCache) {
        return (SessionPrx)this._ice_connectionCached(newCache);
    }

    @Override
    default public SessionPrx ice_endpointSelection(EndpointSelectionType newType) {
        return (SessionPrx)this._ice_endpointSelection(newType);
    }

    @Override
    default public SessionPrx ice_secure(boolean b) {
        return (SessionPrx)this._ice_secure(b);
    }

    @Override
    default public SessionPrx ice_encodingVersion(EncodingVersion e) {
        return (SessionPrx)this._ice_encodingVersion(e);
    }

    @Override
    default public SessionPrx ice_preferSecure(boolean b) {
        return (SessionPrx)this._ice_preferSecure(b);
    }

    @Override
    default public SessionPrx ice_router(RouterPrx router) {
        return (SessionPrx)this._ice_router(router);
    }

    @Override
    default public SessionPrx ice_locator(LocatorPrx locator) {
        return (SessionPrx)this._ice_locator(locator);
    }

    @Override
    default public SessionPrx ice_collocationOptimized(boolean b) {
        return (SessionPrx)this._ice_collocationOptimized(b);
    }

    @Override
    default public SessionPrx ice_twoway() {
        return (SessionPrx)this._ice_twoway();
    }

    @Override
    default public SessionPrx ice_oneway() {
        return (SessionPrx)this._ice_oneway();
    }

    @Override
    default public SessionPrx ice_batchOneway() {
        return (SessionPrx)this._ice_batchOneway();
    }

    @Override
    default public SessionPrx ice_datagram() {
        return (SessionPrx)this._ice_datagram();
    }

    @Override
    default public SessionPrx ice_batchDatagram() {
        return (SessionPrx)this._ice_batchDatagram();
    }

    @Override
    default public SessionPrx ice_compress(boolean co) {
        return (SessionPrx)this._ice_compress(co);
    }

    @Override
    default public SessionPrx ice_timeout(int t) {
        return (SessionPrx)this._ice_timeout(t);
    }

    @Override
    default public SessionPrx ice_connectionId(String connectionId) {
        return (SessionPrx)this._ice_connectionId(connectionId);
    }

    public static String ice_staticId() {
        return "::IceGrid::Session";
    }
}

