// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IcePatch2;

/**
 * The interface that provides access to files.
 **/
public interface FileServerPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    @Deprecated
    default FileInfo[] getFileInfoSeq(int partition)
        throws FileSizeRangeException,
               PartitionOutOfRangeException
    {
        return getFileInfoSeq(partition, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    @Deprecated
    default FileInfo[] getFileInfoSeq(int partition, java.util.Map<String, String> context)
        throws FileSizeRangeException,
               PartitionOutOfRangeException
    {
        try
        {
            return _iceI_getFileInfoSeqAsync(partition, context, true).waitForResponseOrUserEx();
        }
        catch(FileSizeRangeException ex)
        {
            throw ex;
        }
        catch(PartitionOutOfRangeException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    @Deprecated
    default java.util.concurrent.CompletableFuture<FileInfo[]> getFileInfoSeqAsync(int partition)
    {
        return _iceI_getFileInfoSeqAsync(partition, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    @Deprecated
    default java.util.concurrent.CompletableFuture<FileInfo[]> getFileInfoSeqAsync(int partition, java.util.Map<String, String> context)
    {
        return _iceI_getFileInfoSeqAsync(partition, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<FileInfo[]> _iceI_getFileInfoSeqAsync(int iceP_partition, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileInfo[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getFileInfoSeq", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getFileInfoSeq);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeInt(iceP_partition);
                 }, istr -> {
                     FileInfo[] ret;
                     ret = FileInfoSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    static final Class<?>[] _iceE_getFileInfoSeq =
    {
        FileSizeRangeException.class,
        PartitionOutOfRangeException.class
    };

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     **/
    default LargeFileInfo[] getLargeFileInfoSeq(int partition)
        throws PartitionOutOfRangeException
    {
        return getLargeFileInfoSeq(partition, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     **/
    default LargeFileInfo[] getLargeFileInfoSeq(int partition, java.util.Map<String, String> context)
        throws PartitionOutOfRangeException
    {
        try
        {
            return _iceI_getLargeFileInfoSeqAsync(partition, context, true).waitForResponseOrUserEx();
        }
        catch(PartitionOutOfRangeException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @return A sequence containing information about the files in the
     * specified partition.
     **/
    default java.util.concurrent.CompletableFuture<LargeFileInfo[]> getLargeFileInfoSeqAsync(int partition)
    {
        return _iceI_getLargeFileInfoSeqAsync(partition, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Returns file information for the specified partition.
     * @param partition The partition number in the range 0-255.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     **/
    default java.util.concurrent.CompletableFuture<LargeFileInfo[]> getLargeFileInfoSeqAsync(int partition, java.util.Map<String, String> context)
    {
        return _iceI_getLargeFileInfoSeqAsync(partition, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<LargeFileInfo[]> _iceI_getLargeFileInfoSeqAsync(int iceP_partition, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<LargeFileInfo[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getLargeFileInfoSeq", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getLargeFileInfoSeq);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeInt(iceP_partition);
                 }, istr -> {
                     LargeFileInfo[] ret;
                     ret = LargeFileInfoSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    static final Class<?>[] _iceE_getLargeFileInfoSeq =
    {
        PartitionOutOfRangeException.class
    };

    /**
     * Return the checksums for all partitions.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     **/
    default byte[][] getChecksumSeq()
    {
        return getChecksumSeq(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     **/
    default byte[][] getChecksumSeq(java.util.Map<String, String> context)
    {
        return _iceI_getChecksumSeqAsync(context, true).waitForResponse();
    }

    /**
     * Return the checksums for all partitions.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     **/
    default java.util.concurrent.CompletableFuture<byte[][]> getChecksumSeqAsync()
    {
        return _iceI_getChecksumSeqAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Return the checksums for all partitions.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     **/
    default java.util.concurrent.CompletableFuture<byte[][]> getChecksumSeqAsync(java.util.Map<String, String> context)
    {
        return _iceI_getChecksumSeqAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<byte[][]> _iceI_getChecksumSeqAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<byte[][]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getChecksumSeq", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     byte[][] ret;
                     ret = ByteSeqSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @return The master checksum for the file set.
     **/
    default byte[] getChecksum()
    {
        return getChecksum(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @return The master checksum for the file set.
     **/
    default byte[] getChecksum(java.util.Map<String, String> context)
    {
        return _iceI_getChecksumAsync(context, true).waitForResponse();
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @return The master checksum for the file set.
     **/
    default java.util.concurrent.CompletableFuture<byte[]> getChecksumAsync()
    {
        return _iceI_getChecksumAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     * @param context The Context map to send with the invocation.
     * @return The master checksum for the file set.
     **/
    default java.util.concurrent.CompletableFuture<byte[]> getChecksumAsync(java.util.Map<String, String> context)
    {
        return _iceI_getChecksumAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<byte[]> _iceI_getChecksumAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<byte[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getChecksum", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     byte[] ret;
                     ret = istr.readByteSeq();
                     return ret;
                 });
        return f;
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @return A sequence containing the compressed file contents.
     * @throws FileAccessException If an error occurred while trying to read the file.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    @Deprecated
    default byte[] getFileCompressed(String path, int pos, int num)
        throws FileSizeRangeException,
               FileAccessException
    {
        return getFileCompressed(path, pos, num, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws FileAccessException If an error occurred while trying to read the file.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    @Deprecated
    default byte[] getFileCompressed(String path, int pos, int num, java.util.Map<String, String> context)
        throws FileSizeRangeException,
               FileAccessException
    {
        try
        {
            return _iceI_getFileCompressedAsync(path, pos, num, context, true).waitForResponseOrUserEx();
        }
        catch(FileSizeRangeException ex)
        {
            throw ex;
        }
        catch(FileAccessException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @return A sequence containing the compressed file contents.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    @Deprecated
    default java.util.concurrent.CompletableFuture<byte[]> getFileCompressedAsync(String path, int pos, int num)
    {
        return _iceI_getFileCompressedAsync(path, pos, num, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    @Deprecated
    default java.util.concurrent.CompletableFuture<byte[]> getFileCompressedAsync(String path, int pos, int num, java.util.Map<String, String> context)
    {
        return _iceI_getFileCompressedAsync(path, pos, num, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<byte[]> _iceI_getFileCompressedAsync(String iceP_path, int iceP_pos, int iceP_num, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<byte[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getFileCompressed", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getFileCompressed);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_path);
                     ostr.writeInt(iceP_pos);
                     ostr.writeInt(iceP_num);
                 }, istr -> {
                     byte[] ret;
                     ret = istr.readByteSeq();
                     return ret;
                 });
        return f;
    }

    static final Class<?>[] _iceE_getFileCompressed =
    {
        FileSizeRangeException.class,
        FileAccessException.class
    };

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @return A sequence containing the compressed file contents.
     * @throws FileAccessException If an error occurred while trying to read the file.
     **/
    default byte[] getLargeFileCompressed(String path, long pos, int num)
        throws FileAccessException
    {
        return getLargeFileCompressed(path, pos, num, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     * @throws FileAccessException If an error occurred while trying to read the file.
     **/
    default byte[] getLargeFileCompressed(String path, long pos, int num, java.util.Map<String, String> context)
        throws FileAccessException
    {
        try
        {
            return _iceI_getLargeFileCompressedAsync(path, pos, num, context, true).waitForResponseOrUserEx();
        }
        catch(FileAccessException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @return A sequence containing the compressed file contents.
     **/
    default java.util.concurrent.CompletableFuture<byte[]> getLargeFileCompressedAsync(String path, long pos, int num)
    {
        return _iceI_getLargeFileCompressedAsync(path, pos, num, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     * @param pos The file offset at which to begin reading.
     * @param num The number of bytes to be read.
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     **/
    default java.util.concurrent.CompletableFuture<byte[]> getLargeFileCompressedAsync(String path, long pos, int num, java.util.Map<String, String> context)
    {
        return _iceI_getLargeFileCompressedAsync(path, pos, num, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<byte[]> _iceI_getLargeFileCompressedAsync(String iceP_path, long iceP_pos, int iceP_num, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<byte[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getLargeFileCompressed", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getLargeFileCompressed);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_path);
                     ostr.writeLong(iceP_pos);
                     ostr.writeInt(iceP_num);
                 }, istr -> {
                     byte[] ret;
                     ret = istr.readByteSeq();
                     return ret;
                 });
        return f;
    }

    static final Class<?>[] _iceE_getLargeFileCompressed =
    {
        FileAccessException.class
    };

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileServerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), FileServerPrx.class, _FileServerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileServerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), FileServerPrx.class, _FileServerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileServerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), FileServerPrx.class, _FileServerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileServerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), FileServerPrx.class, _FileServerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static FileServerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, FileServerPrx.class, _FileServerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static FileServerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, FileServerPrx.class, _FileServerPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default FileServerPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (FileServerPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default FileServerPrx ice_adapterId(String newAdapterId)
    {
        return (FileServerPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default FileServerPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (FileServerPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default FileServerPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (FileServerPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default FileServerPrx ice_invocationTimeout(int newTimeout)
    {
        return (FileServerPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default FileServerPrx ice_connectionCached(boolean newCache)
    {
        return (FileServerPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default FileServerPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (FileServerPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default FileServerPrx ice_secure(boolean b)
    {
        return (FileServerPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default FileServerPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (FileServerPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default FileServerPrx ice_preferSecure(boolean b)
    {
        return (FileServerPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default FileServerPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (FileServerPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default FileServerPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (FileServerPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default FileServerPrx ice_collocationOptimized(boolean b)
    {
        return (FileServerPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default FileServerPrx ice_twoway()
    {
        return (FileServerPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default FileServerPrx ice_oneway()
    {
        return (FileServerPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default FileServerPrx ice_batchOneway()
    {
        return (FileServerPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default FileServerPrx ice_datagram()
    {
        return (FileServerPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default FileServerPrx ice_batchDatagram()
    {
        return (FileServerPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default FileServerPrx ice_compress(boolean co)
    {
        return (FileServerPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default FileServerPrx ice_timeout(int t)
    {
        return (FileServerPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default FileServerPrx ice_connectionId(String connectionId)
    {
        return (FileServerPrx)_ice_connectionId(connectionId);
    }

    static String ice_staticId()
    {
        return "::IcePatch2::FileServer";
    }
}
