// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 *
 * @see Session
 * @see AdminSession
 *
 **/
public interface RegistryPrx extends Ice.ObjectPrx
{
    /**
     * Create a client session.
     *
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSession(String userId, String password)
        throws PermissionDeniedException;

    /**
     * Create a client session.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSession(String userId, String password, java.util.Map<String, String> context)
        throws PermissionDeniedException;

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> context);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Ice.Callback cb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Callback_Registry_createSession cb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> context, Callback_Registry_createSession cb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId,
                                               String password,
                                               IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId,
                                               String password,
                                               IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId,
                                               String password,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a client session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId,
                                               String password,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a client session.
     *
     * @param result The asynchronous result object.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx end_createSession(Ice.AsyncResult result)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     *
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSession(String userId, String password)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSession(String userId, String password, java.util.Map<String, String> context)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> context);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, Ice.Callback cb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, Callback_Registry_createAdminSession cb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> context, Callback_Registry_createAdminSession cb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId,
                                                    String password,
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId,
                                                    String password,
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId,
                                                    String password,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create an administrative session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId,
                                                    String password,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create an administrative session.
     *
     * @param result The asynchronous result object.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx end_createAdminSession(Ice.AsyncResult result)
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     *
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSessionFromSecureConnection()
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSessionFromSecureConnection(java.util.Map<String, String> context)
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection();

    /**
     * Create a client session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> context);

    /**
     * Create a client session from a secure connection.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Ice.Callback cb);

    /**
     * Create a client session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Create a client session from a secure connection.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Callback_Registry_createSessionFromSecureConnection cb);

    /**
     * Create a client session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> context, Callback_Registry_createSessionFromSecureConnection cb);

    /**
     * Create a client session from a secure connection.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a client session from a secure connection.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a client session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> context,
                                                                   IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a client session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> context,
                                                                   IceInternal.Functional_GenericCallback1<SessionPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a client session from a secure connection.
     *
     * @param result The asynchronous result object.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx end_createSessionFromSecureConnection(Ice.AsyncResult result)
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     *
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSessionFromSecureConnection()
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSessionFromSecureConnection(java.util.Map<String, String> context)
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection();

    /**
     * Create an administrative session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> context);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(Ice.Callback cb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(Callback_Registry_createAdminSessionFromSecureConnection cb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> context, Callback_Registry_createAdminSessionFromSecureConnection cb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> context,
                                                                        IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> context,
                                                                        IceInternal.Functional_GenericCallback1<AdminSessionPrx> responseCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create an administrative session from a secure connection.
     *
     * @param result The asynchronous result object.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx end_createAdminSessionFromSecureConnection(Ice.AsyncResult result)
        throws PermissionDeniedException;

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     *
     * @return The timeout (in seconds).
     *
     **/
    public int getSessionTimeout();

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     *
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     *
     **/
    public int getSessionTimeout(java.util.Map<String, String> context);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout();

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> context);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Ice.Callback cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Callback_Registry_getSessionTimeout cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> context, Callback_Registry_getSessionTimeout cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(IceInternal.Functional_IntCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(IceInternal.Functional_IntCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> context,
                                                   IceInternal.Functional_IntCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> context,
                                                   IceInternal.Functional_IntCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @param result The asynchronous result object.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     *
     * @return The timeout (in seconds).
     *
     **/
    public int end_getSessionTimeout(Ice.AsyncResult result);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @return The timeout (in seconds).
     *
     **/
    public int getACMTimeout();

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     *
     **/
    public int getACMTimeout(java.util.Map<String, String> context);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout();

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> context);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(Ice.Callback cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(Callback_Registry_getACMTimeout cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> context, Callback_Registry_getACMTimeout cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(IceInternal.Functional_IntCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(IceInternal.Functional_IntCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> context,
                                               IceInternal.Functional_IntCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> context,
                                               IceInternal.Functional_IntCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param result The asynchronous result object.
     * @return The timeout (in seconds).
     *
     **/
    public int end_getACMTimeout(Ice.AsyncResult result);
}
