// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IcePatch2;

/**
 * The interface that provides access to files.
 *
 **/
public interface _FileServerOperations
{
    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param current The Current object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    FileInfo[] getFileInfoSeq(int partition, Ice.Current current)
        throws FileSizeRangeException,
               PartitionOutOfRangeException;

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param current The Current object for the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     **/
    LargeFileInfo[] getLargeFileInfoSeq(int partition, Ice.Current current)
        throws PartitionOutOfRangeException;

    /**
     * Return the checksums for all partitions.
     *
     * @param current The Current object for the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     *
     **/
    byte[][] getChecksumSeq(Ice.Current current);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param current The Current object for the invocation.
     * @return The master checksum for the file set.
     *
     **/
    byte[] getChecksum(Ice.Current current);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param cb The callback object for the operation.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param current The Current object for the invocation.
     * @throws FileAccessException If an error occurred while trying to read the file.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    void getFileCompressed_async(AMD_FileServer_getFileCompressed cb, String path, int pos, int num, Ice.Current current)
        throws FileAccessException,
               FileSizeRangeException;

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param cb The callback object for the operation.
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param current The Current object for the invocation.
     * @throws FileAccessException If an error occurred while trying to read the file.
     *
     **/
    void getLargeFileCompressed_async(AMD_FileServer_getLargeFileCompressed cb, String path, long pos, int num, Ice.Current current)
        throws FileAccessException;
}
