/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import java.util.AbstractList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevObject;

public class RevObjectList<E extends RevObject>
extends AbstractList<E> {
    static final int BLOCK_SHIFT = 8;
    static final int BLOCK_SIZE = 256;
    protected Block contents = new Block(0);
    protected int size = 0;

    @Override
    public void add(int index2, E element) {
        if (index2 != this.size) {
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().unsupportedOperationNotAddAtEnd, index2));
        }
        this.set(index2, element);
        ++this.size;
    }

    @Override
    public E set(int index2, E element) {
        Block s = this.contents;
        while (index2 >> s.shift >= 256) {
            s = new Block(s.shift + 8);
            s.contents[0] = this.contents;
            this.contents = s;
        }
        while (s.shift > 0) {
            int i = index2 >> s.shift;
            index2 -= i << s.shift;
            if (s.contents[i] == null) {
                s.contents[i] = new Block(s.shift - 8);
            }
            s = (Block)s.contents[i];
        }
        Object old = s.contents[index2];
        s.contents[index2] = element;
        return (E)((RevObject)old);
    }

    @Override
    public E get(int index2) {
        Block s = this.contents;
        if (index2 >> s.shift >= 1024) {
            return null;
        }
        while (s != null && s.shift > 0) {
            int i = index2 >> s.shift;
            index2 -= i << s.shift;
            s = (Block)s.contents[i];
        }
        return (E)(s != null ? (RevObject)s.contents[index2] : null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.contents = new Block(0);
        this.size = 0;
    }

    protected static class Block {
        final Object[] contents = new Object[256];
        final int shift;

        Block(int s) {
            this.shift = s;
        }
    }
}

